/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.HighlightResultOption;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface HighlightResult {
    public static HighlightResult of(Map<String, HighlightResultOption> value) {
        return new MapOfStringHighlightResultOptionWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class MapOfStringHighlightResultOptionWrapper
    implements HighlightResult {
        private final Map<String, HighlightResultOption> value;

        MapOfStringHighlightResultOptionWrapper(Map<String, HighlightResultOption> value) {
            this.value = value;
        }

        public Map<String, HighlightResultOption> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<MapOfStringHighlightResultOptionWrapper> {
            Serializer() {
            }

            public void serialize(MapOfStringHighlightResultOptionWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<HighlightResult> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public HighlightResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("matchLevel") && tree.has("value") && tree.has("matchedWords")) {
                HighlightResult highlightResult;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        highlightResult = (HighlightResult)parser.readValueAs(HighlightResultOption.class);
                        if (parser == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf HighlightResultOption (error: " + e.getMessage() + ") (type: HighlightResultOption)");
                        }
                    }
                    parser.close();
                }
                return highlightResult;
            }
            if (tree.isObject()) {
                MapOfStringHighlightResultOptionWrapper mapOfStringHighlightResultOptionWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Map value = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, HighlightResultOption>>(){});
                        mapOfStringHighlightResultOptionWrapper = new MapOfStringHighlightResultOptionWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Map<String, HighlightResultOption> (error: " + e.getMessage() + ") (type: Map<String, HighlightResultOption>)");
                        }
                    }
                    parser.close();
                }
                return mapOfStringHighlightResultOptionWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public HighlightResult getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "HighlightResult cannot be null");
        }
    }
}

