/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.MixedSearchFilters;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface ReRankingApplyFilter {
    public static ReRankingApplyFilter of(List<MixedSearchFilters> value) {
        return new ListOfMixedSearchFiltersWrapper(value);
    }

    public static ReRankingApplyFilter of(String value) {
        return new StringWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class ListOfMixedSearchFiltersWrapper
    implements ReRankingApplyFilter {
        private final List<MixedSearchFilters> value;

        ListOfMixedSearchFiltersWrapper(List<MixedSearchFilters> value) {
            this.value = value;
        }

        public List<MixedSearchFilters> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<ListOfMixedSearchFiltersWrapper> {
            Serializer() {
            }

            public void serialize(ListOfMixedSearchFiltersWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class StringWrapper
    implements ReRankingApplyFilter {
        private final String value;

        StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<StringWrapper> {
            Serializer() {
            }

            public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<ReRankingApplyFilter> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public ReRankingApplyFilter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isArray()) {
                ListOfMixedSearchFiltersWrapper listOfMixedSearchFiltersWrapper;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<MixedSearchFilters>>(){});
                        listOfMixedSearchFiltersWrapper = new ListOfMixedSearchFiltersWrapper(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<MixedSearchFilters> (error: " + e.getMessage() + ") (type: List<MixedSearchFilters>)");
                        }
                    }
                    parser.close();
                }
                return listOfMixedSearchFiltersWrapper;
            }
            if (tree.isTextual()) {
                StringWrapper stringWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs(String.class);
                        stringWrapper = new StringWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return stringWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public ReRankingApplyFilter getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return null;
        }
    }
}

