/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.SearchForFacetValuesResponse;
import com.algolia.model.search.SearchResponse;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface SearchResult<T> {

    public static class Deserializer<T>
    extends JsonDeserializer<SearchResult<T>> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public SearchResult<T> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("facetHits")) {
                SearchResult searchResult;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        searchResult = (SearchResult)parser.readValueAs(SearchForFacetValuesResponse.class);
                        if (parser == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchForFacetValuesResponse (error: " + e.getMessage() + ") (type: SearchForFacetValuesResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            if (tree.isObject()) {
                SearchResult searchResult;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        searchResult = (SearchResult)parser.readValueAs(new TypeReference<SearchResponse<T>>(){});
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchResponse (error: " + e.getMessage() + ") (type: SearchResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public SearchResult<T> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "SearchResult cannot be null");
        }
    }
}

