/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.monitoring;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Metric {
    AVG_BUILD_TIME("avg_build_time"),
    SSD_USAGE("ssd_usage"),
    RAM_SEARCH_USAGE("ram_search_usage"),
    RAM_INDEXING_USAGE("ram_indexing_usage"),
    CPU_USAGE("cpu_usage"),
    ALL("*");

    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Metric fromValue(String value) {
        for (Metric b : Metric.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

