// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** SecuredAPIKeyRestrictions */
public class SecuredAPIKeyRestrictions {

  @JsonProperty("searchParams")
  private SearchParamsObject searchParams;

  @JsonProperty("filters")
  private String filters;

  @JsonProperty("validUntil")
  private Long validUntil;

  @JsonProperty("restrictIndices")
  private List<String> restrictIndices;

  @JsonProperty("restrictSources")
  private String restrictSources;

  @JsonProperty("userToken")
  private String userToken;

  public SecuredAPIKeyRestrictions setSearchParams(SearchParamsObject searchParams) {
    this.searchParams = searchParams;
    return this;
  }

  /** Get searchParams */
  @javax.annotation.Nullable
  public SearchParamsObject getSearchParams() {
    return searchParams;
  }

  public SecuredAPIKeyRestrictions setFilters(String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * Filters that apply to every search made with the secured API key. You can add extra filters at
   * search time with the filters query parameter. For example, if you set the filter group:admin on
   * your generated API key, and you add groups:press OR groups:visitors with the filters query
   * parameter, your final search filter is equivalent to groups:admin AND (groups:press OR
   * groups:visitors).
   */
  @javax.annotation.Nullable
  public String getFilters() {
    return filters;
  }

  public SecuredAPIKeyRestrictions setValidUntil(Long validUntil) {
    this.validUntil = validUntil;
    return this;
  }

  /** Unix timestamp used to set the expiration date of the API key. */
  @javax.annotation.Nullable
  public Long getValidUntil() {
    return validUntil;
  }

  public SecuredAPIKeyRestrictions setRestrictIndices(List<String> restrictIndices) {
    this.restrictIndices = restrictIndices;
    return this;
  }

  public SecuredAPIKeyRestrictions addRestrictIndices(String restrictIndicesItem) {
    if (this.restrictIndices == null) {
      this.restrictIndices = new ArrayList<>();
    }
    this.restrictIndices.add(restrictIndicesItem);
    return this;
  }

  /** Index names that can be queried. */
  @javax.annotation.Nullable
  public List<String> getRestrictIndices() {
    return restrictIndices;
  }

  public SecuredAPIKeyRestrictions setRestrictSources(String restrictSources) {
    this.restrictSources = restrictSources;
    return this;
  }

  /**
   * IPv4 network allowed to use the generated key. Use this to protect against API key leaking and
   * reuse. You can only provide a single source, but you can specify a range of IPs (for example,
   * 192.168.1.0/24).
   */
  @javax.annotation.Nullable
  public String getRestrictSources() {
    return restrictSources;
  }

  public SecuredAPIKeyRestrictions setUserToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

  /**
   * Unique user IP address. This can be useful when you want to impose a rate limit on specific
   * users. By default, rate limits are set based on the IP address. This can become an issue when
   * several users search from the same IP address. To avoid this, you can set a unique userToken
   * for each user when generating their API key. This lets you restrict each user to a maximum
   * number of API calls per hour, even if they share their IP with another user. Specifying the
   * userToken in a secured API key is also a good security practice as it ensures users don't
   * change it. Many features like Analytics, Personalization, and Dynamic Re-ranking rely on the
   * authenticity of user identifiers. Setting the userToken at the API key level ensures that
   * downstream services work as expected and prevents abuse.
   */
  @javax.annotation.Nullable
  public String getUserToken() {
    return userToken;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecuredAPIKeyRestrictions securedAPIKeyRestrictions = (SecuredAPIKeyRestrictions) o;
    return (
      Objects.equals(this.searchParams, securedAPIKeyRestrictions.searchParams) &&
      Objects.equals(this.filters, securedAPIKeyRestrictions.filters) &&
      Objects.equals(this.validUntil, securedAPIKeyRestrictions.validUntil) &&
      Objects.equals(this.restrictIndices, securedAPIKeyRestrictions.restrictIndices) &&
      Objects.equals(this.restrictSources, securedAPIKeyRestrictions.restrictSources) &&
      Objects.equals(this.userToken, securedAPIKeyRestrictions.userToken)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchParams, filters, validUntil, restrictIndices, restrictSources, userToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecuredAPIKeyRestrictions {\n");
    sb.append("    searchParams: ").append(toIndentedString(searchParams)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    validUntil: ").append(toIndentedString(validUntil)).append("\n");
    sb.append("    restrictIndices: ").append(toIndentedString(restrictIndices)).append("\n");
    sb.append("    restrictSources: ").append(toIndentedString(restrictSources)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
