// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.ingestion.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class IngestionClient extends ApiClient {

  private static final String[] allowedRegions = { "eu", "us" };

  public IngestionClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public IngestionClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "Ingestion", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = false;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (region == null || !found) {
      throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
    }

    String url = "data.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * Create a authentication.
   *
   * @param authenticationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationCreateResponse createAuthentication(
    @Nonnull AuthenticationCreate authenticationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createAuthenticationAsync(authenticationCreate, requestOptions));
  }

  /**
   * Create a authentication.
   *
   * @param authenticationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationCreateResponse createAuthentication(@Nonnull AuthenticationCreate authenticationCreate)
    throws AlgoliaRuntimeException {
    return this.createAuthentication(authenticationCreate, null);
  }

  /**
   * (asynchronously) Create a authentication.
   *
   * @param authenticationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(
    @Nonnull AuthenticationCreate authenticationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationCreate, "Parameter `authenticationCreate` is required when calling `createAuthentication`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/authentications").setMethod("POST").setBody(authenticationCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<AuthenticationCreateResponse>() {});
  }

  /**
   * (asynchronously) Create a authentication.
   *
   * @param authenticationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(@Nonnull AuthenticationCreate authenticationCreate)
    throws AlgoliaRuntimeException {
    return this.createAuthenticationAsync(authenticationCreate, null);
  }

  /**
   * Create a destination.
   *
   * @param destinationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createDestinationAsync(destinationCreate, requestOptions));
  }

  /**
   * Create a destination.
   *
   * @param destinationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate) throws AlgoliaRuntimeException {
    return this.createDestination(destinationCreate, null);
  }

  /**
   * (asynchronously) Create a destination.
   *
   * @param destinationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationCreateResponse> createDestinationAsync(
    @Nonnull DestinationCreate destinationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationCreate, "Parameter `destinationCreate` is required when calling `createDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations").setMethod("POST").setBody(destinationCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<DestinationCreateResponse>() {});
  }

  /**
   * (asynchronously) Create a destination.
   *
   * @param destinationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationCreateResponse> createDestinationAsync(@Nonnull DestinationCreate destinationCreate)
    throws AlgoliaRuntimeException {
    return this.createDestinationAsync(destinationCreate, null);
  }

  /**
   * Create a source.
   *
   * @param sourceCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createSourceAsync(sourceCreate, requestOptions));
  }

  /**
   * Create a source.
   *
   * @param sourceCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.createSource(sourceCreate, null);
  }

  /**
   * (asynchronously) Create a source.
   *
   * @param sourceCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceCreate, "Parameter `sourceCreate` is required when calling `createSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources").setMethod("POST").setBody(sourceCreate).build();

    return executeAsync(request, requestOptions, new TypeReference<SourceCreateResponse>() {});
  }

  /**
   * (asynchronously) Create a source.
   *
   * @param sourceCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.createSourceAsync(sourceCreate, null);
  }

  /**
   * Create a task.
   *
   * @param taskCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createTaskAsync(taskCreate, requestOptions));
  }

  /**
   * Create a task.
   *
   * @param taskCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
    return this.createTask(taskCreate, null);
  }

  /**
   * (asynchronously) Create a task.
   *
   * @param taskCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskCreate, "Parameter `taskCreate` is required when calling `createTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks").setMethod("POST").setBody(taskCreate).build();

    return executeAsync(request, requestOptions, new TypeReference<TaskCreateResponse>() {});
  }

  /**
   * (asynchronously) Create a task.
   *
   * @param taskCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
    return this.createTaskAsync(taskCreate, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Soft delete the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteAuthenticationAsync(authenticationID, requestOptions));
  }

  /**
   * Soft delete the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.deleteAuthentication(authenticationID, null);
  }

  /**
   * (asynchronously) Soft delete the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `deleteAuthentication`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/{authenticationID}", authenticationID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Soft delete the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.deleteAuthenticationAsync(authenticationID, null);
  }

  /**
   * Soft delete the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteDestinationAsync(destinationID, requestOptions));
  }

  /**
   * Soft delete the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.deleteDestination(destinationID, null);
  }

  /**
   * (asynchronously) Soft delete the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `deleteDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Soft delete the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.deleteDestinationAsync(destinationID, null);
  }

  /**
   * Soft delete the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteSourceAsync(sourceID, requestOptions));
  }

  /**
   * Soft delete the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.deleteSource(sourceID, null);
  }

  /**
   * (asynchronously) Soft delete the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `deleteSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Soft delete the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.deleteSourceAsync(sourceID, null);
  }

  /**
   * Soft delete the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteTaskAsync(taskID, requestOptions));
  }

  /**
   * Soft delete the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.deleteTask(taskID, null);
  }

  /**
   * (asynchronously) Soft delete the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `deleteTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("DELETE").build();

    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Soft delete the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.deleteTaskAsync(taskID, null);
  }

  /**
   * Disable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse disableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(disableTaskAsync(taskID, requestOptions));
  }

  /**
   * Disable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse disableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.disableTask(taskID, null);
  }

  /**
   * (asynchronously) Disable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `disableTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/disable", taskID).setMethod("PUT").build();

    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Disable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.disableTaskAsync(taskID, null);
  }

  /**
   * Enable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse enableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(enableTaskAsync(taskID, requestOptions));
  }

  /**
   * Enable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse enableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.enableTask(taskID, null);
  }

  /**
   * (asynchronously) Enable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `enableTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/enable", taskID).setMethod("PUT").build();

    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Enable the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.enableTaskAsync(taskID, null);
  }

  /**
   * Get the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Authentication getAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAuthenticationAsync(authenticationID, requestOptions));
  }

  /**
   * Get the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Authentication getAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.getAuthentication(authenticationID, null);
  }

  /**
   * (asynchronously) Get the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `getAuthentication`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/authentications/{authenticationID}", authenticationID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Authentication>() {});
  }

  /**
   * (asynchronously) Get the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.getAuthenticationAsync(authenticationID, null);
  }

  /**
   * Get a list of authentications for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the authentications to retrieve. (optional)
   * @param platform The platform of the authentications to retrieve. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, requestOptions));
  }

  /**
   * Get a list of authentications for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the authentications to retrieve. (optional)
   * @param platform The platform of the authentications to retrieve. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getAuthentications(itemsPerPage, page, type, platform, sort, order, null);
  }

  /**
   * Get a list of authentications for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAuthentications(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of authentications for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications() throws AlgoliaRuntimeException {
    return this.getAuthentications(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of authentications for the given query parameters, with pagination
   * details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the authentications to retrieve. (optional)
   * @param platform The platform of the authentications to retrieve. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("platform", platform)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListAuthenticationsResponse>() {});
  }

  /**
   * (asynchronously) Get a list of authentications for the given query parameters, with pagination
   * details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the authentications to retrieve. (optional)
   * @param platform The platform of the authentications to retrieve. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, null);
  }

  /**
   * (asynchronously) Get a list of authentications for the given query parameters, with pagination
   * details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of authentications for the given query parameters, with pagination
   * details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync() throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(null, null, null, null, null, null, null);
  }

  /**
   * Get the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Destination getDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDestinationAsync(destinationID, requestOptions));
  }

  /**
   * Get the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Destination getDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.getDestination(destinationID, null);
  }

  /**
   * (asynchronously) Get the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `getDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Destination>() {});
  }

  /**
   * (asynchronously) Get the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.getDestinationAsync(destinationID, null);
  }

  /**
   * Get a list of destinations for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the destinations to retrive. (optional)
   * @param authenticationID The authenticationIDs of the destinations to retrive. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
  }

  /**
   * Get a list of destinations for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the destinations to retrive. (optional)
   * @param authenticationID The authenticationIDs of the destinations to retrive. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getDestinations(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * Get a list of destinations for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getDestinations(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of destinations for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations() throws AlgoliaRuntimeException {
    return this.getDestinations(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of destinations for the given query parameters, with pagination
   * details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the destinations to retrive. (optional)
   * @param authenticationID The authenticationIDs of the destinations to retrive. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/destinations")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("authenticationID", authenticationID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListDestinationsResponse>() {});
  }

  /**
   * (asynchronously) Get a list of destinations for the given query parameters, with pagination
   * details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the destinations to retrive. (optional)
   * @param authenticationID The authenticationIDs of the destinations to retrive. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * (asynchronously) Get a list of destinations for the given query parameters, with pagination
   * details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of destinations for the given query parameters, with pagination
   * details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync() throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(null, null, null, null, null, null, null);
  }

  /**
   * Retrieve a stream listing for a given Singer specification compatible docker type source ID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DockerSourceStreams getDockerSourceStreams(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDockerSourceStreamsAsync(sourceID, requestOptions));
  }

  /**
   * Retrieve a stream listing for a given Singer specification compatible docker type source ID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DockerSourceStreams getDockerSourceStreams(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getDockerSourceStreams(sourceID, null);
  }

  /**
   * (asynchronously) Retrieve a stream listing for a given Singer specification compatible docker
   * type source ID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DockerSourceStreams> getDockerSourceStreamsAsync(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `getDockerSourceStreams`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/discover", sourceID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<DockerSourceStreams>() {});
  }

  /**
   * (asynchronously) Retrieve a stream listing for a given Singer specification compatible docker
   * type source ID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DockerSourceStreams> getDockerSourceStreamsAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getDockerSourceStreamsAsync(sourceID, null);
  }

  /**
   * Get a single event for a specific runID.
   *
   * @param runID The run UUID. (required)
   * @param eventID The event UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Event getEvent(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getEventAsync(runID, eventID, requestOptions));
  }

  /**
   * Get a single event for a specific runID.
   *
   * @param runID The run UUID. (required)
   * @param eventID The event UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Event getEvent(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
    return this.getEvent(runID, eventID, null);
  }

  /**
   * (asynchronously) Get a single event for a specific runID.
   *
   * @param runID The run UUID. (required)
   * @param eventID The event UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getEvent`.");

    Parameters.requireNonNull(eventID, "Parameter `eventID` is required when calling `getEvent`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}/events/{eventID}", runID, eventID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Event>() {});
  }

  /**
   * (asynchronously) Get a single event for a specific runID.
   *
   * @param runID The run UUID. (required)
   * @param eventID The event UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
    return this.getEventAsync(runID, eventID, null);
  }

  /**
   * Get a list of events associated to the given runID, for the given query parameters.
   *
   * @param runID The run UUID. (required)
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the events. (optional)
   * @param type Filter the type of the events. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now'-3 hours if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now' days if omitted. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, requestOptions));
  }

  /**
   * Get a list of events associated to the given runID, for the given query parameters.
   *
   * @param runID The run UUID. (required)
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the events. (optional)
   * @param type Filter the type of the events. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now'-3 hours if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now' days if omitted. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getEvents(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
  }

  /**
   * Get a list of events associated to the given runID, for the given query parameters.
   *
   * @param runID The run UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getEvents(runID, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of events associated to the given runID, for the given query parameters.
   *
   * @param runID The run UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getEvents(runID, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of events associated to the given runID, for the given query
   * parameters.
   *
   * @param runID The run UUID. (required)
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the events. (optional)
   * @param type Filter the type of the events. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now'-3 hours if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now' days if omitted. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getEvents`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/runs/{runID}/events", runID)
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("status", status)
      .addQueryParameter("type", type)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListEventsResponse>() {});
  }

  /**
   * (asynchronously) Get a list of events associated to the given runID, for the given query
   * parameters.
   *
   * @param runID The run UUID. (required)
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the events. (optional)
   * @param type Filter the type of the events. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now'-3 hours if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the events fetching window. Defaults to
   *     'now' days if omitted. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
  }

  /**
   * (asynchronously) Get a list of events associated to the given runID, for the given query
   * parameters.
   *
   * @param runID The run UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(@Nonnull String runID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of events associated to the given runID, for the given query
   * parameters.
   *
   * @param runID The run UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Get a single run for the given ID.
   *
   * @param runID The run UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Run getRun(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRunAsync(runID, requestOptions));
  }

  /**
   * Get a single run for the given ID.
   *
   * @param runID The run UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Run getRun(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getRun(runID, null);
  }

  /**
   * (asynchronously) Get a single run for the given ID.
   *
   * @param runID The run UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Run> getRunAsync(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getRun`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}", runID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Run>() {});
  }

  /**
   * (asynchronously) Get a single run for the given ID.
   *
   * @param runID The run UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Run> getRunAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getRunAsync(runID, null);
  }

  /**
   * Get a list of runs for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the runs. (optional)
   * @param taskID Filter by taskID. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the runs fetching window. Defaults to
   *     'now'-7 days if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now'
   *     days if omitted. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRunsAsync(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, requestOptions));
  }

  /**
   * Get a list of runs for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the runs. (optional)
   * @param taskID Filter by taskID. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the runs fetching window. Defaults to
   *     'now'-7 days if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now'
   *     days if omitted. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getRuns(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, null);
  }

  /**
   * Get a list of runs for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getRuns(null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of runs for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns() throws AlgoliaRuntimeException {
    return this.getRuns(null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of runs for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the runs. (optional)
   * @param taskID Filter by taskID. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the runs fetching window. Defaults to
   *     'now'-7 days if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now'
   *     days if omitted. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/runs")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("status", status)
      .addQueryParameter("taskID", taskID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<RunListResponse>() {});
  }

  /**
   * (asynchronously) Get a list of runs for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param status Filter the status of the runs. (optional)
   * @param taskID Filter by taskID. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param startDate The start date (in RFC3339 format) of the runs fetching window. Defaults to
   *     'now'-7 days if omitted. (optional)
   * @param endDate The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now'
   *     days if omitted. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getRunsAsync(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, null);
  }

  /**
   * (asynchronously) Get a list of runs for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getRunsAsync(null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of runs for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync() throws AlgoliaRuntimeException {
    return this.getRunsAsync(null, null, null, null, null, null, null, null, null);
  }

  /**
   * Get the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Source getSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSourceAsync(sourceID, requestOptions));
  }

  /**
   * Get the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Source getSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getSource(sourceID, null);
  }

  /**
   * (asynchronously) Get the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `getSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Source>() {});
  }

  /**
   * (asynchronously) Get the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getSourceAsync(sourceID, null);
  }

  /**
   * Get a list of sources for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the sources to retrieve. (optional)
   * @param authenticationID The authenticationIDs of the sources to retrieve. 'none' returns
   *     sources that doesn't have an authentication. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
  }

  /**
   * Get a list of sources for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the sources to retrieve. (optional)
   * @param authenticationID The authenticationIDs of the sources to retrieve. 'none' returns
   *     sources that doesn't have an authentication. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getSources(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * Get a list of sources for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSources(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of sources for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources() throws AlgoliaRuntimeException {
    return this.getSources(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of sources for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the sources to retrieve. (optional)
   * @param authenticationID The authenticationIDs of the sources to retrieve. 'none' returns
   *     sources that doesn't have an authentication. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/sources")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("authenticationID", authenticationID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListSourcesResponse>() {});
  }

  /**
   * (asynchronously) Get a list of sources for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param type The type of the sources to retrieve. (optional)
   * @param authenticationID The authenticationIDs of the sources to retrieve. 'none' returns
   *     sources that doesn't have an authentication. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * (asynchronously) Get a list of sources for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSourcesAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of sources for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync() throws AlgoliaRuntimeException {
    return this.getSourcesAsync(null, null, null, null, null, null, null);
  }

  /**
   * Get the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Task getTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTaskAsync(taskID, requestOptions));
  }

  /**
   * Get the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Task getTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.getTask(taskID, null);
  }

  /**
   * (asynchronously) Get the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Task>() {});
  }

  /**
   * (asynchronously) Get the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.getTaskAsync(taskID, null);
  }

  /**
   * Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param action The action of the tasks to retrieve. (optional)
   * @param enabled Whether the task is enabled or not. (optional)
   * @param sourceID The sourceIDs of the tasks to retrieve. (optional)
   * @param destinationID The destinationIDs of the tasks to retrieve. (optional)
   * @param triggerType The trigger type of the task. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, requestOptions)
    );
  }

  /**
   * Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param action The action of the tasks to retrieve. (optional)
   * @param enabled Whether the task is enabled or not. (optional)
   * @param sourceID The sourceIDs of the tasks to retrieve. (optional)
   * @param destinationID The destinationIDs of the tasks to retrieve. (optional)
   * @param triggerType The trigger type of the task. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getTasks(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
  }

  /**
   * Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTasks(null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Get a list of tasks for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks() throws AlgoliaRuntimeException {
    return this.getTasks(null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param action The action of the tasks to retrieve. (optional)
   * @param enabled Whether the task is enabled or not. (optional)
   * @param sourceID The sourceIDs of the tasks to retrieve. (optional)
   * @param destinationID The destinationIDs of the tasks to retrieve. (optional)
   * @param triggerType The trigger type of the task. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/tasks")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("action", action)
      .addQueryParameter("enabled", enabled)
      .addQueryParameter("sourceID", sourceID)
      .addQueryParameter("destinationID", destinationID)
      .addQueryParameter("triggerType", triggerType)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListTasksResponse>() {});
  }

  /**
   * (asynchronously) Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param itemsPerPage The number of items per page to return. (optional)
   * @param page The page number to fetch, starting at 1. (optional)
   * @param action The action of the tasks to retrieve. (optional)
   * @param enabled Whether the task is enabled or not. (optional)
   * @param sourceID The sourceIDs of the tasks to retrieve. (optional)
   * @param destinationID The destinationIDs of the tasks to retrieve. (optional)
   * @param triggerType The trigger type of the task. (optional)
   * @param sort The key by which the list should be sorted. (optional)
   * @param order The order of the returned list. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
  }

  /**
   * (asynchronously) Get a list of tasks for the given query parameters, with pagination details.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTasksAsync(null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Get a list of tasks for the given query parameters, with pagination details.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync() throws AlgoliaRuntimeException {
    return this.getTasksAsync(null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Run the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunResponse runTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(runTaskAsync(taskID, requestOptions));
  }

  /**
   * Run the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunResponse runTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.runTask(taskID, null);
  }

  /**
   * (asynchronously) Run the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `runTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/run", taskID).setMethod("POST").build();

    return executeAsync(request, requestOptions, new TypeReference<RunResponse>() {});
  }

  /**
   * (asynchronously) Run the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.runTaskAsync(taskID, null);
  }

  /**
   * Search among authentications with a defined set of parameters.
   *
   * @param authenticationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchAuthenticationsAsync(authenticationSearch, requestOptions));
  }

  /**
   * Search among authentications with a defined set of parameters.
   *
   * @param authenticationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch) throws AlgoliaRuntimeException {
    return this.searchAuthentications(authenticationSearch, null);
  }

  /**
   * (asynchronously) Search among authentications with a defined set of parameters.
   *
   * @param authenticationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(
    @Nonnull AuthenticationSearch authenticationSearch,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationSearch, "Parameter `authenticationSearch` is required when calling `searchAuthentications`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/search")
      .setMethod("POST")
      .setBody(authenticationSearch)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<List<Authentication>>() {});
  }

  /**
   * (asynchronously) Search among authentications with a defined set of parameters.
   *
   * @param authenticationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(@Nonnull AuthenticationSearch authenticationSearch)
    throws AlgoliaRuntimeException {
    return this.searchAuthenticationsAsync(authenticationSearch, null);
  }

  /**
   * Search among destinations with a defined set of parameters.
   *
   * @param destinationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchDestinationsAsync(destinationSearch, requestOptions));
  }

  /**
   * Search among destinations with a defined set of parameters.
   *
   * @param destinationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch) throws AlgoliaRuntimeException {
    return this.searchDestinations(destinationSearch, null);
  }

  /**
   * (asynchronously) Search among destinations with a defined set of parameters.
   *
   * @param destinationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Destination>> searchDestinationsAsync(
    @Nonnull DestinationSearch destinationSearch,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationSearch, "Parameter `destinationSearch` is required when calling `searchDestinations`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/search").setMethod("POST").setBody(destinationSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Destination>>() {});
  }

  /**
   * (asynchronously) Search among destinations with a defined set of parameters.
   *
   * @param destinationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Destination>> searchDestinationsAsync(@Nonnull DestinationSearch destinationSearch)
    throws AlgoliaRuntimeException {
    return this.searchDestinationsAsync(destinationSearch, null);
  }

  /**
   * Search among sources with a defined set of parameters.
   *
   * @param sourceSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> searchSources(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchSourcesAsync(sourceSearch, requestOptions));
  }

  /**
   * Search among sources with a defined set of parameters.
   *
   * @param sourceSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> searchSources(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
    return this.searchSources(sourceSearch, null);
  }

  /**
   * (asynchronously) Search among sources with a defined set of parameters.
   *
   * @param sourceSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceSearch, "Parameter `sourceSearch` is required when calling `searchSources`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/search").setMethod("POST").setBody(sourceSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Source>>() {});
  }

  /**
   * (asynchronously) Search among sources with a defined set of parameters.
   *
   * @param sourceSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
    return this.searchSourcesAsync(sourceSearch, null);
  }

  /**
   * Search among tasks with a defined set of parameters.
   *
   * @param taskSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Task> searchTasks(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchTasksAsync(taskSearch, requestOptions));
  }

  /**
   * Search among tasks with a defined set of parameters.
   *
   * @param taskSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Task> searchTasks(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
    return this.searchTasks(taskSearch, null);
  }

  /**
   * (asynchronously) Search among tasks with a defined set of parameters.
   *
   * @param taskSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskSearch, "Parameter `taskSearch` is required when calling `searchTasks`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/search").setMethod("POST").setBody(taskSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Task>>() {});
  }

  /**
   * (asynchronously) Search among tasks with a defined set of parameters.
   *
   * @param taskSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
    return this.searchTasksAsync(taskSearch, null);
  }

  /**
   * Trigger a stream listing request for a Singer specification compatible docker type source.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DockerSourceDiscover triggerDockerSourceDiscover(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(triggerDockerSourceDiscoverAsync(sourceID, requestOptions));
  }

  /**
   * Trigger a stream listing request for a Singer specification compatible docker type source.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DockerSourceDiscover triggerDockerSourceDiscover(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.triggerDockerSourceDiscover(sourceID, null);
  }

  /**
   * (asynchronously) Trigger a stream listing request for a Singer specification compatible docker
   * type source.
   *
   * @param sourceID The source UUID. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DockerSourceDiscover> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `triggerDockerSourceDiscover`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/discover", sourceID).setMethod("POST").build();
    return executeAsync(request, requestOptions, new TypeReference<DockerSourceDiscover>() {});
  }

  /**
   * (asynchronously) Trigger a stream listing request for a Singer specification compatible docker
   * type source.
   *
   * @param sourceID The source UUID. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DockerSourceDiscover> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.triggerDockerSourceDiscoverAsync(sourceID, null);
  }

  /**
   * Update the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param authenticationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationUpdateResponse updateAuthentication(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateAuthenticationAsync(authenticationID, authenticationUpdate, requestOptions));
  }

  /**
   * Update the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param authenticationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationUpdateResponse updateAuthentication(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateAuthentication(authenticationID, authenticationUpdate, null);
  }

  /**
   * (asynchronously) Update the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param authenticationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `updateAuthentication`.");

    Parameters.requireNonNull(authenticationUpdate, "Parameter `authenticationUpdate` is required when calling `updateAuthentication`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/{authenticationID}", authenticationID)
      .setMethod("PATCH")
      .setBody(authenticationUpdate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<AuthenticationUpdateResponse>() {});
  }

  /**
   * (asynchronously) Update the authentication of the given authenticationID.
   *
   * @param authenticationID The authentication UUID. (required)
   * @param authenticationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateAuthenticationAsync(authenticationID, authenticationUpdate, null);
  }

  /**
   * Update the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param destinationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationUpdateResponse updateDestination(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateDestinationAsync(destinationID, destinationUpdate, requestOptions));
  }

  /**
   * Update the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param destinationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationUpdateResponse updateDestination(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate)
    throws AlgoliaRuntimeException {
    return this.updateDestination(destinationID, destinationUpdate, null);
  }

  /**
   * (asynchronously) Update the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param destinationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `updateDestination`.");

    Parameters.requireNonNull(destinationUpdate, "Parameter `destinationUpdate` is required when calling `updateDestination`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/destinations/{destinationID}", destinationID)
      .setMethod("PATCH")
      .setBody(destinationUpdate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DestinationUpdateResponse>() {});
  }

  /**
   * (asynchronously) Update the destination of the given destinationID.
   *
   * @param destinationID The destination UUID. (required)
   * @param destinationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateDestinationAsync(destinationID, destinationUpdate, null);
  }

  /**
   * Update the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateSourceAsync(sourceID, sourceUpdate, requestOptions));
  }

  /**
   * Update the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
    return this.updateSource(sourceID, sourceUpdate, null);
  }

  /**
   * (asynchronously) Update the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceUpdateResponse> updateSourceAsync(
    @Nonnull String sourceID,
    @Nonnull SourceUpdate sourceUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `updateSource`.");

    Parameters.requireNonNull(sourceUpdate, "Parameter `sourceUpdate` is required when calling `updateSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("PATCH").setBody(sourceUpdate).build();
    return executeAsync(request, requestOptions, new TypeReference<SourceUpdateResponse>() {});
  }

  /**
   * (asynchronously) Update the source of the given sourceID.
   *
   * @param sourceID The source UUID. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceUpdateResponse> updateSourceAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate)
    throws AlgoliaRuntimeException {
    return this.updateSourceAsync(sourceID, sourceUpdate, null);
  }

  /**
   * Update the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param taskUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateTaskAsync(taskID, taskUpdate, requestOptions));
  }

  /**
   * Update the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param taskUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate) throws AlgoliaRuntimeException {
    return this.updateTask(taskID, taskUpdate, null);
  }

  /**
   * (asynchronously) Update the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param taskUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> updateTaskAsync(
    @Nonnull String taskID,
    @Nonnull TaskUpdate taskUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `updateTask`.");

    Parameters.requireNonNull(taskUpdate, "Parameter `taskUpdate` is required when calling `updateTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("PATCH").setBody(taskUpdate).build();
    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Update the task of the given taskID.
   *
   * @param taskID The task UUID. (required)
   * @param taskUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> updateTaskAsync(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate)
    throws AlgoliaRuntimeException {
    return this.updateTaskAsync(taskID, taskUpdate, null);
  }
}
