// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ConsequenceParams */
public class ConsequenceParams {

  @JsonProperty("similarQuery")
  private String similarQuery;

  @JsonProperty("filters")
  private String filters;

  @JsonProperty("facetFilters")
  private FacetFilters facetFilters;

  @JsonProperty("optionalFilters")
  private OptionalFilters optionalFilters;

  @JsonProperty("numericFilters")
  private NumericFilters numericFilters;

  @JsonProperty("tagFilters")
  private TagFilters tagFilters;

  @JsonProperty("sumOrFiltersScores")
  private Boolean sumOrFiltersScores;

  @JsonProperty("restrictSearchableAttributes")
  private List<String> restrictSearchableAttributes;

  @JsonProperty("facets")
  private List<String> facets;

  @JsonProperty("facetingAfterDistinct")
  private Boolean facetingAfterDistinct;

  @JsonProperty("page")
  private Integer page;

  @JsonProperty("offset")
  private Integer offset;

  @JsonProperty("length")
  private Integer length;

  @JsonProperty("aroundLatLng")
  private String aroundLatLng;

  @JsonProperty("aroundLatLngViaIP")
  private Boolean aroundLatLngViaIP;

  @JsonProperty("aroundRadius")
  private AroundRadius aroundRadius;

  @JsonProperty("aroundPrecision")
  private AroundPrecision aroundPrecision;

  @JsonProperty("minimumAroundRadius")
  private Integer minimumAroundRadius;

  @JsonProperty("insideBoundingBox")
  private List<List<Double>> insideBoundingBox;

  @JsonProperty("insidePolygon")
  private List<List<Double>> insidePolygon;

  @JsonProperty("naturalLanguages")
  private List<String> naturalLanguages;

  @JsonProperty("ruleContexts")
  private List<String> ruleContexts;

  @JsonProperty("personalizationImpact")
  private Integer personalizationImpact;

  @JsonProperty("userToken")
  private String userToken;

  @JsonProperty("getRankingInfo")
  private Boolean getRankingInfo;

  @JsonProperty("synonyms")
  private Boolean synonyms;

  @JsonProperty("clickAnalytics")
  private Boolean clickAnalytics;

  @JsonProperty("analytics")
  private Boolean analytics;

  @JsonProperty("analyticsTags")
  private List<String> analyticsTags;

  @JsonProperty("percentileComputation")
  private Boolean percentileComputation;

  @JsonProperty("enableABTest")
  private Boolean enableABTest;

  @JsonProperty("attributesToRetrieve")
  private List<String> attributesToRetrieve;

  @JsonProperty("ranking")
  private List<String> ranking;

  @JsonProperty("customRanking")
  private List<String> customRanking;

  @JsonProperty("relevancyStrictness")
  private Integer relevancyStrictness;

  @JsonProperty("attributesToHighlight")
  private List<String> attributesToHighlight;

  @JsonProperty("attributesToSnippet")
  private List<String> attributesToSnippet;

  @JsonProperty("highlightPreTag")
  private String highlightPreTag;

  @JsonProperty("highlightPostTag")
  private String highlightPostTag;

  @JsonProperty("snippetEllipsisText")
  private String snippetEllipsisText;

  @JsonProperty("restrictHighlightAndSnippetArrays")
  private Boolean restrictHighlightAndSnippetArrays;

  @JsonProperty("hitsPerPage")
  private Integer hitsPerPage;

  @JsonProperty("minWordSizefor1Typo")
  private Integer minWordSizefor1Typo;

  @JsonProperty("minWordSizefor2Typos")
  private Integer minWordSizefor2Typos;

  @JsonProperty("typoTolerance")
  private TypoTolerance typoTolerance;

  @JsonProperty("allowTyposOnNumericTokens")
  private Boolean allowTyposOnNumericTokens;

  @JsonProperty("disableTypoToleranceOnAttributes")
  private List<String> disableTypoToleranceOnAttributes;

  @JsonProperty("ignorePlurals")
  private IgnorePlurals ignorePlurals;

  @JsonProperty("removeStopWords")
  private RemoveStopWords removeStopWords;

  @JsonProperty("keepDiacriticsOnCharacters")
  private String keepDiacriticsOnCharacters;

  @JsonProperty("queryLanguages")
  private List<String> queryLanguages;

  @JsonProperty("decompoundQuery")
  private Boolean decompoundQuery;

  @JsonProperty("enableRules")
  private Boolean enableRules;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("queryType")
  private QueryType queryType;

  @JsonProperty("removeWordsIfNoResults")
  private RemoveWordsIfNoResults removeWordsIfNoResults;

  @JsonProperty("mode")
  private Mode mode;

  @JsonProperty("semanticSearch")
  private SemanticSearch semanticSearch;

  @JsonProperty("advancedSyntax")
  private Boolean advancedSyntax;

  @JsonProperty("optionalWords")
  private List<String> optionalWords;

  @JsonProperty("disableExactOnAttributes")
  private List<String> disableExactOnAttributes;

  @JsonProperty("exactOnSingleWordQuery")
  private ExactOnSingleWordQuery exactOnSingleWordQuery;

  @JsonProperty("alternativesAsExact")
  private List<AlternativesAsExact> alternativesAsExact;

  @JsonProperty("advancedSyntaxFeatures")
  private List<AdvancedSyntaxFeatures> advancedSyntaxFeatures;

  @JsonProperty("distinct")
  private Distinct distinct;

  @JsonProperty("replaceSynonymsInHighlight")
  private Boolean replaceSynonymsInHighlight;

  @JsonProperty("minProximity")
  private Integer minProximity;

  @JsonProperty("responseFields")
  private List<String> responseFields;

  @JsonProperty("maxFacetHits")
  private Integer maxFacetHits;

  @JsonProperty("maxValuesPerFacet")
  private Integer maxValuesPerFacet;

  @JsonProperty("sortFacetValuesBy")
  private String sortFacetValuesBy;

  @JsonProperty("attributeCriteriaComputedByMinProximity")
  private Boolean attributeCriteriaComputedByMinProximity;

  @JsonProperty("renderingContent")
  private RenderingContent renderingContent;

  @JsonProperty("enableReRanking")
  private Boolean enableReRanking;

  @JsonProperty("reRankingApplyFilter")
  private ReRankingApplyFilter reRankingApplyFilter;

  @JsonProperty("query")
  private ConsequenceQuery query;

  @JsonProperty("automaticFacetFilters")
  private AutomaticFacetFilters automaticFacetFilters;

  @JsonProperty("automaticOptionalFacetFilters")
  private AutomaticFacetFilters automaticOptionalFacetFilters;

  public ConsequenceParams setSimilarQuery(String similarQuery) {
    this.similarQuery = similarQuery;
    return this;
  }

  /**
   * Keywords to be used instead of the search query to conduct a more broader search. Using the
   * `similarQuery` parameter changes other settings: - `queryType` is set to `prefixNone`. -
   * `removeStopWords` is set to true. - `words` is set as the first ranking criterion. - All
   * remaining words are treated as `optionalWords`. Since the `similarQuery` is supposed to do a
   * broad search, they usually return many results. Combine it with `filters` to narrow down the
   * list of results.
   */
  @javax.annotation.Nullable
  public String getSimilarQuery() {
    return similarQuery;
  }

  public ConsequenceParams setFilters(String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * Filter the search so that only records with matching values are included in the results. These
   * filters are supported: - **Numeric filters.** `<facet> <op> <number>`, where `<op>` is one of
   * `<`, `<=`, `=`, `!=`, `>`, `>=`. - **Ranges.** `<facet>:<lower> TO <upper>` where `<lower>` and
   * `<upper>` are the lower and upper limits of the range (inclusive). - **Facet filters.**
   * `<facet>:<value>` where `<facet>` is a facet attribute (case-sensitive) and `<value>` a facet
   * value. - **Tag filters.** `_tags:<value>` or just `<value>` (case-sensitive). - **Boolean
   * filters.** `<facet>: true | false`. You can combine filters with `AND`, `OR`, and `NOT`
   * operators with the following restrictions: - You can only combine filters of the same type with
   * `OR`. **Not supported:** `facet:value OR num > 3`. - You can't use `NOT` with combinations of
   * filters. **Not supported:** `NOT(facet:value OR facet:value)` - You can't combine conjunctions
   * (`AND`) with `OR`. **Not supported:** `facet:value OR (facet:value AND facet:value)` Use quotes
   * around your filters, if the facet attribute name or facet value has spaces, keywords (`OR`,
   * `AND`, `NOT`), or quotes. If a facet attribute is an array, the filter matches if it matches at
   * least one element of the array. For more information, see
   * [Filters](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/).
   */
  @javax.annotation.Nullable
  public String getFilters() {
    return filters;
  }

  public ConsequenceParams setFacetFilters(FacetFilters facetFilters) {
    this.facetFilters = facetFilters;
    return this;
  }

  /** Get facetFilters */
  @javax.annotation.Nullable
  public FacetFilters getFacetFilters() {
    return facetFilters;
  }

  public ConsequenceParams setOptionalFilters(OptionalFilters optionalFilters) {
    this.optionalFilters = optionalFilters;
    return this;
  }

  /** Get optionalFilters */
  @javax.annotation.Nullable
  public OptionalFilters getOptionalFilters() {
    return optionalFilters;
  }

  public ConsequenceParams setNumericFilters(NumericFilters numericFilters) {
    this.numericFilters = numericFilters;
    return this;
  }

  /** Get numericFilters */
  @javax.annotation.Nullable
  public NumericFilters getNumericFilters() {
    return numericFilters;
  }

  public ConsequenceParams setTagFilters(TagFilters tagFilters) {
    this.tagFilters = tagFilters;
    return this;
  }

  /** Get tagFilters */
  @javax.annotation.Nullable
  public TagFilters getTagFilters() {
    return tagFilters;
  }

  public ConsequenceParams setSumOrFiltersScores(Boolean sumOrFiltersScores) {
    this.sumOrFiltersScores = sumOrFiltersScores;
    return this;
  }

  /**
   * Whether to sum all filter scores. If true, all filter scores are summed. Otherwise, the maximum
   * filter score is kept. For more information, see [filter
   * scores](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/in-depth/filter-scoring/#accumulating-scores-with-sumorfiltersscores).
   */
  @javax.annotation.Nullable
  public Boolean getSumOrFiltersScores() {
    return sumOrFiltersScores;
  }

  public ConsequenceParams setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
    this.restrictSearchableAttributes = restrictSearchableAttributes;
    return this;
  }

  public ConsequenceParams addRestrictSearchableAttributes(String restrictSearchableAttributesItem) {
    if (this.restrictSearchableAttributes == null) {
      this.restrictSearchableAttributes = new ArrayList<>();
    }
    this.restrictSearchableAttributes.add(restrictSearchableAttributesItem);
    return this;
  }

  /** Restricts a search to a subset of your searchable attributes. */
  @javax.annotation.Nullable
  public List<String> getRestrictSearchableAttributes() {
    return restrictSearchableAttributes;
  }

  public ConsequenceParams setFacets(List<String> facets) {
    this.facets = facets;
    return this;
  }

  public ConsequenceParams addFacets(String facetsItem) {
    if (this.facets == null) {
      this.facets = new ArrayList<>();
    }
    this.facets.add(facetsItem);
    return this;
  }

  /**
   * Facets for which to retrieve facet values that match the search criteria and the number of
   * matching facet values. To retrieve all facets, use the wildcard character `*`. For more
   * information, see
   * [facets](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#contextual-facet-values-and-counts).
   */
  @javax.annotation.Nullable
  public List<String> getFacets() {
    return facets;
  }

  public ConsequenceParams setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
    this.facetingAfterDistinct = facetingAfterDistinct;
    return this;
  }

  /**
   * Whether faceting should be applied after deduplication with `distinct`. This leads to accurate
   * facet counts when using faceting in combination with `distinct`. It's usually better to use
   * `afterDistinct` modifiers in the `attributesForFaceting` setting, as `facetingAfterDistinct`
   * only computes correct facet counts if all records have the same facet values for the
   * `attributeForDistinct`.
   */
  @javax.annotation.Nullable
  public Boolean getFacetingAfterDistinct() {
    return facetingAfterDistinct;
  }

  public ConsequenceParams setPage(Integer page) {
    this.page = page;
    return this;
  }

  /** Page of search results to retrieve. minimum: 0 */
  @javax.annotation.Nullable
  public Integer getPage() {
    return page;
  }

  public ConsequenceParams setOffset(Integer offset) {
    this.offset = offset;
    return this;
  }

  /** Position of the first hit to retrieve. */
  @javax.annotation.Nullable
  public Integer getOffset() {
    return offset;
  }

  public ConsequenceParams setLength(Integer length) {
    this.length = length;
    return this;
  }

  /** Number of hits to retrieve (used in combination with `offset`). minimum: 1 maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getLength() {
    return length;
  }

  public ConsequenceParams setAroundLatLng(String aroundLatLng) {
    this.aroundLatLng = aroundLatLng;
    return this;
  }

  /**
   * Coordinates for the center of a circle, expressed as a comma-separated string of latitude and
   * longitude. Only records included within circle around this central location are included in the
   * results. The radius of the circle is determined by the `aroundRadius` and `minimumAroundRadius`
   * settings. This parameter is ignored if you also specify `insidePolygon` or `insideBoundingBox`.
   */
  @javax.annotation.Nullable
  public String getAroundLatLng() {
    return aroundLatLng;
  }

  public ConsequenceParams setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
    this.aroundLatLngViaIP = aroundLatLngViaIP;
    return this;
  }

  /** Whether to obtain the coordinates from the request's IP address. */
  @javax.annotation.Nullable
  public Boolean getAroundLatLngViaIP() {
    return aroundLatLngViaIP;
  }

  public ConsequenceParams setAroundRadius(AroundRadius aroundRadius) {
    this.aroundRadius = aroundRadius;
    return this;
  }

  /** Get aroundRadius */
  @javax.annotation.Nullable
  public AroundRadius getAroundRadius() {
    return aroundRadius;
  }

  public ConsequenceParams setAroundPrecision(AroundPrecision aroundPrecision) {
    this.aroundPrecision = aroundPrecision;
    return this;
  }

  /** Get aroundPrecision */
  @javax.annotation.Nullable
  public AroundPrecision getAroundPrecision() {
    return aroundPrecision;
  }

  public ConsequenceParams setMinimumAroundRadius(Integer minimumAroundRadius) {
    this.minimumAroundRadius = minimumAroundRadius;
    return this;
  }

  /**
   * Minimum radius (in meters) for a search around a location when `aroundRadius` isn't set.
   * minimum: 1
   */
  @javax.annotation.Nullable
  public Integer getMinimumAroundRadius() {
    return minimumAroundRadius;
  }

  public ConsequenceParams setInsideBoundingBox(List<List<Double>> insideBoundingBox) {
    this.insideBoundingBox = insideBoundingBox;
    return this;
  }

  public ConsequenceParams addInsideBoundingBox(List<Double> insideBoundingBoxItem) {
    if (this.insideBoundingBox == null) {
      this.insideBoundingBox = new ArrayList<>();
    }
    this.insideBoundingBox.add(insideBoundingBoxItem);
    return this;
  }

  /**
   * Coordinates for a rectangular area in which to search. Each bounding box is defined by the two
   * opposite points of its diagonal, and expressed as latitude and longitude pair: `[p1 lat, p1
   * long, p2 lat, p2 long]`. Provide multiple bounding boxes as nested arrays. For more
   * information, see [rectangular
   * area](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/#filtering-inside-rectangular-or-polygonal-areas).
   */
  @javax.annotation.Nullable
  public List<List<Double>> getInsideBoundingBox() {
    return insideBoundingBox;
  }

  public ConsequenceParams setInsidePolygon(List<List<Double>> insidePolygon) {
    this.insidePolygon = insidePolygon;
    return this;
  }

  public ConsequenceParams addInsidePolygon(List<Double> insidePolygonItem) {
    if (this.insidePolygon == null) {
      this.insidePolygon = new ArrayList<>();
    }
    this.insidePolygon.add(insidePolygonItem);
    return this;
  }

  /**
   * Coordinates of a polygon in which to search. Polygons are defined by 3 to 10,000 points. Each
   * point is represented by its latitude and longitude. Provide multiple polygons as nested arrays.
   * For more information, see [filtering inside
   * polygons](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/#filtering-inside-rectangular-or-polygonal-areas).
   * This parameter is ignored, if you also specify `insideBoundingBox`.
   */
  @javax.annotation.Nullable
  public List<List<Double>> getInsidePolygon() {
    return insidePolygon;
  }

  public ConsequenceParams setNaturalLanguages(List<String> naturalLanguages) {
    this.naturalLanguages = naturalLanguages;
    return this;
  }

  public ConsequenceParams addNaturalLanguages(String naturalLanguagesItem) {
    if (this.naturalLanguages == null) {
      this.naturalLanguages = new ArrayList<>();
    }
    this.naturalLanguages.add(naturalLanguagesItem);
    return this;
  }

  /**
   * ISO language codes that adjust settings that are useful for processing natural language queries
   * (as opposed to keyword searches): - Sets `removeStopWords` and `ignorePlurals` to the list of
   * provided languages. - Sets `removeWordsIfNoResults` to `allOptional`. - Adds a
   * `natural_language` attribute to `ruleContexts` and `analyticsTags`.
   */
  @javax.annotation.Nullable
  public List<String> getNaturalLanguages() {
    return naturalLanguages;
  }

  public ConsequenceParams setRuleContexts(List<String> ruleContexts) {
    this.ruleContexts = ruleContexts;
    return this;
  }

  public ConsequenceParams addRuleContexts(String ruleContextsItem) {
    if (this.ruleContexts == null) {
      this.ruleContexts = new ArrayList<>();
    }
    this.ruleContexts.add(ruleContextsItem);
    return this;
  }

  /**
   * Assigns a rule context to the search query. [Rule
   * contexts](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/how-to/customize-search-results-by-platform/#whats-a-context)
   * are strings that you can use to trigger matching rules.
   */
  @javax.annotation.Nullable
  public List<String> getRuleContexts() {
    return ruleContexts;
  }

  public ConsequenceParams setPersonalizationImpact(Integer personalizationImpact) {
    this.personalizationImpact = personalizationImpact;
    return this;
  }

  /**
   * Impact that Personalization should have on this search. The higher this value is, the more
   * Personalization determines the ranking compared to other factors. For more information, see
   * [Understanding Personalization
   * impact](https://www.algolia.com/doc/guides/personalization/personalizing-results/in-depth/configuring-personalization/#understanding-personalization-impact).
   * minimum: 0 maximum: 100
   */
  @javax.annotation.Nullable
  public Integer getPersonalizationImpact() {
    return personalizationImpact;
  }

  public ConsequenceParams setUserToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

  /**
   * Unique pseudonymous or anonymous user identifier. This helps with analytics and click and
   * conversion events. For more information, see [user
   * token](https://www.algolia.com/doc/guides/sending-events/concepts/usertoken/).
   */
  @javax.annotation.Nullable
  public String getUserToken() {
    return userToken;
  }

  public ConsequenceParams setGetRankingInfo(Boolean getRankingInfo) {
    this.getRankingInfo = getRankingInfo;
    return this;
  }

  /** Whether the search response should include detailed ranking information. */
  @javax.annotation.Nullable
  public Boolean getGetRankingInfo() {
    return getRankingInfo;
  }

  public ConsequenceParams setSynonyms(Boolean synonyms) {
    this.synonyms = synonyms;
    return this;
  }

  /** Whether to take into account an index's synonyms for this search. */
  @javax.annotation.Nullable
  public Boolean getSynonyms() {
    return synonyms;
  }

  public ConsequenceParams setClickAnalytics(Boolean clickAnalytics) {
    this.clickAnalytics = clickAnalytics;
    return this;
  }

  /**
   * Whether to include a `queryID` attribute in the response. The query ID is a unique identifier
   * for a search query and is required for tracking [click and conversion
   * events](https://www.algolia.com/guides/sending-events/getting-started/).
   */
  @javax.annotation.Nullable
  public Boolean getClickAnalytics() {
    return clickAnalytics;
  }

  public ConsequenceParams setAnalytics(Boolean analytics) {
    this.analytics = analytics;
    return this;
  }

  /** Whether this search will be included in Analytics. */
  @javax.annotation.Nullable
  public Boolean getAnalytics() {
    return analytics;
  }

  public ConsequenceParams setAnalyticsTags(List<String> analyticsTags) {
    this.analyticsTags = analyticsTags;
    return this;
  }

  public ConsequenceParams addAnalyticsTags(String analyticsTagsItem) {
    if (this.analyticsTags == null) {
      this.analyticsTags = new ArrayList<>();
    }
    this.analyticsTags.add(analyticsTagsItem);
    return this;
  }

  /**
   * Tags to apply to the query for [segmenting analytics
   * data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/).
   */
  @javax.annotation.Nullable
  public List<String> getAnalyticsTags() {
    return analyticsTags;
  }

  public ConsequenceParams setPercentileComputation(Boolean percentileComputation) {
    this.percentileComputation = percentileComputation;
    return this;
  }

  /** Whether to include this search when calculating processing-time percentiles. */
  @javax.annotation.Nullable
  public Boolean getPercentileComputation() {
    return percentileComputation;
  }

  public ConsequenceParams setEnableABTest(Boolean enableABTest) {
    this.enableABTest = enableABTest;
    return this;
  }

  /** Whether to enable A/B testing for this search. */
  @javax.annotation.Nullable
  public Boolean getEnableABTest() {
    return enableABTest;
  }

  public ConsequenceParams setAttributesToRetrieve(List<String> attributesToRetrieve) {
    this.attributesToRetrieve = attributesToRetrieve;
    return this;
  }

  public ConsequenceParams addAttributesToRetrieve(String attributesToRetrieveItem) {
    if (this.attributesToRetrieve == null) {
      this.attributesToRetrieve = new ArrayList<>();
    }
    this.attributesToRetrieve.add(attributesToRetrieveItem);
    return this;
  }

  /**
   * Attributes to include in the API response. To reduce the size of your response, you can
   * retrieve only some of the attributes. - `*` retrieves all attributes, except attributes
   * included in the `customRanking` and `unretrievableAttributes` settings. - To retrieve all
   * attributes except a specific one, prefix the attribute with a dash and combine it with the `*`:
   * `[\"*\", \"-ATTRIBUTE\"]`. - The `objectID` attribute is always included.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToRetrieve() {
    return attributesToRetrieve;
  }

  public ConsequenceParams setRanking(List<String> ranking) {
    this.ranking = ranking;
    return this;
  }

  public ConsequenceParams addRanking(String rankingItem) {
    if (this.ranking == null) {
      this.ranking = new ArrayList<>();
    }
    this.ranking.add(rankingItem);
    return this;
  }

  /**
   * Determines the order in which Algolia returns your results. By default, each entry corresponds
   * to a [ranking
   * criteria](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/).
   * The tie-breaking algorithm sequentially applies each criterion in the order they're specified.
   * If you configure a replica index for [sorting by an
   * attribute](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/sort-by-attribute/),
   * you put the sorting attribute at the top of the list. **Modifiers**
   *
   * <dl>
   *   <dt><code>asc(\"ATTRIBUTE\")</code>
   *   <dd>Sort the index by the values of an attribute, in ascending order.
   *   <dt><code>desc(\"ATTRIBUTE\")</code>
   *   <dd>Sort the index by the values of an attribute, in descending order.
   * </dl>
   *
   * Before you modify the default setting, you should test your changes in the dashboard, and by
   * [A/B testing](https://www.algolia.com/doc/guides/ab-testing/what-is-ab-testing/).
   */
  @javax.annotation.Nullable
  public List<String> getRanking() {
    return ranking;
  }

  public ConsequenceParams setCustomRanking(List<String> customRanking) {
    this.customRanking = customRanking;
    return this;
  }

  public ConsequenceParams addCustomRanking(String customRankingItem) {
    if (this.customRanking == null) {
      this.customRanking = new ArrayList<>();
    }
    this.customRanking.add(customRankingItem);
    return this;
  }

  /**
   * Attributes to use as [custom
   * ranking](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/). The
   * custom ranking attributes decide which items are shown first if the other ranking criteria are
   * equal. Records with missing values for your selected custom ranking attributes are always
   * sorted last. Boolean attributes are sorted based on their alphabetical order. **Modifiers**
   *
   * <dl>
   *   <dt><code>asc(\"ATTRIBUTE\")</code>
   *   <dd>Sort the index by the values of an attribute, in ascending order.
   *   <dt><code>desc(\"ATTRIBUTE\")</code>
   *   <dd>Sort the index by the values of an attribute, in descending order.
   * </dl>
   *
   * If you use two or more custom ranking attributes, [reduce the
   * precision](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/how-to/controlling-custom-ranking-metrics-precision/)
   * of your first attributes, or the other attributes will never be applied.
   */
  @javax.annotation.Nullable
  public List<String> getCustomRanking() {
    return customRanking;
  }

  public ConsequenceParams setRelevancyStrictness(Integer relevancyStrictness) {
    this.relevancyStrictness = relevancyStrictness;
    return this;
  }

  /**
   * Relevancy threshold below which less relevant results aren't included in the results. You can
   * only set `relevancyStrictness` on [virtual replica
   * indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/#what-are-virtual-replicas).
   * Use this setting to strike a balance between the relevance and number of returned results.
   */
  @javax.annotation.Nullable
  public Integer getRelevancyStrictness() {
    return relevancyStrictness;
  }

  public ConsequenceParams setAttributesToHighlight(List<String> attributesToHighlight) {
    this.attributesToHighlight = attributesToHighlight;
    return this;
  }

  public ConsequenceParams addAttributesToHighlight(String attributesToHighlightItem) {
    if (this.attributesToHighlight == null) {
      this.attributesToHighlight = new ArrayList<>();
    }
    this.attributesToHighlight.add(attributesToHighlightItem);
    return this;
  }

  /**
   * Attributes to highlight. By default, all searchable attributes are highlighted. Use `*` to
   * highlight all attributes or use an empty array `[]` to turn off highlighting. With
   * highlighting, strings that match the search query are surrounded by HTML tags defined by
   * `highlightPreTag` and `highlightPostTag`. You can use this to visually highlight matching parts
   * of a search query in your UI. For more information, see [Highlighting and
   * snippeting](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/highlighting-snippeting/js/).
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToHighlight() {
    return attributesToHighlight;
  }

  public ConsequenceParams setAttributesToSnippet(List<String> attributesToSnippet) {
    this.attributesToSnippet = attributesToSnippet;
    return this;
  }

  public ConsequenceParams addAttributesToSnippet(String attributesToSnippetItem) {
    if (this.attributesToSnippet == null) {
      this.attributesToSnippet = new ArrayList<>();
    }
    this.attributesToSnippet.add(attributesToSnippetItem);
    return this;
  }

  /**
   * Attributes for which to enable snippets. Snippets provide additional context to matched words.
   * If you enable snippets, they include 10 words, including the matched word. The matched word
   * will also be wrapped by HTML tags for highlighting. You can adjust the number of words with the
   * following notation: `ATTRIBUTE:NUMBER`, where `NUMBER` is the number of words to be extracted.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToSnippet() {
    return attributesToSnippet;
  }

  public ConsequenceParams setHighlightPreTag(String highlightPreTag) {
    this.highlightPreTag = highlightPreTag;
    return this;
  }

  /** HTML tag to insert before the highlighted parts in all highlighted results and snippets. */
  @javax.annotation.Nullable
  public String getHighlightPreTag() {
    return highlightPreTag;
  }

  public ConsequenceParams setHighlightPostTag(String highlightPostTag) {
    this.highlightPostTag = highlightPostTag;
    return this;
  }

  /** HTML tag to insert after the highlighted parts in all highlighted results and snippets. */
  @javax.annotation.Nullable
  public String getHighlightPostTag() {
    return highlightPostTag;
  }

  public ConsequenceParams setSnippetEllipsisText(String snippetEllipsisText) {
    this.snippetEllipsisText = snippetEllipsisText;
    return this;
  }

  /** String used as an ellipsis indicator when a snippet is truncated. */
  @javax.annotation.Nullable
  public String getSnippetEllipsisText() {
    return snippetEllipsisText;
  }

  public ConsequenceParams setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
    this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
    return this;
  }

  /**
   * Whether to restrict highlighting and snippeting to items that at least partially matched the
   * search query. By default, all items are highlighted and snippeted.
   */
  @javax.annotation.Nullable
  public Boolean getRestrictHighlightAndSnippetArrays() {
    return restrictHighlightAndSnippetArrays;
  }

  public ConsequenceParams setHitsPerPage(Integer hitsPerPage) {
    this.hitsPerPage = hitsPerPage;
    return this;
  }

  /** Number of hits per page. minimum: 1 maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getHitsPerPage() {
    return hitsPerPage;
  }

  public ConsequenceParams setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
    this.minWordSizefor1Typo = minWordSizefor1Typo;
    return this;
  }

  /**
   * Minimum number of characters a word in the search query must contain to accept matches with
   * [one
   * typo](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor1Typo() {
    return minWordSizefor1Typo;
  }

  public ConsequenceParams setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
    this.minWordSizefor2Typos = minWordSizefor2Typos;
    return this;
  }

  /**
   * Minimum number of characters a word in the search query must contain to accept matches with
   * [two
   * typos](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor2Typos() {
    return minWordSizefor2Typos;
  }

  public ConsequenceParams setTypoTolerance(TypoTolerance typoTolerance) {
    this.typoTolerance = typoTolerance;
    return this;
  }

  /** Get typoTolerance */
  @javax.annotation.Nullable
  public TypoTolerance getTypoTolerance() {
    return typoTolerance;
  }

  public ConsequenceParams setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
    this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
    return this;
  }

  /**
   * Whether to allow typos on numbers in the search query. Turn off this setting to reduce the
   * number of irrelevant matches when searching in large sets of similar numbers.
   */
  @javax.annotation.Nullable
  public Boolean getAllowTyposOnNumericTokens() {
    return allowTyposOnNumericTokens;
  }

  public ConsequenceParams setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
    this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
    return this;
  }

  public ConsequenceParams addDisableTypoToleranceOnAttributes(String disableTypoToleranceOnAttributesItem) {
    if (this.disableTypoToleranceOnAttributes == null) {
      this.disableTypoToleranceOnAttributes = new ArrayList<>();
    }
    this.disableTypoToleranceOnAttributes.add(disableTypoToleranceOnAttributesItem);
    return this;
  }

  /**
   * Attributes for which you want to turn off [typo
   * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/).
   * Returning only exact matches can help when: - [Searching in hyphenated
   * attributes](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes/).
   * - Reducing the number of matches when you have too many. This can happen with attributes that
   * are long blocks of text, such as product descriptions. Consider alternatives such as
   * `disableTypoToleranceOnWords` or adding synonyms if your attributes have intentional unusual
   * spellings that might look like typos.
   */
  @javax.annotation.Nullable
  public List<String> getDisableTypoToleranceOnAttributes() {
    return disableTypoToleranceOnAttributes;
  }

  public ConsequenceParams setIgnorePlurals(IgnorePlurals ignorePlurals) {
    this.ignorePlurals = ignorePlurals;
    return this;
  }

  /** Get ignorePlurals */
  @javax.annotation.Nullable
  public IgnorePlurals getIgnorePlurals() {
    return ignorePlurals;
  }

  public ConsequenceParams setRemoveStopWords(RemoveStopWords removeStopWords) {
    this.removeStopWords = removeStopWords;
    return this;
  }

  /** Get removeStopWords */
  @javax.annotation.Nullable
  public RemoveStopWords getRemoveStopWords() {
    return removeStopWords;
  }

  public ConsequenceParams setKeepDiacriticsOnCharacters(String keepDiacriticsOnCharacters) {
    this.keepDiacriticsOnCharacters = keepDiacriticsOnCharacters;
    return this;
  }

  /**
   * Characters for which diacritics should be preserved. By default, Algolia removes diacritics
   * from letters. For example, `é` becomes `e`. If this causes issues in your search, you can
   * specify characters that should keep their diacritics.
   */
  @javax.annotation.Nullable
  public String getKeepDiacriticsOnCharacters() {
    return keepDiacriticsOnCharacters;
  }

  public ConsequenceParams setQueryLanguages(List<String> queryLanguages) {
    this.queryLanguages = queryLanguages;
    return this;
  }

  public ConsequenceParams addQueryLanguages(String queryLanguagesItem) {
    if (this.queryLanguages == null) {
      this.queryLanguages = new ArrayList<>();
    }
    this.queryLanguages.add(queryLanguagesItem);
    return this;
  }

  /**
   * [ISO code](https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes) for language-specific
   * settings such as plurals, stop words, and word-detection dictionaries. This setting sets a
   * default list of languages used by the `removeStopWords` and `ignorePlurals` settings. This
   * setting also sets a dictionary for word detection in the logogram-based
   * [CJK](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/#normalization-for-logogram-based-languages-cjk)
   * languages. To support this, you must place the CJK language **first**. **You should always
   * specify a query language.** If you don't specify an indexing language, the search engine uses
   * all [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/),
   * or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This
   * can lead to unexpected search results. For more information, see [Language-specific
   * configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).
   */
  @javax.annotation.Nullable
  public List<String> getQueryLanguages() {
    return queryLanguages;
  }

  public ConsequenceParams setDecompoundQuery(Boolean decompoundQuery) {
    this.decompoundQuery = decompoundQuery;
    return this;
  }

  /**
   * Whether to split compound words into their building blocks. For more information, see [Word
   * segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#splitting-compound-words).
   * Word segmentation is supported for these languages: German, Dutch, Finnish, Swedish, and
   * Norwegian.
   */
  @javax.annotation.Nullable
  public Boolean getDecompoundQuery() {
    return decompoundQuery;
  }

  public ConsequenceParams setEnableRules(Boolean enableRules) {
    this.enableRules = enableRules;
    return this;
  }

  /** Whether to enable rules. */
  @javax.annotation.Nullable
  public Boolean getEnableRules() {
    return enableRules;
  }

  public ConsequenceParams setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /** Whether to enable Personalization. */
  @javax.annotation.Nullable
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public ConsequenceParams setQueryType(QueryType queryType) {
    this.queryType = queryType;
    return this;
  }

  /** Get queryType */
  @javax.annotation.Nullable
  public QueryType getQueryType() {
    return queryType;
  }

  public ConsequenceParams setRemoveWordsIfNoResults(RemoveWordsIfNoResults removeWordsIfNoResults) {
    this.removeWordsIfNoResults = removeWordsIfNoResults;
    return this;
  }

  /** Get removeWordsIfNoResults */
  @javax.annotation.Nullable
  public RemoveWordsIfNoResults getRemoveWordsIfNoResults() {
    return removeWordsIfNoResults;
  }

  public ConsequenceParams setMode(Mode mode) {
    this.mode = mode;
    return this;
  }

  /** Get mode */
  @javax.annotation.Nullable
  public Mode getMode() {
    return mode;
  }

  public ConsequenceParams setSemanticSearch(SemanticSearch semanticSearch) {
    this.semanticSearch = semanticSearch;
    return this;
  }

  /** Get semanticSearch */
  @javax.annotation.Nullable
  public SemanticSearch getSemanticSearch() {
    return semanticSearch;
  }

  public ConsequenceParams setAdvancedSyntax(Boolean advancedSyntax) {
    this.advancedSyntax = advancedSyntax;
    return this;
  }

  /**
   * Whether to support phrase matching and excluding words from search queries. Use the
   * `advancedSyntaxFeatures` parameter to control which feature is supported.
   */
  @javax.annotation.Nullable
  public Boolean getAdvancedSyntax() {
    return advancedSyntax;
  }

  public ConsequenceParams setOptionalWords(List<String> optionalWords) {
    this.optionalWords = optionalWords;
    return this;
  }

  public ConsequenceParams addOptionalWords(String optionalWordsItem) {
    if (this.optionalWords == null) {
      this.optionalWords = new ArrayList<>();
    }
    this.optionalWords.add(optionalWordsItem);
    return this;
  }

  /**
   * Words that should be considered optional when found in the query. By default, records must
   * match all words in the search query to be included in the search results. Adding optional words
   * can help to increase the number of search results by running an additional search query that
   * doesn't include the optional words. For example, if the search query is \"action video\" and
   * \"video\" is an optional word, the search engine runs two queries. One for \"action video\" and
   * one for \"action\". Records that match all words are ranked higher. For a search query with 4
   * or more words **and** all its words are optional, the number of matched words required for a
   * record to be included in the search results increases for every 1,000 records: - If
   * `optionalWords` has less than 10 words, the required number of matched words increases by 1:
   * results 1 to 1,000 require 1 matched word, results 1,001 to 2000 need 2 matched words. - If
   * `optionalWords` has 10 or more words, the number of required matched words increases by the
   * number of optional words dividied by 5 (rounded down). For example, with 18 optional words:
   * results 1 to 1,000 require 1 matched word, results 1,001 to 2000 need 4 matched words. For more
   * information, see [Optional
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/empty-or-insufficient-results/#creating-a-list-of-optional-words).
   */
  @javax.annotation.Nullable
  public List<String> getOptionalWords() {
    return optionalWords;
  }

  public ConsequenceParams setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
    this.disableExactOnAttributes = disableExactOnAttributes;
    return this;
  }

  public ConsequenceParams addDisableExactOnAttributes(String disableExactOnAttributesItem) {
    if (this.disableExactOnAttributes == null) {
      this.disableExactOnAttributes = new ArrayList<>();
    }
    this.disableExactOnAttributes.add(disableExactOnAttributesItem);
    return this;
  }

  /**
   * Searchable attributes for which you want to [turn off the Exact ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes).
   * This can be useful for attributes with long values, where the likelyhood of an exact match is
   * high, such as product descriptions. Turning off the Exact ranking criterion for these
   * attributes favors exact matching on other attributes. This reduces the impact of individual
   * attributes with a lot of content on ranking.
   */
  @javax.annotation.Nullable
  public List<String> getDisableExactOnAttributes() {
    return disableExactOnAttributes;
  }

  public ConsequenceParams setExactOnSingleWordQuery(ExactOnSingleWordQuery exactOnSingleWordQuery) {
    this.exactOnSingleWordQuery = exactOnSingleWordQuery;
    return this;
  }

  /** Get exactOnSingleWordQuery */
  @javax.annotation.Nullable
  public ExactOnSingleWordQuery getExactOnSingleWordQuery() {
    return exactOnSingleWordQuery;
  }

  public ConsequenceParams setAlternativesAsExact(List<AlternativesAsExact> alternativesAsExact) {
    this.alternativesAsExact = alternativesAsExact;
    return this;
  }

  public ConsequenceParams addAlternativesAsExact(AlternativesAsExact alternativesAsExactItem) {
    if (this.alternativesAsExact == null) {
      this.alternativesAsExact = new ArrayList<>();
    }
    this.alternativesAsExact.add(alternativesAsExactItem);
    return this;
  }

  /**
   * Alternatives of query words that should be considered as exact matches by the Exact ranking
   * criterion.
   *
   * <dl>
   *   <dt><code>ignorePlurals</code>
   *   <dd>Plurals and similar declensions added by the `ignorePlurals` setting are considered exact
   *       matches.
   *   <dt><code>singleWordSynonym</code>
   *   <dd>Single-word synonyms, such as \"NY/NYC\" are considered exact matches.
   *   <dt><code>multiWordsSynonym</code>
   *   <dd>Multi-word synonyms, such as \"NY/New York\" are considered exact matches.
   * </dl>
   *
   * .
   */
  @javax.annotation.Nullable
  public List<AlternativesAsExact> getAlternativesAsExact() {
    return alternativesAsExact;
  }

  public ConsequenceParams setAdvancedSyntaxFeatures(List<AdvancedSyntaxFeatures> advancedSyntaxFeatures) {
    this.advancedSyntaxFeatures = advancedSyntaxFeatures;
    return this;
  }

  public ConsequenceParams addAdvancedSyntaxFeatures(AdvancedSyntaxFeatures advancedSyntaxFeaturesItem) {
    if (this.advancedSyntaxFeatures == null) {
      this.advancedSyntaxFeatures = new ArrayList<>();
    }
    this.advancedSyntaxFeatures.add(advancedSyntaxFeaturesItem);
    return this;
  }

  /**
   * Advanced search syntax features you want to support.
   *
   * <dl>
   *   <dt><code>exactPhrase</code>
   *   <dd>Phrases in quotes must match exactly. For example, `sparkly blue \"iPhone case\"` only
   *       returns records with the exact string \"iPhone case\".
   *   <dt><code>excludeWords</code>
   *   <dd>Query words prefixed with a `-` must not occur in a record. For example, `search -engine`
   *       matches records that contain \"search\" but not \"engine\".
   * </dl>
   *
   * This setting only has an effect if `advancedSyntax` is true.
   */
  @javax.annotation.Nullable
  public List<AdvancedSyntaxFeatures> getAdvancedSyntaxFeatures() {
    return advancedSyntaxFeatures;
  }

  public ConsequenceParams setDistinct(Distinct distinct) {
    this.distinct = distinct;
    return this;
  }

  /** Get distinct */
  @javax.annotation.Nullable
  public Distinct getDistinct() {
    return distinct;
  }

  public ConsequenceParams setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
    this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
    return this;
  }

  /**
   * Whether to replace a highlighted word with the matched synonym. By default, the original words
   * are highlighted even if a synonym matches. For example, with `home` as a synonym for `house`
   * and a search for `home`, records matching either \"home\" or \"house\" are included in the
   * search results, and either \"home\" or \"house\" are highlighted. With
   * `replaceSynonymsInHighlight` set to `true`, a search for `home` still matches the same records,
   * but all occurences of \"house\" are replaced by \"home\" in the highlighted response.
   */
  @javax.annotation.Nullable
  public Boolean getReplaceSynonymsInHighlight() {
    return replaceSynonymsInHighlight;
  }

  public ConsequenceParams setMinProximity(Integer minProximity) {
    this.minProximity = minProximity;
    return this;
  }

  /**
   * Minimum proximity score for two matching words. This adjusts the [Proximity ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#proximity)
   * by equally scoring matches that are farther apart. For example, if `minProximity` is 2,
   * neighboring matches and matches with one word between them would have the same score. minimum:
   * 1 maximum: 7
   */
  @javax.annotation.Nullable
  public Integer getMinProximity() {
    return minProximity;
  }

  public ConsequenceParams setResponseFields(List<String> responseFields) {
    this.responseFields = responseFields;
    return this;
  }

  public ConsequenceParams addResponseFields(String responseFieldsItem) {
    if (this.responseFields == null) {
      this.responseFields = new ArrayList<>();
    }
    this.responseFields.add(responseFieldsItem);
    return this;
  }

  /**
   * Properties to include in the API response of `search` and `browse` requests. By default, all
   * response properties are included. To reduce the response size, you can select, which attributes
   * should be included. You can't exclude these properties: `message`, `warning`, `cursor`,
   * `serverUsed`, `indexUsed`, `abTestVariantID`, `parsedQuery`, or any property triggered by the
   * `getRankingInfo` parameter. Don't exclude properties that you might need in your search UI.
   */
  @javax.annotation.Nullable
  public List<String> getResponseFields() {
    return responseFields;
  }

  public ConsequenceParams setMaxFacetHits(Integer maxFacetHits) {
    this.maxFacetHits = maxFacetHits;
    return this;
  }

  /**
   * Maximum number of facet values to return when [searching for facet
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values).
   * maximum: 100
   */
  @javax.annotation.Nullable
  public Integer getMaxFacetHits() {
    return maxFacetHits;
  }

  public ConsequenceParams setMaxValuesPerFacet(Integer maxValuesPerFacet) {
    this.maxValuesPerFacet = maxValuesPerFacet;
    return this;
  }

  /** Maximum number of facet values to return for each facet. maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getMaxValuesPerFacet() {
    return maxValuesPerFacet;
  }

  public ConsequenceParams setSortFacetValuesBy(String sortFacetValuesBy) {
    this.sortFacetValuesBy = sortFacetValuesBy;
    return this;
  }

  /**
   * Order in which to retrieve facet values.
   *
   * <dl>
   *   <dt><code>count</code>
   *   <dd>Facet values are retrieved by decreasing count. The count is the number of matching
   *       records containing this facet value.
   *   <dt><code>alpha</code>
   *   <dd>Retrieve facet values alphabetically.
   * </dl>
   *
   * This setting doesn't influence how facet values are displayed in your UI (see
   * `renderingContent`). For more information, see [facet value
   * display](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/facet-display/js/).
   */
  @javax.annotation.Nullable
  public String getSortFacetValuesBy() {
    return sortFacetValuesBy;
  }

  public ConsequenceParams setAttributeCriteriaComputedByMinProximity(Boolean attributeCriteriaComputedByMinProximity) {
    this.attributeCriteriaComputedByMinProximity = attributeCriteriaComputedByMinProximity;
    return this;
  }

  /**
   * Whether the best matching attribute should be determined by minimum proximity. This setting
   * only affects ranking if the Attribute ranking criterion comes before Proximity in the `ranking`
   * setting. If true, the best matching attribute is selected based on the minimum proximity of
   * multiple matches. Otherwise, the best matching attribute is determined by the order in the
   * `searchableAttributes` setting.
   */
  @javax.annotation.Nullable
  public Boolean getAttributeCriteriaComputedByMinProximity() {
    return attributeCriteriaComputedByMinProximity;
  }

  public ConsequenceParams setRenderingContent(RenderingContent renderingContent) {
    this.renderingContent = renderingContent;
    return this;
  }

  /** Get renderingContent */
  @javax.annotation.Nullable
  public RenderingContent getRenderingContent() {
    return renderingContent;
  }

  public ConsequenceParams setEnableReRanking(Boolean enableReRanking) {
    this.enableReRanking = enableReRanking;
    return this;
  }

  /**
   * Whether this search will use [Dynamic
   * Re-Ranking](https://www.algolia.com/doc/guides/algolia-ai/re-ranking/). This setting only has
   * an effect if you activated Dynamic Re-Ranking for this index in the Algolia dashboard.
   */
  @javax.annotation.Nullable
  public Boolean getEnableReRanking() {
    return enableReRanking;
  }

  public ConsequenceParams setReRankingApplyFilter(ReRankingApplyFilter reRankingApplyFilter) {
    this.reRankingApplyFilter = reRankingApplyFilter;
    return this;
  }

  /** Get reRankingApplyFilter */
  @javax.annotation.Nullable
  public ReRankingApplyFilter getReRankingApplyFilter() {
    return reRankingApplyFilter;
  }

  public ConsequenceParams setQuery(ConsequenceQuery query) {
    this.query = query;
    return this;
  }

  /** Get query */
  @javax.annotation.Nullable
  public ConsequenceQuery getQuery() {
    return query;
  }

  public ConsequenceParams setAutomaticFacetFilters(AutomaticFacetFilters automaticFacetFilters) {
    this.automaticFacetFilters = automaticFacetFilters;
    return this;
  }

  /** Get automaticFacetFilters */
  @javax.annotation.Nullable
  public AutomaticFacetFilters getAutomaticFacetFilters() {
    return automaticFacetFilters;
  }

  public ConsequenceParams setAutomaticOptionalFacetFilters(AutomaticFacetFilters automaticOptionalFacetFilters) {
    this.automaticOptionalFacetFilters = automaticOptionalFacetFilters;
    return this;
  }

  /** Get automaticOptionalFacetFilters */
  @javax.annotation.Nullable
  public AutomaticFacetFilters getAutomaticOptionalFacetFilters() {
    return automaticOptionalFacetFilters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsequenceParams consequenceParams = (ConsequenceParams) o;
    return (
      Objects.equals(this.similarQuery, consequenceParams.similarQuery) &&
      Objects.equals(this.filters, consequenceParams.filters) &&
      Objects.equals(this.facetFilters, consequenceParams.facetFilters) &&
      Objects.equals(this.optionalFilters, consequenceParams.optionalFilters) &&
      Objects.equals(this.numericFilters, consequenceParams.numericFilters) &&
      Objects.equals(this.tagFilters, consequenceParams.tagFilters) &&
      Objects.equals(this.sumOrFiltersScores, consequenceParams.sumOrFiltersScores) &&
      Objects.equals(this.restrictSearchableAttributes, consequenceParams.restrictSearchableAttributes) &&
      Objects.equals(this.facets, consequenceParams.facets) &&
      Objects.equals(this.facetingAfterDistinct, consequenceParams.facetingAfterDistinct) &&
      Objects.equals(this.page, consequenceParams.page) &&
      Objects.equals(this.offset, consequenceParams.offset) &&
      Objects.equals(this.length, consequenceParams.length) &&
      Objects.equals(this.aroundLatLng, consequenceParams.aroundLatLng) &&
      Objects.equals(this.aroundLatLngViaIP, consequenceParams.aroundLatLngViaIP) &&
      Objects.equals(this.aroundRadius, consequenceParams.aroundRadius) &&
      Objects.equals(this.aroundPrecision, consequenceParams.aroundPrecision) &&
      Objects.equals(this.minimumAroundRadius, consequenceParams.minimumAroundRadius) &&
      Objects.equals(this.insideBoundingBox, consequenceParams.insideBoundingBox) &&
      Objects.equals(this.insidePolygon, consequenceParams.insidePolygon) &&
      Objects.equals(this.naturalLanguages, consequenceParams.naturalLanguages) &&
      Objects.equals(this.ruleContexts, consequenceParams.ruleContexts) &&
      Objects.equals(this.personalizationImpact, consequenceParams.personalizationImpact) &&
      Objects.equals(this.userToken, consequenceParams.userToken) &&
      Objects.equals(this.getRankingInfo, consequenceParams.getRankingInfo) &&
      Objects.equals(this.synonyms, consequenceParams.synonyms) &&
      Objects.equals(this.clickAnalytics, consequenceParams.clickAnalytics) &&
      Objects.equals(this.analytics, consequenceParams.analytics) &&
      Objects.equals(this.analyticsTags, consequenceParams.analyticsTags) &&
      Objects.equals(this.percentileComputation, consequenceParams.percentileComputation) &&
      Objects.equals(this.enableABTest, consequenceParams.enableABTest) &&
      Objects.equals(this.attributesToRetrieve, consequenceParams.attributesToRetrieve) &&
      Objects.equals(this.ranking, consequenceParams.ranking) &&
      Objects.equals(this.customRanking, consequenceParams.customRanking) &&
      Objects.equals(this.relevancyStrictness, consequenceParams.relevancyStrictness) &&
      Objects.equals(this.attributesToHighlight, consequenceParams.attributesToHighlight) &&
      Objects.equals(this.attributesToSnippet, consequenceParams.attributesToSnippet) &&
      Objects.equals(this.highlightPreTag, consequenceParams.highlightPreTag) &&
      Objects.equals(this.highlightPostTag, consequenceParams.highlightPostTag) &&
      Objects.equals(this.snippetEllipsisText, consequenceParams.snippetEllipsisText) &&
      Objects.equals(this.restrictHighlightAndSnippetArrays, consequenceParams.restrictHighlightAndSnippetArrays) &&
      Objects.equals(this.hitsPerPage, consequenceParams.hitsPerPage) &&
      Objects.equals(this.minWordSizefor1Typo, consequenceParams.minWordSizefor1Typo) &&
      Objects.equals(this.minWordSizefor2Typos, consequenceParams.minWordSizefor2Typos) &&
      Objects.equals(this.typoTolerance, consequenceParams.typoTolerance) &&
      Objects.equals(this.allowTyposOnNumericTokens, consequenceParams.allowTyposOnNumericTokens) &&
      Objects.equals(this.disableTypoToleranceOnAttributes, consequenceParams.disableTypoToleranceOnAttributes) &&
      Objects.equals(this.ignorePlurals, consequenceParams.ignorePlurals) &&
      Objects.equals(this.removeStopWords, consequenceParams.removeStopWords) &&
      Objects.equals(this.keepDiacriticsOnCharacters, consequenceParams.keepDiacriticsOnCharacters) &&
      Objects.equals(this.queryLanguages, consequenceParams.queryLanguages) &&
      Objects.equals(this.decompoundQuery, consequenceParams.decompoundQuery) &&
      Objects.equals(this.enableRules, consequenceParams.enableRules) &&
      Objects.equals(this.enablePersonalization, consequenceParams.enablePersonalization) &&
      Objects.equals(this.queryType, consequenceParams.queryType) &&
      Objects.equals(this.removeWordsIfNoResults, consequenceParams.removeWordsIfNoResults) &&
      Objects.equals(this.mode, consequenceParams.mode) &&
      Objects.equals(this.semanticSearch, consequenceParams.semanticSearch) &&
      Objects.equals(this.advancedSyntax, consequenceParams.advancedSyntax) &&
      Objects.equals(this.optionalWords, consequenceParams.optionalWords) &&
      Objects.equals(this.disableExactOnAttributes, consequenceParams.disableExactOnAttributes) &&
      Objects.equals(this.exactOnSingleWordQuery, consequenceParams.exactOnSingleWordQuery) &&
      Objects.equals(this.alternativesAsExact, consequenceParams.alternativesAsExact) &&
      Objects.equals(this.advancedSyntaxFeatures, consequenceParams.advancedSyntaxFeatures) &&
      Objects.equals(this.distinct, consequenceParams.distinct) &&
      Objects.equals(this.replaceSynonymsInHighlight, consequenceParams.replaceSynonymsInHighlight) &&
      Objects.equals(this.minProximity, consequenceParams.minProximity) &&
      Objects.equals(this.responseFields, consequenceParams.responseFields) &&
      Objects.equals(this.maxFacetHits, consequenceParams.maxFacetHits) &&
      Objects.equals(this.maxValuesPerFacet, consequenceParams.maxValuesPerFacet) &&
      Objects.equals(this.sortFacetValuesBy, consequenceParams.sortFacetValuesBy) &&
      Objects.equals(this.attributeCriteriaComputedByMinProximity, consequenceParams.attributeCriteriaComputedByMinProximity) &&
      Objects.equals(this.renderingContent, consequenceParams.renderingContent) &&
      Objects.equals(this.enableReRanking, consequenceParams.enableReRanking) &&
      Objects.equals(this.reRankingApplyFilter, consequenceParams.reRankingApplyFilter) &&
      Objects.equals(this.query, consequenceParams.query) &&
      Objects.equals(this.automaticFacetFilters, consequenceParams.automaticFacetFilters) &&
      Objects.equals(this.automaticOptionalFacetFilters, consequenceParams.automaticOptionalFacetFilters)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      similarQuery,
      filters,
      facetFilters,
      optionalFilters,
      numericFilters,
      tagFilters,
      sumOrFiltersScores,
      restrictSearchableAttributes,
      facets,
      facetingAfterDistinct,
      page,
      offset,
      length,
      aroundLatLng,
      aroundLatLngViaIP,
      aroundRadius,
      aroundPrecision,
      minimumAroundRadius,
      insideBoundingBox,
      insidePolygon,
      naturalLanguages,
      ruleContexts,
      personalizationImpact,
      userToken,
      getRankingInfo,
      synonyms,
      clickAnalytics,
      analytics,
      analyticsTags,
      percentileComputation,
      enableABTest,
      attributesToRetrieve,
      ranking,
      customRanking,
      relevancyStrictness,
      attributesToHighlight,
      attributesToSnippet,
      highlightPreTag,
      highlightPostTag,
      snippetEllipsisText,
      restrictHighlightAndSnippetArrays,
      hitsPerPage,
      minWordSizefor1Typo,
      minWordSizefor2Typos,
      typoTolerance,
      allowTyposOnNumericTokens,
      disableTypoToleranceOnAttributes,
      ignorePlurals,
      removeStopWords,
      keepDiacriticsOnCharacters,
      queryLanguages,
      decompoundQuery,
      enableRules,
      enablePersonalization,
      queryType,
      removeWordsIfNoResults,
      mode,
      semanticSearch,
      advancedSyntax,
      optionalWords,
      disableExactOnAttributes,
      exactOnSingleWordQuery,
      alternativesAsExact,
      advancedSyntaxFeatures,
      distinct,
      replaceSynonymsInHighlight,
      minProximity,
      responseFields,
      maxFacetHits,
      maxValuesPerFacet,
      sortFacetValuesBy,
      attributeCriteriaComputedByMinProximity,
      renderingContent,
      enableReRanking,
      reRankingApplyFilter,
      query,
      automaticFacetFilters,
      automaticOptionalFacetFilters
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsequenceParams {\n");
    sb.append("    similarQuery: ").append(toIndentedString(similarQuery)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    facetFilters: ").append(toIndentedString(facetFilters)).append("\n");
    sb.append("    optionalFilters: ").append(toIndentedString(optionalFilters)).append("\n");
    sb.append("    numericFilters: ").append(toIndentedString(numericFilters)).append("\n");
    sb.append("    tagFilters: ").append(toIndentedString(tagFilters)).append("\n");
    sb.append("    sumOrFiltersScores: ").append(toIndentedString(sumOrFiltersScores)).append("\n");
    sb.append("    restrictSearchableAttributes: ").append(toIndentedString(restrictSearchableAttributes)).append("\n");
    sb.append("    facets: ").append(toIndentedString(facets)).append("\n");
    sb.append("    facetingAfterDistinct: ").append(toIndentedString(facetingAfterDistinct)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    aroundLatLng: ").append(toIndentedString(aroundLatLng)).append("\n");
    sb.append("    aroundLatLngViaIP: ").append(toIndentedString(aroundLatLngViaIP)).append("\n");
    sb.append("    aroundRadius: ").append(toIndentedString(aroundRadius)).append("\n");
    sb.append("    aroundPrecision: ").append(toIndentedString(aroundPrecision)).append("\n");
    sb.append("    minimumAroundRadius: ").append(toIndentedString(minimumAroundRadius)).append("\n");
    sb.append("    insideBoundingBox: ").append(toIndentedString(insideBoundingBox)).append("\n");
    sb.append("    insidePolygon: ").append(toIndentedString(insidePolygon)).append("\n");
    sb.append("    naturalLanguages: ").append(toIndentedString(naturalLanguages)).append("\n");
    sb.append("    ruleContexts: ").append(toIndentedString(ruleContexts)).append("\n");
    sb.append("    personalizationImpact: ").append(toIndentedString(personalizationImpact)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("    getRankingInfo: ").append(toIndentedString(getRankingInfo)).append("\n");
    sb.append("    synonyms: ").append(toIndentedString(synonyms)).append("\n");
    sb.append("    clickAnalytics: ").append(toIndentedString(clickAnalytics)).append("\n");
    sb.append("    analytics: ").append(toIndentedString(analytics)).append("\n");
    sb.append("    analyticsTags: ").append(toIndentedString(analyticsTags)).append("\n");
    sb.append("    percentileComputation: ").append(toIndentedString(percentileComputation)).append("\n");
    sb.append("    enableABTest: ").append(toIndentedString(enableABTest)).append("\n");
    sb.append("    attributesToRetrieve: ").append(toIndentedString(attributesToRetrieve)).append("\n");
    sb.append("    ranking: ").append(toIndentedString(ranking)).append("\n");
    sb.append("    customRanking: ").append(toIndentedString(customRanking)).append("\n");
    sb.append("    relevancyStrictness: ").append(toIndentedString(relevancyStrictness)).append("\n");
    sb.append("    attributesToHighlight: ").append(toIndentedString(attributesToHighlight)).append("\n");
    sb.append("    attributesToSnippet: ").append(toIndentedString(attributesToSnippet)).append("\n");
    sb.append("    highlightPreTag: ").append(toIndentedString(highlightPreTag)).append("\n");
    sb.append("    highlightPostTag: ").append(toIndentedString(highlightPostTag)).append("\n");
    sb.append("    snippetEllipsisText: ").append(toIndentedString(snippetEllipsisText)).append("\n");
    sb.append("    restrictHighlightAndSnippetArrays: ").append(toIndentedString(restrictHighlightAndSnippetArrays)).append("\n");
    sb.append("    hitsPerPage: ").append(toIndentedString(hitsPerPage)).append("\n");
    sb.append("    minWordSizefor1Typo: ").append(toIndentedString(minWordSizefor1Typo)).append("\n");
    sb.append("    minWordSizefor2Typos: ").append(toIndentedString(minWordSizefor2Typos)).append("\n");
    sb.append("    typoTolerance: ").append(toIndentedString(typoTolerance)).append("\n");
    sb.append("    allowTyposOnNumericTokens: ").append(toIndentedString(allowTyposOnNumericTokens)).append("\n");
    sb.append("    disableTypoToleranceOnAttributes: ").append(toIndentedString(disableTypoToleranceOnAttributes)).append("\n");
    sb.append("    ignorePlurals: ").append(toIndentedString(ignorePlurals)).append("\n");
    sb.append("    removeStopWords: ").append(toIndentedString(removeStopWords)).append("\n");
    sb.append("    keepDiacriticsOnCharacters: ").append(toIndentedString(keepDiacriticsOnCharacters)).append("\n");
    sb.append("    queryLanguages: ").append(toIndentedString(queryLanguages)).append("\n");
    sb.append("    decompoundQuery: ").append(toIndentedString(decompoundQuery)).append("\n");
    sb.append("    enableRules: ").append(toIndentedString(enableRules)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    removeWordsIfNoResults: ").append(toIndentedString(removeWordsIfNoResults)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    semanticSearch: ").append(toIndentedString(semanticSearch)).append("\n");
    sb.append("    advancedSyntax: ").append(toIndentedString(advancedSyntax)).append("\n");
    sb.append("    optionalWords: ").append(toIndentedString(optionalWords)).append("\n");
    sb.append("    disableExactOnAttributes: ").append(toIndentedString(disableExactOnAttributes)).append("\n");
    sb.append("    exactOnSingleWordQuery: ").append(toIndentedString(exactOnSingleWordQuery)).append("\n");
    sb.append("    alternativesAsExact: ").append(toIndentedString(alternativesAsExact)).append("\n");
    sb.append("    advancedSyntaxFeatures: ").append(toIndentedString(advancedSyntaxFeatures)).append("\n");
    sb.append("    distinct: ").append(toIndentedString(distinct)).append("\n");
    sb.append("    replaceSynonymsInHighlight: ").append(toIndentedString(replaceSynonymsInHighlight)).append("\n");
    sb.append("    minProximity: ").append(toIndentedString(minProximity)).append("\n");
    sb.append("    responseFields: ").append(toIndentedString(responseFields)).append("\n");
    sb.append("    maxFacetHits: ").append(toIndentedString(maxFacetHits)).append("\n");
    sb.append("    maxValuesPerFacet: ").append(toIndentedString(maxValuesPerFacet)).append("\n");
    sb.append("    sortFacetValuesBy: ").append(toIndentedString(sortFacetValuesBy)).append("\n");
    sb
      .append("    attributeCriteriaComputedByMinProximity: ")
      .append(toIndentedString(attributeCriteriaComputedByMinProximity))
      .append("\n");
    sb.append("    renderingContent: ").append(toIndentedString(renderingContent)).append("\n");
    sb.append("    enableReRanking: ").append(toIndentedString(enableReRanking)).append("\n");
    sb.append("    reRankingApplyFilter: ").append(toIndentedString(reRankingApplyFilter)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    automaticFacetFilters: ").append(toIndentedString(automaticFacetFilters)).append("\n");
    sb.append("    automaticOptionalFacetFilters: ").append(toIndentedString(automaticOptionalFacetFilters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
