/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils;

import com.algolia.exceptions.AlgoliaRetriesExceededException;
import com.algolia.exceptions.AlgoliaRuntimeException;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TaskUtils {
    public static final int DEFAULT_MAX_RETRIES = 50;
    public static final IntUnaryOperator DEFAULT_TIMEOUT = retries -> Math.min(retries * 200, 5000);

    private TaskUtils() {
    }

    public static <T> T retryUntil(Supplier<T> func, Predicate<T> validate, int maxRetries, IntUnaryOperator timeout) throws AlgoliaRuntimeException {
        int retryCount;
        for (retryCount = 0; retryCount < maxRetries; ++retryCount) {
            T resp = func.get();
            if (validate.test(resp)) {
                return resp;
            }
            try {
                Thread.sleep(timeout.applyAsInt(retryCount));
                continue;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        throw new AlgoliaRetriesExceededException("The maximum number of retries exceeded. (" + (retryCount + 1) + "/" + maxRetries + ")");
    }
}

