// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.analytics.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AnalyticsClient extends ApiClient {

  private static final String[] allowedRegions = { "de", "us" };

  public AnalyticsClient(String appId, String apiKey) {
    this(appId, apiKey, null, null);
  }

  public AnalyticsClient(String appId, String apiKey, ClientOptions options) {
    this(appId, apiKey, null, options);
  }

  public AnalyticsClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public AnalyticsClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "Analytics", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = region == null;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (!found) {
      throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
    }

    String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Retrieves the add-to-cart rate for all of your searches with at least one add-to-cart event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAddToCartRateResponse getAddToCartRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAddToCartRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the add-to-cart rate for all of your searches with at least one add-to-cart event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getAddToCartRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the add-to-cart rate for all of your searches with at least one add-to-cart event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAddToCartRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the add-to-cart rate for all of your searches with at least one add-to-cart event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getAddToCartRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the add-to-cart rate for all of your searches with at least one
   * add-to-cart event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getAddToCartRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/conversions/addToCartRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetAddToCartRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the add-to-cart rate for all of your searches with at least one
   * add-to-cart event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getAddToCartRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the add-to-cart rate for all of your searches with at least one
   * add-to-cart event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getAddToCartRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the add-to-cart rate for all of your searches with at least one
   * add-to-cart event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getAddToCartRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the average click position of your search results, including a daily breakdown. The
   * average click position is the average of all clicked search results' positions. For example, if
   * users only ever click on the first result for any search, the average click position is 1. By
   * default, the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAverageClickPositionAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the average click position of your search results, including a daily breakdown. The
   * average click position is the average of all clicked search results' positions. For example, if
   * users only ever click on the first result for any search, the average click position is 1. By
   * default, the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the average click position of your search results, including a daily breakdown. The
   * average click position is the average of all clicked search results' positions. For example, if
   * users only ever click on the first result for any search, the average click position is 1. By
   * default, the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the average click position of your search results, including a daily breakdown. The
   * average click position is the average of all clicked search results' positions. For example, if
   * users only ever click on the first result for any search, the average click position is 1. By
   * default, the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the average click position of your search results, including a daily
   * breakdown. The average click position is the average of all clicked search results' positions.
   * For example, if users only ever click on the first result for any search, the average click
   * position is 1. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getAverageClickPosition`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/averageClickPosition")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetAverageClickPositionResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the average click position of your search results, including a daily
   * breakdown. The average click position is the average of all clicked search results' positions.
   * For example, if users only ever click on the first result for any search, the average click
   * position is 1. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the average click position of your search results, including a daily
   * breakdown. The average click position is the average of all clicked search results' positions.
   * For example, if users only ever click on the first result for any search, the average click
   * position is 1. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the average click position of your search results, including a daily
   * breakdown. The average click position is the average of all clicked search results' positions.
   * For example, if users only ever click on the first result for any search, the average click
   * position is 1. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the positions in the search results and their associated number of clicks. This lets
   * you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClickPositionsAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the positions in the search results and their associated number of clicks. This lets
   * you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getClickPositions(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the positions in the search results and their associated number of clicks. This lets
   * you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getClickPositions(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the positions in the search results and their associated number of clicks. This lets
   * you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickPositions(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the positions in the search results and their associated number of
   * clicks. This lets you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickPositions`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/positions")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetClickPositionsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the positions in the search results and their associated number of
   * clicks. This lets you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the positions in the search results and their associated number of
   * clicks. This lets you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the positions in the search results and their associated number of
   * clicks. This lets you check how many clicks the first, second, or tenth search results receive.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the click-through rate for all of your searches with at least one click event,
   * including a daily breakdown By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClickThroughRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the click-through rate for all of your searches with at least one click event,
   * including a daily breakdown By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the click-through rate for all of your searches with at least one click event,
   * including a daily breakdown By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the click-through rate for all of your searches with at least one click event,
   * including a daily breakdown By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the click-through rate for all of your searches with at least one
   * click event, including a daily breakdown By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickThroughRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/clickThroughRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetClickThroughRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the click-through rate for all of your searches with at least one
   * click event, including a daily breakdown By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the click-through rate for all of your searches with at least one
   * click event, including a daily breakdown By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the click-through rate for all of your searches with at least one
   * click event, including a daily breakdown By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the conversion rate for all of your searches with at least one conversion event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversionRateResponse getConversionRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConversionRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the conversion rate for all of your searches with at least one conversion event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversionRateResponse getConversionRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getConversionRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the conversion rate for all of your searches with at least one conversion event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversionRateResponse getConversionRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getConversionRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the conversion rate for all of your searches with at least one conversion event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversionRateResponse getConversionRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getConversionRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the conversion rate for all of your searches with at least one
   * conversion event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getConversionRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/conversions/conversionRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetConversionRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the conversion rate for all of your searches with at least one
   * conversion event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getConversionRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the conversion rate for all of your searches with at least one
   * conversion event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getConversionRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the conversion rate for all of your searches with at least one
   * conversion event, including a daily breakdown. By default, the analyzed period includes the
   * last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getConversionRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the fraction of searches that didn't lead to any click within a time range, including
   * a daily breakdown. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getNoClickRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the fraction of searches that didn't lead to any click within a time range, including
   * a daily breakdown. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the fraction of searches that didn't lead to any click within a time range, including
   * a daily breakdown. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the fraction of searches that didn't lead to any click within a time range, including
   * a daily breakdown. By default, the analyzed period includes the last eight days including the
   * current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't lead to any click within a time
   * range, including a daily breakdown. By default, the analyzed period includes the last eight
   * days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoClickRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noClickRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetNoClickRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't lead to any click within a time
   * range, including a daily breakdown. By default, the analyzed period includes the last eight
   * days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't lead to any click within a time
   * range, including a daily breakdown. By default, the analyzed period includes the last eight
   * days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't lead to any click within a time
   * range, including a daily breakdown. By default, the analyzed period includes the last eight
   * days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the fraction of searches that didn't return any results within a time range,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getNoResultsRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the fraction of searches that didn't return any results within a time range,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the fraction of searches that didn't return any results within a time range,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the fraction of searches that didn't return any results within a time range,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't return any results within a
   * time range, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoResultsRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noResultRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetNoResultsRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't return any results within a
   * time range, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't return any results within a
   * time range, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the fraction of searches that didn't return any results within a
   * time range, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the purchase rate for all of your searches with at least one purchase event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetPurchaseRateResponse getPurchaseRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getPurchaseRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the purchase rate for all of your searches with at least one purchase event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getPurchaseRate(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the purchase rate for all of your searches with at least one purchase event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getPurchaseRate(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the purchase rate for all of your searches with at least one purchase event,
   * including a daily breakdown. By default, the analyzed period includes the last eight days
   * including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getPurchaseRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the purchase rate for all of your searches with at least one
   * purchase event, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getPurchaseRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/conversions/purchaseRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetPurchaseRateResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the purchase rate for all of your searches with at least one
   * purchase event, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getPurchaseRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the purchase rate for all of your searches with at least one
   * purchase event, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getPurchaseRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the purchase rate for all of your searches with at least one
   * purchase event, including a daily breakdown. By default, the analyzed period includes the last
   * eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getPurchaseRateAsync(index, null, null, null, null);
  }

  /**
   * Retrieves revenue-related metrics, such as the total revenue or the average order value. To
   * retrieve revenue-related metrics, sent purchase events. By default, the analyzed period
   * includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRevenue getRevenue(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRevenueAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves revenue-related metrics, such as the total revenue or the average order value. To
   * retrieve revenue-related metrics, sent purchase events. By default, the analyzed period
   * includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRevenue getRevenue(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
    return this.getRevenue(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves revenue-related metrics, such as the total revenue or the average order value. To
   * retrieve revenue-related metrics, sent purchase events. By default, the analyzed period
   * includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRevenue getRevenue(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getRevenue(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves revenue-related metrics, such as the total revenue or the average order value. To
   * retrieve revenue-related metrics, sent purchase events. By default, the analyzed period
   * includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRevenue getRevenue(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getRevenue(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves revenue-related metrics, such as the total revenue or the average
   * order value. To retrieve revenue-related metrics, sent purchase events. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRevenue> getRevenueAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getRevenue`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/conversions/revenue")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetRevenue>() {});
  }

  /**
   * (asynchronously) Retrieves revenue-related metrics, such as the total revenue or the average
   * order value. To retrieve revenue-related metrics, sent purchase events. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getRevenueAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves revenue-related metrics, such as the total revenue or the average
   * order value. To retrieve revenue-related metrics, sent purchase events. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getRevenueAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves revenue-related metrics, such as the total revenue or the average
   * order value. To retrieve revenue-related metrics, sent purchase events. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getRevenueAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the number of searches within a time range, including a daily breakdown. By default,
   * the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesCountAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the number of searches within a time range, including a daily breakdown. By default,
   * the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the number of searches within a time range, including a daily breakdown. By default,
   * the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the number of searches within a time range, including a daily breakdown. By default,
   * the analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the number of searches within a time range, including a daily
   * breakdown. By default, the analyzed period includes the last eight days including the current
   * day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesCount`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/count")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesCountResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the number of searches within a time range, including a daily
   * breakdown. By default, the analyzed period includes the last eight days including the current
   * day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the number of searches within a time range, including a daily
   * breakdown. By default, the analyzed period includes the last eight days including the current
   * day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the number of searches within a time range, including a daily
   * breakdown. By default, the analyzed period includes the last eight days including the current
   * day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, null, null, null, null);
  }

  /**
   * Retrieves the most popular searches that didn't lead to any clicks, from the 1,000 most
   * frequent searches.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Retrieves the most popular searches that didn't lead to any clicks, from the 1,000 most
   * frequent searches.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the most popular searches that didn't lead to any clicks, from the 1,000 most
   * frequent searches.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the most popular searches that didn't lead to any clicks, from the 1,000 most
   * frequent searches.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't lead to any clicks, from the
   * 1,000 most frequent searches.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoClicks`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noClicks")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesNoClicksResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't lead to any clicks, from the
   * 1,000 most frequent searches.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't lead to any clicks, from the
   * 1,000 most frequent searches.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't lead to any clicks, from the
   * 1,000 most frequent searches.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, null, null, null, null, null, null);
  }

  /**
   * Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoResults`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noResults")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesNoResultsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the most popular searches that didn't return any results.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, null, null, null, null, null, null);
  }

  /**
   * Retrieves the time when the Analytics data for the specified index was last updated. The
   * Analytics data is updated every 5 minutes.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetStatusResponse getStatus(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getStatusAsync(index, requestOptions));
  }

  /**
   * Retrieves the time when the Analytics data for the specified index was last updated. The
   * Analytics data is updated every 5 minutes.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetStatusResponse getStatus(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getStatus(index, null);
  }

  /**
   * (asynchronously) Retrieves the time when the Analytics data for the specified index was last
   * updated. The Analytics data is updated every 5 minutes.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getStatus`.");

    HttpRequest request = HttpRequest.builder().setPath("/2/status").setMethod("GET").addQueryParameter("index", index).build();
    return executeAsync(request, requestOptions, new TypeReference<GetStatusResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the time when the Analytics data for the specified index was last
   * updated. The Analytics data is updated every 5 minutes.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getStatusAsync(index, null);
  }

  /**
   * Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopCountries`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/countries")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopCountriesResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the countries with the most searches to your index.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, null, null, null, null, null, null);
  }

  /**
   * Retrieves the most frequently used filter attributes. These are attributes of your records that
   * you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Retrieves the most frequently used filter attributes. These are attributes of your records that
   * you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the most frequently used filter attributes. These are attributes of your records that
   * you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the most frequently used filter attributes. These are attributes of your records that
   * you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filter attributes. These are attributes of
   * your records that you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterAttributes`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFilterAttributesResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the most frequently used filter attributes. These are attributes of
   * your records that you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filter attributes. These are attributes of
   * your records that you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filter attributes. These are attributes of
   * your records that you included in the `attributesForFaceting` setting.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, null);
  }

  /**
   * Retrieves the most frequent filter (facet) values for a filter attribute. These are attributes
   * of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, requestOptions)
    );
  }

  /**
   * Retrieves the most frequent filter (facet) values for a filter attribute. These are attributes
   * of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the most frequent filter (facet) values for a filter attribute. These are attributes
   * of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the most frequent filter (facet) values for a filter attribute. These are attributes
   * of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the most frequent filter (facet) values for a filter attribute.
   * These are attributes of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(attribute, "Parameter `attribute` is required when calling `getTopFilterForAttribute`.");

    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterForAttribute`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters/{attribute}", attribute)
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFilterForAttributeResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the most frequent filter (facet) values for a filter attribute.
   * These are attributes of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the most frequent filter (facet) values for a filter attribute.
   * These are attributes of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the most frequent filter (facet) values for a filter attribute.
   * These are attributes of your records that you included in the `attributesForFaceting` setting.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, null);
  }

  /**
   * Retrieves the most frequently used filters for a search that didn't return any results. To get
   * the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Retrieves the most frequently used filters for a search that didn't return any results. To get
   * the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the most frequently used filters for a search that didn't return any results. To get
   * the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the most frequently used filters for a search that didn't return any results. To get
   * the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filters for a search that didn't return any
   * results. To get the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFiltersNoResults`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters/noResults")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFiltersNoResultsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the most frequently used filters for a search that didn't return any
   * results. To get the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filters for a search that didn't return any
   * results. To get the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the most frequently used filters for a search that didn't return any
   * results. To get the most frequent searches without results, use the [Retrieve searches without
   * results](#tag/search/operation/getSearchesNoResults) operation.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, null);
  }

  /**
   * Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTopHitsAsync(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, requestOptions)
    );
  }

  /**
   * Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopHits(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopHits(index, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopHits(index, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopHits`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/hits")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("clickAnalytics", clickAnalytics)
      .addQueryParameter("revenueAnalytics", revenueAnalytics)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopHitsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param search Search query. (optional)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the object IDs of the most frequent search results.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param orderBy Attribute by which to order the response items. If the `clickAnalytics`
   *     parameter is false, only `searchCount` is available. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(
    @Nonnull String index,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTopSearchesAsync(
        index,
        clickAnalytics,
        revenueAnalytics,
        startDate,
        endDate,
        orderBy,
        direction,
        limit,
        offset,
        tags,
        requestOptions
      )
    );
  }

  /**
   * Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param orderBy Attribute by which to order the response items. If the `clickAnalytics`
   *     parameter is false, only `searchCount` is available. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(
    @Nonnull String index,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, clickAnalytics, revenueAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
  }

  /**
   * Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param orderBy Attribute by which to order the response items. If the `clickAnalytics`
   *     parameter is false, only `searchCount` is available. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(
    @Nonnull String index,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopSearches`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("clickAnalytics", clickAnalytics)
      .addQueryParameter("revenueAnalytics", revenueAnalytics)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("orderBy", orderBy)
      .addQueryParameter("direction", direction)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopSearchesResponse>() {});
  }

  /**
   * (asynchronously) Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param clickAnalytics Whether to include metrics related to click and conversion events in the
   *     response. (optional, default to false)
   * @param revenueAnalytics Whether to include revenue-related metrics in the response. If true,
   *     metrics related to click and conversion events are also included in the response.
   *     (optional, default to false)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param orderBy Attribute by which to order the response items. If the `clickAnalytics`
   *     parameter is false, only `searchCount` is available. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of items to return. (optional, default to 10)
   * @param offset Position of the first item to return. (optional, default to 0)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(
    @Nonnull String index,
    Boolean clickAnalytics,
    Boolean revenueAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(
        index,
        clickAnalytics,
        revenueAnalytics,
        startDate,
        endDate,
        orderBy,
        direction,
        limit,
        offset,
        tags,
        null
      );
  }

  /**
   * (asynchronously) Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the most popular search terms.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Retrieves the number of unique users within a time range, including a daily breakdown. Since
   * this endpoint returns the number of unique users, the sum of the daily values might be
   * different from the total number. By default, Algolia distinguishes search users by their IP
   * address, _unless_ you include a pseudonymous user identifier in your search requests with the
   * `userToken` API parameter or `x-algolia-usertoken` request header. By default, the analyzed
   * period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getUsersCountAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Retrieves the number of unique users within a time range, including a daily breakdown. Since
   * this endpoint returns the number of unique users, the sum of the daily values might be
   * different from the total number. By default, Algolia distinguishes search users by their IP
   * address, _unless_ you include a pseudonymous user identifier in your search requests with the
   * `userToken` API parameter or `x-algolia-usertoken` request header. By default, the analyzed
   * period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getUsersCount(index, startDate, endDate, tags, null);
  }

  /**
   * Retrieves the number of unique users within a time range, including a daily breakdown. Since
   * this endpoint returns the number of unique users, the sum of the daily values might be
   * different from the total number. By default, Algolia distinguishes search users by their IP
   * address, _unless_ you include a pseudonymous user identifier in your search requests with the
   * `userToken` API parameter or `x-algolia-usertoken` request header. By default, the analyzed
   * period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getUsersCount(index, null, null, null, requestOptions);
  }

  /**
   * Retrieves the number of unique users within a time range, including a daily breakdown. Since
   * this endpoint returns the number of unique users, the sum of the daily values might be
   * different from the total number. By default, Algolia distinguishes search users by their IP
   * address, _unless_ you include a pseudonymous user identifier in your search requests with the
   * `userToken` API parameter or `x-algolia-usertoken` request header. By default, the analyzed
   * period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getUsersCount(index, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves the number of unique users within a time range, including a daily
   * breakdown. Since this endpoint returns the number of unique users, the sum of the daily values
   * might be different from the total number. By default, Algolia distinguishes search users by
   * their IP address, _unless_ you include a pseudonymous user identifier in your search requests
   * with the `userToken` API parameter or `x-algolia-usertoken` request header. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getUsersCount`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/users/count")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetUsersCountResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the number of unique users within a time range, including a daily
   * breakdown. Since this endpoint returns the number of unique users, the sum of the daily values
   * might be different from the total number. By default, Algolia distinguishes search users by
   * their IP address, _unless_ you include a pseudonymous user identifier in your search requests
   * with the `userToken` API parameter or `x-algolia-usertoken` request header. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param startDate Start date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param endDate End date (`YYYY-MM-DD`) of the period to analyze. (optional)
   * @param tags Tags by which to segment the analytics. You can combine multiple tags with `OR` and
   *     `AND`. Tags must be URL-encoded. For more information, see [Segment your analytics
   *     data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/). (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Retrieves the number of unique users within a time range, including a daily
   * breakdown. Since this endpoint returns the number of unique users, the sum of the daily values
   * might be different from the total number. By default, Algolia distinguishes search users by
   * their IP address, _unless_ you include a pseudonymous user identifier in your search requests
   * with the `userToken` API parameter or `x-algolia-usertoken` request header. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the number of unique users within a time range, including a daily
   * breakdown. Since this endpoint returns the number of unique users, the sum of the daily values
   * might be different from the total number. By default, Algolia distinguishes search users by
   * their IP address, _unless_ you include a pseudonymous user identifier in your search requests
   * with the `userToken` API parameter or `x-algolia-usertoken` request header. By default, the
   * analyzed period includes the last eight days including the current day.
   *
   * @param index Index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, null, null, null, null);
  }
}
