// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.querysuggestions.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class QuerySuggestionsClient extends ApiClient {

  private static final String[] allowedRegions = { "eu", "us" };

  public QuerySuggestionsClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public QuerySuggestionsClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "QuerySuggestions", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = false;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (region == null || !found) {
      throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
    }

    String url = "query-suggestions.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * Creates a new Query Suggestions configuration. You can have up to 100 configurations per
   * Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse createConfig(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createConfigAsync(querySuggestionsConfigurationWithIndex, requestOptions));
  }

  /**
   * Creates a new Query Suggestions configuration. You can have up to 100 configurations per
   * Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse createConfig(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex)
    throws AlgoliaRuntimeException {
    return this.createConfig(querySuggestionsConfigurationWithIndex, null);
  }

  /**
   * (asynchronously) Creates a new Query Suggestions configuration. You can have up to 100
   * configurations per Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> createConfigAsync(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(
      querySuggestionsConfigurationWithIndex,
      "Parameter `querySuggestionsConfigurationWithIndex` is required when calling" + " `createConfig`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/configs")
      .setMethod("POST")
      .setBody(querySuggestionsConfigurationWithIndex)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Creates a new Query Suggestions configuration. You can have up to 100
   * configurations per Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> createConfigAsync(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex
  ) throws AlgoliaRuntimeException {
    return this.createConfigAsync(querySuggestionsConfigurationWithIndex, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Deletes a Query Suggestions configuration. Deleting only removes the configuration and stops
   * updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the
   * Search API and the [Delete an index](/specs/search#tag/Indices/operation/deleteIndex)
   * operation.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse deleteConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteConfigAsync(indexName, requestOptions));
  }

  /**
   * Deletes a Query Suggestions configuration. Deleting only removes the configuration and stops
   * updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the
   * Search API and the [Delete an index](/specs/search#tag/Indices/operation/deleteIndex)
   * operation.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse deleteConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteConfig(indexName, null);
  }

  /**
   * (asynchronously) Deletes a Query Suggestions configuration. Deleting only removes the
   * configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions
   * index itself, use the Search API and the [Delete an
   * index](/specs/search#tag/Indices/operation/deleteIndex) operation.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteConfig`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Deletes a Query Suggestions configuration. Deleting only removes the
   * configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions
   * index itself, use the Search API and the [Delete an
   * index](/specs/search#tag/Indices/operation/deleteIndex) operation.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteConfigAsync(indexName, null);
  }

  /**
   * Retrieves all Query Suggestions configurations of your Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<QuerySuggestionsConfigurationResponse> getAllConfigs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAllConfigsAsync(requestOptions));
  }

  /**
   * Retrieves all Query Suggestions configurations of your Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<QuerySuggestionsConfigurationResponse> getAllConfigs() throws AlgoliaRuntimeException {
    return this.getAllConfigs(null);
  }

  /**
   * (asynchronously) Retrieves all Query Suggestions configurations of your Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<List<QuerySuggestionsConfigurationResponse>>() {});
  }

  /**
   * (asynchronously) Retrieves all Query Suggestions configurations of your Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync() throws AlgoliaRuntimeException {
    return this.getAllConfigsAsync(null);
  }

  /**
   * Retrieves a single Query Suggestions configuration by its index name.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConfigAsync(indexName, requestOptions));
  }

  /**
   * Retrieves a single Query Suggestions configuration by its index name.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfig(indexName, null);
  }

  /**
   * (asynchronously) Retrieves a single Query Suggestions configuration by its index name.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfig`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<QuerySuggestionsConfigurationResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a single Query Suggestions configuration by its index name.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigAsync(indexName, null);
  }

  /**
   * Reports the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConfigStatusAsync(indexName, requestOptions));
  }

  /**
   * Reports the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigStatus(indexName, null);
  }

  /**
   * (asynchronously) Reports the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfigStatus`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}/status", indexName).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<GetConfigStatus200Response>() {});
  }

  /**
   * (asynchronously) Reports the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigStatusAsync(indexName, null);
  }

  /**
   * Retrieves the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogFile200Response getLogFile(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getLogFileAsync(indexName, requestOptions));
  }

  /**
   * Retrieves the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogFile200Response getLogFile(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getLogFile(indexName, null);
  }

  /**
   * (asynchronously) Retrieves the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getLogFile`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/logs/{indexName}", indexName).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<GetLogFile200Response>() {});
  }

  /**
   * (asynchronously) Retrieves the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getLogFileAsync(indexName, null);
  }

  /**
   * Updates a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse updateConfig(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateConfigAsync(indexName, querySuggestionsConfiguration, requestOptions));
  }

  /**
   * Updates a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration)
    throws AlgoliaRuntimeException {
    return this.updateConfig(indexName, querySuggestionsConfiguration, null);
  }

  /**
   * (asynchronously) Updates a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> updateConfigAsync(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `updateConfig`.");

    Parameters.requireNonNull(
      querySuggestionsConfiguration,
      "Parameter `querySuggestionsConfiguration` is required when calling `updateConfig`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/configs/{indexName}", indexName)
      .setMethod("PUT")
      .setBody(querySuggestionsConfiguration)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Updates a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> updateConfigAsync(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration
  ) throws AlgoliaRuntimeException {
    return this.updateConfigAsync(indexName, querySuggestionsConfiguration, null);
  }
}
