// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.analytics;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** GetConversionRateResponse */
public class GetConversionRateResponse {

  @JsonProperty("rate")
  private Double rate;

  @JsonProperty("trackedSearchCount")
  private Integer trackedSearchCount;

  @JsonProperty("conversionCount")
  private Integer conversionCount;

  @JsonProperty("dates")
  private List<DailyConversionRates> dates = new ArrayList<>();

  public GetConversionRateResponse setRate(Double rate) {
    this.rate = rate;
    return this;
  }

  /**
   * Conversion rate, calculated as number of tracked searches with at least one conversion event
   * divided by the number of tracked searches. If null, Algolia didn't receive any search requests
   * with `clickAnalytics` set to true. minimum: 0 maximum: 1
   */
  @javax.annotation.Nullable
  public Double getRate() {
    return rate;
  }

  public GetConversionRateResponse setTrackedSearchCount(Integer trackedSearchCount) {
    this.trackedSearchCount = trackedSearchCount;
    return this;
  }

  /**
   * Number of tracked searches. Tracked searches are search requests where the `clickAnalytics`
   * parameter is true.
   */
  @javax.annotation.Nonnull
  public Integer getTrackedSearchCount() {
    return trackedSearchCount;
  }

  public GetConversionRateResponse setConversionCount(Integer conversionCount) {
    this.conversionCount = conversionCount;
    return this;
  }

  /** Number of conversions from this search. minimum: 0 */
  @javax.annotation.Nonnull
  public Integer getConversionCount() {
    return conversionCount;
  }

  public GetConversionRateResponse setDates(List<DailyConversionRates> dates) {
    this.dates = dates;
    return this;
  }

  public GetConversionRateResponse addDates(DailyConversionRates datesItem) {
    this.dates.add(datesItem);
    return this;
  }

  /** Daily conversion rates. */
  @javax.annotation.Nonnull
  public List<DailyConversionRates> getDates() {
    return dates;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetConversionRateResponse getConversionRateResponse = (GetConversionRateResponse) o;
    return (
      Objects.equals(this.rate, getConversionRateResponse.rate) &&
      Objects.equals(this.trackedSearchCount, getConversionRateResponse.trackedSearchCount) &&
      Objects.equals(this.conversionCount, getConversionRateResponse.conversionCount) &&
      Objects.equals(this.dates, getConversionRateResponse.dates)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate, trackedSearchCount, conversionCount, dates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetConversionRateResponse {\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    trackedSearchCount: ").append(toIndentedString(trackedSearchCount)).append("\n");
    sb.append("    conversionCount: ").append(toIndentedString(conversionCount)).append("\n");
    sb.append("    dates: ").append(toIndentedString(dates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
