// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** SecuredAPIKeyRestrictions */
public class SecuredAPIKeyRestrictions {

  @JsonProperty("searchParams")
  private SearchParamsObject searchParams;

  @JsonProperty("filters")
  private String filters;

  @JsonProperty("validUntil")
  private Long validUntil;

  @JsonProperty("restrictIndices")
  private List<String> restrictIndices;

  @JsonProperty("restrictSources")
  private String restrictSources;

  @JsonProperty("userToken")
  private String userToken;

  public SecuredAPIKeyRestrictions setSearchParams(SearchParamsObject searchParams) {
    this.searchParams = searchParams;
    return this;
  }

  /** Get searchParams */
  @javax.annotation.Nullable
  public SearchParamsObject getSearchParams() {
    return searchParams;
  }

  public SecuredAPIKeyRestrictions setFilters(String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * Filters that apply to every search made with the secured API key. Extra filters added at search
   * time will be combined with `AND`. For example, if you set `group:admin` as fixed filter on your
   * generated API key, and add `groups:visitors` to the search query, the complete set of filters
   * will be `group:admin AND groups:visitors`.
   */
  @javax.annotation.Nullable
  public String getFilters() {
    return filters;
  }

  public SecuredAPIKeyRestrictions setValidUntil(Long validUntil) {
    this.validUntil = validUntil;
    return this;
  }

  /**
   * Timestamp in [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time) when the API key should
   * expire.
   */
  @javax.annotation.Nullable
  public Long getValidUntil() {
    return validUntil;
  }

  public SecuredAPIKeyRestrictions setRestrictIndices(List<String> restrictIndices) {
    this.restrictIndices = restrictIndices;
    return this;
  }

  public SecuredAPIKeyRestrictions addRestrictIndices(String restrictIndicesItem) {
    if (this.restrictIndices == null) {
      this.restrictIndices = new ArrayList<>();
    }
    this.restrictIndices.add(restrictIndicesItem);
    return this;
  }

  /**
   * Index names or patterns that this API key can access. By default, an API key can access all
   * indices in the same application. You can use leading and trailing wildcard characters (`*`): -
   * `dev_*` matches all indices starting with \"dev_\". - `*_dev` matches all indices ending with
   * \"_dev\". - `*_products_*` matches all indices containing \"_products_\".
   */
  @javax.annotation.Nullable
  public List<String> getRestrictIndices() {
    return restrictIndices;
  }

  public SecuredAPIKeyRestrictions setRestrictSources(String restrictSources) {
    this.restrictSources = restrictSources;
    return this;
  }

  /**
   * IP network that are allowed to use this key. You can only add a single source, but you can
   * provide a range of IP addresses. Use this to protect against API key leaking and reuse.
   */
  @javax.annotation.Nullable
  public String getRestrictSources() {
    return restrictSources;
  }

  public SecuredAPIKeyRestrictions setUserToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

  /**
   * Pseudonymous user identifier to restrict usage of this API key to specific users. By default,
   * rate limits are set based on IP addresses. This can be an issue if many users search from the
   * same IP address. To avoid this, add a user token to each generated API key.
   */
  @javax.annotation.Nullable
  public String getUserToken() {
    return userToken;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecuredAPIKeyRestrictions securedAPIKeyRestrictions = (SecuredAPIKeyRestrictions) o;
    return (
      Objects.equals(this.searchParams, securedAPIKeyRestrictions.searchParams) &&
      Objects.equals(this.filters, securedAPIKeyRestrictions.filters) &&
      Objects.equals(this.validUntil, securedAPIKeyRestrictions.validUntil) &&
      Objects.equals(this.restrictIndices, securedAPIKeyRestrictions.restrictIndices) &&
      Objects.equals(this.restrictSources, securedAPIKeyRestrictions.restrictSources) &&
      Objects.equals(this.userToken, securedAPIKeyRestrictions.userToken)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchParams, filters, validUntil, restrictIndices, restrictSources, userToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecuredAPIKeyRestrictions {\n");
    sb.append("    searchParams: ").append(toIndentedString(searchParams)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    validUntil: ").append(toIndentedString(validUntil)).append("\n");
    sb.append("    restrictIndices: ").append(toIndentedString(restrictIndices)).append("\n");
    sb.append("    restrictSources: ").append(toIndentedString(restrictSources)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
