/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class JsonSerializer {
    private final ObjectMapper mapper;

    public static Builder builder() {
        return new Builder();
    }

    JsonSerializer(@Nonnull ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void serialize(OutputStream stream, @Nonnull Object object) {
        try {
            this.mapper.writeValue(stream, object);
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException(e);
        }
    }

    public <T> T deserialize(InputStream stream, JavaType returnType) {
        try {
            return (T)this.mapper.readValue(stream, returnType);
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException(e);
        }
    }

    public JavaType getJavaType(Class<?> returnType, @Nonnull Class<?> innerType) {
        if (returnType == null) {
            return null;
        }
        return this.mapper.getTypeFactory().constructParametricType(returnType, new Class[]{innerType});
    }

    public JavaType getJavaType(TypeReference<?> returnType) {
        if (returnType == null) {
            return null;
        }
        return this.mapper.getTypeFactory().constructType(returnType);
    }

    public static class Builder {
        private Consumer<JsonMapper.Builder> customerConfig;

        public Builder setCustomConfig(Consumer<JsonMapper.Builder> config) {
            this.customerConfig = config;
            return this;
        }

        public JsonSerializer build() {
            JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS})).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT})).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_INVALID_SUBTYPE})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS})).disable(new DeserializationFeature[]{DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).serializationInclusion(JsonInclude.Include.NON_NULL);
            if (this.customerConfig != null) {
                this.customerConfig.accept(builder);
            }
            JsonMapper build = (JsonMapper)builder.build();
            return new JsonSerializer((ObjectMapper)build);
        }
    }
}

