/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal.interceptors;

import com.algolia.config.CallType;
import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaClientException;
import com.algolia.exceptions.AlgoliaRequestException;
import com.algolia.exceptions.AlgoliaRetryException;
import com.algolia.internal.StatefulHost;
import com.algolia.utils.DateTimeUtils;
import com.algolia.utils.UseReadTransporter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class RetryStrategy
implements Interceptor {
    private static final long EXPIRATION_THRESHOLD_SECONDS = 300L;
    private final List<StatefulHost> hosts;

    public RetryStrategy(List<StatefulHost> hosts) {
        this.hosts = Collections.unmodifiableList(hosts);
    }

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) {
        Request request = chain.request();
        UseReadTransporter useReadTransporter = (UseReadTransporter)request.tag();
        CallType callType = useReadTransporter != null || request.method().equals("GET") ? CallType.READ : CallType.WRITE;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (StatefulHost currentHost : this.callableHosts(callType)) {
            try {
                return this.processRequest(chain, request, currentHost);
            }
            catch (Exception e) {
                errors.add(e);
                this.handleException(currentHost, e);
            }
        }
        throw new AlgoliaRetryException(errors);
    }

    @Nonnull
    private Response processRequest(@Nonnull Interceptor.Chain chain, @Nonnull Request request, StatefulHost host) throws IOException {
        HttpUrl.Builder urlBuilder = request.url().newBuilder().scheme(host.getScheme()).host(host.getHost());
        if (host.getPort() != -1) {
            urlBuilder.port(host.getPort());
        }
        HttpUrl newUrl = urlBuilder.build();
        Request newRequest = request.newBuilder().url(newUrl).build();
        chain.withConnectTimeout(chain.connectTimeoutMillis() * (host.getRetryCount() + 1), TimeUnit.MILLISECONDS);
        Response response = chain.proceed(newRequest);
        return this.handleResponse(host, response);
    }

    @Nonnull
    private Response handleResponse(StatefulHost host, @Nonnull Response response) throws IOException {
        if (response.isSuccessful()) {
            host.reset();
            return response;
        }
        try {
            String message = response.body() != null ? response.body().string() : response.message();
            throw this.isRetryable(response) ? new AlgoliaRequestException(message, response.code()) : new AlgoliaApiException(message, response.code());
        }
        catch (Throwable throwable) {
            response.close();
            throw throwable;
        }
    }

    private boolean isRetryable(@Nonnull Response response) {
        int statusCode = response.code();
        return !(statusCode >= 200 && statusCode < 300 || statusCode >= 400 && statusCode < 500);
    }

    private void handleException(StatefulHost host, Exception exception) {
        if (exception instanceof SocketTimeoutException) {
            host.hasTimedOut();
        } else if (exception instanceof AlgoliaRequestException || exception instanceof IOException) {
            host.hasFailed();
        } else {
            if (exception instanceof AlgoliaApiException) {
                throw (AlgoliaApiException)exception;
            }
            throw new AlgoliaClientException(exception);
        }
    }

    private synchronized List<StatefulHost> callableHosts(CallType callType) {
        this.resetExpiredHosts();
        List<StatefulHost> hostsCallType = this.hosts.stream().filter(h -> h.getAccept().contains((Object)callType)).collect(Collectors.toList());
        List<StatefulHost> hostsCallTypeAreUp = hostsCallType.stream().filter(StatefulHost::isUp).collect(Collectors.toList());
        if (hostsCallTypeAreUp.isEmpty()) {
            hostsCallType.forEach(StatefulHost::reset);
            return hostsCallType;
        }
        return hostsCallTypeAreUp;
    }

    private void resetExpiredHosts() {
        OffsetDateTime now = DateTimeUtils.nowUTC();
        for (StatefulHost host : this.hosts) {
            long lastUse = Duration.between(host.getLastUse(), now).getSeconds();
            if (host.isUp() || lastUse <= 300L) continue;
            host.reset();
        }
    }
}

