/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.analytics.Direction;
import com.algolia.model.analytics.GetAddToCartRateResponse;
import com.algolia.model.analytics.GetAverageClickPositionResponse;
import com.algolia.model.analytics.GetClickPositionsResponse;
import com.algolia.model.analytics.GetClickThroughRateResponse;
import com.algolia.model.analytics.GetConversionRateResponse;
import com.algolia.model.analytics.GetNoClickRateResponse;
import com.algolia.model.analytics.GetNoResultsRateResponse;
import com.algolia.model.analytics.GetPurchaseRateResponse;
import com.algolia.model.analytics.GetRevenue;
import com.algolia.model.analytics.GetSearchesCountResponse;
import com.algolia.model.analytics.GetSearchesNoClicksResponse;
import com.algolia.model.analytics.GetSearchesNoResultsResponse;
import com.algolia.model.analytics.GetStatusResponse;
import com.algolia.model.analytics.GetTopCountriesResponse;
import com.algolia.model.analytics.GetTopFilterAttributesResponse;
import com.algolia.model.analytics.GetTopFilterForAttributeResponse;
import com.algolia.model.analytics.GetTopFiltersNoResultsResponse;
import com.algolia.model.analytics.GetTopHitsResponse;
import com.algolia.model.analytics.GetTopSearchesResponse;
import com.algolia.model.analytics.GetUsersCountResponse;
import com.algolia.model.analytics.OrderBy;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AnalyticsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"de", "us"};

    public AnalyticsClient(String appId, String apiKey) {
        this(appId, apiKey, null, null);
    }

    public AnalyticsClient(String appId, String apiKey, ClientOptions options) {
        this(appId, apiKey, null, options);
    }

    public AnalyticsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public AnalyticsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Analytics", options, AnalyticsClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        boolean found;
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean bl = found = region == null;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
        }
        String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAddToCartRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAddToCartRate(index, startDate, endDate, tags, null);
    }

    public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAddToCartRate(index, null, null, null, requestOptions);
    }

    public GetAddToCartRateResponse getAddToCartRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getAddToCartRate(index, null, null, null, null);
    }

    public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getAddToCartRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/conversions/addToCartRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetAddToCartRateResponse>(){});
    }

    public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAddToCartRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAddToCartRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetAddToCartRateResponse> getAddToCartRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getAddToCartRateAsync(index, null, null, null, null);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAverageClickPositionAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, startDate, endDate, tags, null);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, null, null, null, requestOptions);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, null, null, null, null);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getAverageClickPosition`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/clicks/averageClickPosition").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetAverageClickPositionResponse>(){});
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, null, null, null, null);
    }

    public GetClickPositionsResponse getClickPositions(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClickPositionsAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetClickPositionsResponse getClickPositions(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, startDate, endDate, tags, null);
    }

    public GetClickPositionsResponse getClickPositions(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, null, null, null, requestOptions);
    }

    public GetClickPositionsResponse getClickPositions(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, null, null, null, null);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickPositions`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/clicks/positions").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetClickPositionsResponse>(){});
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, null, null, null, null);
    }

    public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClickThroughRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, startDate, endDate, tags, null);
    }

    public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, null, null, null, requestOptions);
    }

    public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, null, null, null, null);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickThroughRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/clicks/clickThroughRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetClickThroughRateResponse>(){});
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, null, null, null, null);
    }

    public GetConversionRateResponse getConversionRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConversionRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetConversionRateResponse getConversionRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getConversionRate(index, startDate, endDate, tags, null);
    }

    public GetConversionRateResponse getConversionRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getConversionRate(index, null, null, null, requestOptions);
    }

    public GetConversionRateResponse getConversionRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getConversionRate(index, null, null, null, null);
    }

    public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getConversionRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/conversions/conversionRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetConversionRateResponse>(){});
    }

    public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getConversionRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getConversionRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetConversionRateResponse> getConversionRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getConversionRateAsync(index, null, null, null, null);
    }

    public GetNoClickRateResponse getNoClickRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getNoClickRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetNoClickRateResponse getNoClickRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, startDate, endDate, tags, null);
    }

    public GetNoClickRateResponse getNoClickRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, null, null, null, requestOptions);
    }

    public GetNoClickRateResponse getNoClickRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, null, null, null, null);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoClickRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches/noClickRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetNoClickRateResponse>(){});
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, null, null, null, null);
    }

    public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getNoResultsRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, startDate, endDate, tags, null);
    }

    public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, null, null, null, requestOptions);
    }

    public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, null, null, null, null);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoResultsRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches/noResultRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetNoResultsRateResponse>(){});
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, null, null, null, null);
    }

    public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getPurchaseRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getPurchaseRate(index, startDate, endDate, tags, null);
    }

    public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getPurchaseRate(index, null, null, null, requestOptions);
    }

    public GetPurchaseRateResponse getPurchaseRate(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getPurchaseRate(index, null, null, null, null);
    }

    public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getPurchaseRate`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/conversions/purchaseRate").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetPurchaseRateResponse>(){});
    }

    public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getPurchaseRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getPurchaseRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetPurchaseRateResponse> getPurchaseRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getPurchaseRateAsync(index, null, null, null, null);
    }

    public GetRevenue getRevenue(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRevenueAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetRevenue getRevenue(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getRevenue(index, startDate, endDate, tags, null);
    }

    public GetRevenue getRevenue(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getRevenue(index, null, null, null, requestOptions);
    }

    public GetRevenue getRevenue(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getRevenue(index, null, null, null, null);
    }

    public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getRevenue`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/conversions/revenue").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetRevenue>(){});
    }

    public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getRevenueAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getRevenueAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetRevenue> getRevenueAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getRevenueAsync(index, null, null, null, null);
    }

    public GetSearchesCountResponse getSearchesCount(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesCountAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetSearchesCountResponse getSearchesCount(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, startDate, endDate, tags, null);
    }

    public GetSearchesCountResponse getSearchesCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, null, null, null, requestOptions);
    }

    public GetSearchesCountResponse getSearchesCount(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, null, null, null, null);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesCount`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches/count").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetSearchesCountResponse>(){});
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, null, null, null, null);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, null, null, null, null, null, requestOptions);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoClicks`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches/noClicks").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetSearchesNoClicksResponse>(){});
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, null, null, null, null, null, null);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, null, null, null, null, null, requestOptions);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoResults`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches/noResults").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetSearchesNoResultsResponse>(){});
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, null, null, null, null, null, null);
    }

    public GetStatusResponse getStatus(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getStatusAsync(index, requestOptions));
    }

    public GetStatusResponse getStatus(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getStatus(index, null);
    }

    public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/status").setMethod("GET").addQueryParameter("index", index).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetStatusResponse>(){});
    }

    public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getStatusAsync(index, null);
    }

    public GetTopCountriesResponse getTopCountries(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopCountriesResponse getTopCountries(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopCountriesResponse getTopCountries(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, null, null, null, null, null, requestOptions);
    }

    public GetTopCountriesResponse getTopCountries(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopCountries`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/countries").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopCountriesResponse>(){});
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, null, null, null, null, null, null);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterAttributes`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/filters").setMethod("GET").addQueryParameter("index", index).addQueryParameter("search", search).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopFilterAttributesResponse>(){});
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, null);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(@Nonnull String attribute, @Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(attribute, "Parameter `attribute` is required when calling `getTopFilterForAttribute`.");
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterForAttribute`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/filters/{attribute}", attribute).setMethod("GET").addQueryParameter("index", index).addQueryParameter("search", search).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopFilterForAttributeResponse>(){});
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(@Nonnull String attribute, @Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(@Nonnull String attribute, @Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(@Nonnull String attribute, @Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, null);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFiltersNoResults`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/filters/noResults").setMethod("GET").addQueryParameter("index", index).addQueryParameter("search", search).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopFiltersNoResultsResponse>(){});
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, null);
    }

    public GetTopHitsResponse getTopHits(@Nonnull String index, String search, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopHitsAsync(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopHitsResponse getTopHits(@Nonnull String index, String search, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopHits(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopHitsResponse getTopHits(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopHits(index, null, null, null, null, null, null, null, null, requestOptions);
    }

    public GetTopHitsResponse getTopHits(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopHits(index, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index, String search, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopHits`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/hits").setMethod("GET").addQueryParameter("index", index).addQueryParameter("search", search).addQueryParameter("clickAnalytics", clickAnalytics).addQueryParameter("revenueAnalytics", revenueAnalytics).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopHitsResponse>(){});
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index, String search, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, search, clickAnalytics, revenueAnalytics, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null, null);
    }

    public GetTopSearchesResponse getTopSearches(@Nonnull String index, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopSearchesAsync(index, clickAnalytics, revenueAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, requestOptions));
    }

    public GetTopSearchesResponse getTopSearches(@Nonnull String index, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, clickAnalytics, revenueAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
    }

    public GetTopSearchesResponse getTopSearches(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public GetTopSearchesResponse getTopSearches(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, null, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopSearches`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/searches").setMethod("GET").addQueryParameter("index", index).addQueryParameter("clickAnalytics", clickAnalytics).addQueryParameter("revenueAnalytics", revenueAnalytics).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("orderBy", (Object)orderBy).addQueryParameter("direction", (Object)direction).addQueryParameter("limit", limit).addQueryParameter("offset", offset).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopSearchesResponse>(){});
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index, Boolean clickAnalytics, Boolean revenueAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, clickAnalytics, revenueAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null, null);
    }

    public GetUsersCountResponse getUsersCount(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUsersCountAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetUsersCountResponse getUsersCount(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, startDate, endDate, tags, null);
    }

    public GetUsersCountResponse getUsersCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, null, null, null, requestOptions);
    }

    public GetUsersCountResponse getUsersCount(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, null, null, null, null);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(index, "Parameter `index` is required when calling `getUsersCount`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/users/count").setMethod("GET").addQueryParameter("index", index).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("tags", tags).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetUsersCountResponse>(){});
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, null, null, null, null);
    }
}

