/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal.interceptors;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public final class GzipRequestInterceptor
implements Interceptor {
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(originalRequest.body())).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody gzip(final RequestBody body) {
        return new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@Nonnull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

