/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal.interceptors;

import com.algolia.config.LogLevel;
import com.algolia.config.Logger;
import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public final class LogInterceptor
implements Interceptor {
    private final HttpLoggingInterceptor logger;

    public LogInterceptor(Logger logger, LogLevel logLevel) {
        HttpLoggingInterceptor.Logger logr = logger != null ? this.toLogger(logger) : HttpLoggingInterceptor.Logger.DEFAULT;
        HttpLoggingInterceptor.Level level = this.toLevel(logLevel);
        this.logger = new HttpLoggingInterceptor(logr).setLevel(level);
    }

    public HttpLoggingInterceptor.Logger toLogger(@Nonnull Logger logger) {
        return logger::log;
    }

    public HttpLoggingInterceptor.Level toLevel(@Nonnull LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                return HttpLoggingInterceptor.Level.NONE;
            }
            case BODY: {
                return HttpLoggingInterceptor.Level.BODY;
            }
            case BASIC: {
                return HttpLoggingInterceptor.Level.BASIC;
            }
            case HEADERS: {
                return HttpLoggingInterceptor.Level.HEADERS;
            }
        }
        throw new UnsupportedOperationException("Unsupported LogLevel " + (Object)((Object)logLevel));
    }

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        return this.logger.intercept(chain);
    }
}

