/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.ConsequenceQueryObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface ConsequenceQuery {
    public static ConsequenceQuery of(String value) {
        return new StringWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class StringWrapper
    implements ConsequenceQuery {
        private final String value;

        StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<StringWrapper> {
            Serializer() {
            }

            public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<ConsequenceQuery> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public ConsequenceQuery deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject()) {
                ConsequenceQuery consequenceQuery;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        consequenceQuery = (ConsequenceQuery)parser.readValueAs(ConsequenceQueryObject.class);
                        if (parser == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf ConsequenceQueryObject (error: " + e.getMessage() + ") (type: ConsequenceQueryObject)");
                        }
                    }
                    parser.close();
                }
                return consequenceQuery;
            }
            if (tree.isTextual()) {
                StringWrapper stringWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs(String.class);
                        stringWrapper = new StringWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return stringWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public ConsequenceQuery getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "ConsequenceQuery cannot be null");
        }
    }
}

