// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.*;
import com.algolia.model.recommend.*;
import com.algolia.utils.*;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;

public class RecommendClient extends ApiClient {

  public RecommendClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public RecommendClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Recommend", "4.0.0-beta.3", options);
    if (options != null && options.getHosts() != null) {
      this.setHosts(options.getHosts());
    } else {
      this.setHosts(getDefaultHosts(appId));
    }
    this.setConnectTimeout(2000);
    this.setReadTimeout(5000);
    this.setWriteTimeout(30000);
  }

  private static List<StatefulHost> getDefaultHosts(String appId) {
    List<StatefulHost> hosts = new ArrayList<StatefulHost>();
    hosts.add(new StatefulHost(appId + "-dsn.algolia.net", "https", EnumSet.of(CallType.READ)));
    hosts.add(new StatefulHost(appId + ".algolia.net", "https", EnumSet.of(CallType.WRITE)));

    List<StatefulHost> commonHosts = new ArrayList<StatefulHost>();
    hosts.add(new StatefulHost(appId + "-1.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new StatefulHost(appId + "-2.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new StatefulHost(appId + "-3.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(delAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.del(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.del(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path) throws AlgoliaRuntimeException {
    return this.del(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
    }

    Object bodyObj = null;

    // create path and map variables
    String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    if (parameters != null) {
      for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
        queryParameters.put(parameter.getKey().toString(), parameterToString(parameter.getValue()));
      }
    }

    Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.delAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, null);
  }

  /**
   * Delete a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return DeletedAtResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Delete a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @return DeletedAtResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
    return this.deleteRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Delete a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<DeletedAtResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(
    String indexName,
    RecommendModels model,
    String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    if (indexName == null) {
      throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteRecommendRule`.");
    }

    if (model == null) {
      throw new AlgoliaRuntimeException("Parameter `model` is required when calling `deleteRecommendRule`.");
    }

    if (objectID == null) {
      throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `deleteRecommendRule`.");
    }

    Object bodyObj = null;

    // create path and map variables
    String requestPath =
      "/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()))
        .replaceAll("\\{model\\}", this.escapeString(model.toString()))
        .replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @return CompletableFuture<DeletedAtResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(String indexName, RecommendModels model, String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.get(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.get(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path) throws AlgoliaRuntimeException {
    return this.get(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
    }

    Object bodyObj = null;

    // create path and map variables
    String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    if (parameters != null) {
      for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
        queryParameters.put(parameter.getKey().toString(), parameterToString(parameter.getValue()));
      }
    }

    Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.getAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, null);
  }

  /**
   * Return a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return RuleResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RuleResponse getRecommendRule(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Return a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @return RuleResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RuleResponse getRecommendRule(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
    return this.getRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Return a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<RuleResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RuleResponse> getRecommendRuleAsync(
    String indexName,
    RecommendModels model,
    String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    if (indexName == null) {
      throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getRecommendRule`.");
    }

    if (model == null) {
      throw new AlgoliaRuntimeException("Parameter `model` is required when calling `getRecommendRule`.");
    }

    if (objectID == null) {
      throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `getRecommendRule`.");
    }

    Object bodyObj = null;

    // create path and map variables
    String requestPath =
      "/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()))
        .replaceAll("\\{model\\}", this.escapeString(model.toString()))
        .replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<RuleResponse>() {});
  }

  /**
   * (asynchronously) Return a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @return CompletableFuture<RuleResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RuleResponse> getRecommendRuleAsync(String indexName, RecommendModels model, String objectID)
    throws AlgoliaRuntimeException {
    return this.getRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * Some operations, such as deleting a Recommend rule, will respond with a `taskID` value. Use
   * this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return GetRecommendTaskResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(String indexName, RecommendModels model, Long taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendStatusAsync(indexName, model, taskID, requestOptions));
  }

  /**
   * Some operations, such as deleting a Recommend rule, will respond with a `taskID` value. Use
   * this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @return GetRecommendTaskResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(String indexName, RecommendModels model, Long taskID) throws AlgoliaRuntimeException {
    return this.getRecommendStatus(indexName, model, taskID, null);
  }

  /**
   * (asynchronously) Some operations, such as deleting a Recommend rule, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<GetRecommendTaskResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(
    String indexName,
    RecommendModels model,
    Long taskID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    if (indexName == null) {
      throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getRecommendStatus`.");
    }

    if (model == null) {
      throw new AlgoliaRuntimeException("Parameter `model` is required when calling `getRecommendStatus`.");
    }

    if (taskID == null) {
      throw new AlgoliaRuntimeException("Parameter `taskID` is required when calling `getRecommendStatus`.");
    }

    Object bodyObj = null;

    // create path and map variables
    String requestPath =
      "/1/indexes/{indexName}/{model}/task/{taskID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()))
        .replaceAll("\\{model\\}", this.escapeString(model.toString()))
        .replaceAll("\\{taskID\\}", this.escapeString(taskID.toString()));

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<GetRecommendTaskResponse>() {});
  }

  /**
   * (asynchronously) Some operations, such as deleting a Recommend rule, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @return CompletableFuture<GetRecommendTaskResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(String indexName, RecommendModels model, Long taskID)
    throws AlgoliaRuntimeException {
    return this.getRecommendStatusAsync(indexName, model, taskID, null);
  }

  /**
   * Returns results from either recommendation or trending models: - **Recommendations** are
   * provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return GetRecommendationsResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendationsAsync(getRecommendationsParams, requestOptions));
  }

  /**
   * Returns results from either recommendation or trending models: - **Recommendations** are
   * provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @return GetRecommendationsResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
    return this.getRecommendations(getRecommendationsParams, null);
  }

  /**
   * (asynchronously) Returns results from either recommendation or trending models: -
   * **Recommendations** are provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<GetRecommendationsResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(
    GetRecommendationsParams getRecommendationsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    if (getRecommendationsParams == null) {
      throw new AlgoliaRuntimeException("Parameter `getRecommendationsParams` is required when calling `getRecommendations`.");
    }

    Object bodyObj = getRecommendationsParams;

    // create path and map variables
    String requestPath = "/1/indexes/*/recommendations";

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
    return this.executeAsync(call, new TypeReference<GetRecommendationsResponse>() {});
  }

  /**
   * (asynchronously) Returns results from either recommendation or trending models: -
   * **Recommendations** are provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @return CompletableFuture<GetRecommendationsResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(GetRecommendationsParams getRecommendationsParams)
    throws AlgoliaRuntimeException {
    return this.getRecommendationsAsync(getRecommendationsParams, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(postAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.post(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.post(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path) throws AlgoliaRuntimeException {
    return this.post(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
    }

    Object bodyObj = body != null ? body : new Object();

    // create path and map variables
    String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    if (parameters != null) {
      for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
        queryParameters.put(parameter.getKey().toString(), parameterToString(parameter.getValue()));
      }
    }

    Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.postAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(putAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.put(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.put(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return Object
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path) throws AlgoliaRuntimeException {
    return this.put(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
    }

    Object bodyObj = body != null ? body : new Object();

    // create path and map variables
    String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    if (parameters != null) {
      for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
        queryParameters.put(parameter.getKey().toString(), parameterToString(parameter.getValue()));
      }
    }

    Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
    return this.executeAsync(call, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.putAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @return CompletableFuture<Object> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, null);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return SearchRecommendRulesResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    String indexName,
    RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @return SearchRecommendRulesResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    String indexName,
    RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return SearchRecommendRulesResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, requestOptions);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @return SearchRecommendRulesResponse
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, null);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<SearchRecommendRulesResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    String indexName,
    RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    if (indexName == null) {
      throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchRecommendRules`.");
    }

    if (model == null) {
      throw new AlgoliaRuntimeException("Parameter `model` is required when calling `searchRecommendRules`.");
    }

    Object bodyObj = searchRecommendRulesParams != null ? searchRecommendRulesParams : new Object();

    // create path and map variables
    String requestPath =
      "/1/indexes/{indexName}/{model}/recommend/rules/search".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()))
        .replaceAll("\\{model\\}", this.escapeString(model.toString()));

    Map<String, Object> queryParameters = new HashMap<String, Object>();
    Map<String, String> headers = new HashMap<String, String>();

    Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
    return this.executeAsync(call, new TypeReference<SearchRecommendRulesResponse>() {});
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @return CompletableFuture<SearchRecommendRulesResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    String indexName,
    RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @return CompletableFuture<SearchRecommendRulesResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    String indexName,
    RecommendModels model,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @return CompletableFuture<SearchRecommendRulesResponse> The awaitable future
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(String indexName, RecommendModels model)
    throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, null);
  }
}
