// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.abtesting;

import com.fasterxml.jackson.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ABTest */
public class ABTest {

  @JsonProperty("abTestID")
  private Integer abTestID;

  @JsonProperty("clickSignificance")
  private Double clickSignificance;

  @JsonProperty("conversionSignificance")
  private String conversionSignificance;

  @JsonProperty("updatedAt")
  private String updatedAt;

  @JsonProperty("createdAt")
  private String createdAt;

  @JsonProperty("name")
  private String name;

  @JsonProperty("status")
  private String status;

  @JsonProperty("variants")
  private List<Variant> variants = new ArrayList<>();

  public ABTest setAbTestID(Integer abTestID) {
    this.abTestID = abTestID;
    return this;
  }

  /**
   * Unique A/B test ID.
   *
   * @return abTestID
   */
  @javax.annotation.Nonnull
  public Integer getAbTestID() {
    return abTestID;
  }

  public ABTest setClickSignificance(Double clickSignificance) {
    this.clickSignificance = clickSignificance;
    return this;
  }

  /**
   * [A/B test
   * significance](https://www.algolia.com/doc/guides/ab-testing/what-is-ab-testing/in-depth/how-ab-test-scores-are-calculated/#statistical-significance-or-chance)
   * based on click data. A value of 0.95 or over is considered to be _significant_.
   *
   * @return clickSignificance
   */
  @javax.annotation.Nonnull
  public Double getClickSignificance() {
    return clickSignificance;
  }

  public ABTest setConversionSignificance(String conversionSignificance) {
    this.conversionSignificance = conversionSignificance;
    return this;
  }

  /**
   * End date timestamp in [ISO-8601](https://wikipedia.org/wiki/ISO_8601) format.
   *
   * @return conversionSignificance
   */
  @javax.annotation.Nonnull
  public String getConversionSignificance() {
    return conversionSignificance;
  }

  public ABTest setUpdatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Update date timestamp in [ISO-8601](https://wikipedia.org/wiki/ISO_8601) format.
   *
   * @return updatedAt
   */
  @javax.annotation.Nonnull
  public String getUpdatedAt() {
    return updatedAt;
  }

  public ABTest setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Creation date timestamp in [ISO-8601](https://wikipedia.org/wiki/ISO_8601) format.
   *
   * @return createdAt
   */
  @javax.annotation.Nonnull
  public String getCreatedAt() {
    return createdAt;
  }

  public ABTest setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * A/B test name.
   *
   * @return name
   */
  @javax.annotation.Nonnull
  public String getName() {
    return name;
  }

  public ABTest setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * A/B test status.
   *
   * @return status
   */
  @javax.annotation.Nonnull
  public String getStatus() {
    return status;
  }

  public ABTest setVariants(List<Variant> variants) {
    this.variants = variants;
    return this;
  }

  public ABTest addVariants(Variant variantsItem) {
    this.variants.add(variantsItem);
    return this;
  }

  /**
   * A/B test variants.
   *
   * @return variants
   */
  @javax.annotation.Nonnull
  public List<Variant> getVariants() {
    return variants;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ABTest abTest = (ABTest) o;
    return (
      Objects.equals(this.abTestID, abTest.abTestID) &&
      Objects.equals(this.clickSignificance, abTest.clickSignificance) &&
      Objects.equals(this.conversionSignificance, abTest.conversionSignificance) &&
      Objects.equals(this.updatedAt, abTest.updatedAt) &&
      Objects.equals(this.createdAt, abTest.createdAt) &&
      Objects.equals(this.name, abTest.name) &&
      Objects.equals(this.status, abTest.status) &&
      Objects.equals(this.variants, abTest.variants)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(abTestID, clickSignificance, conversionSignificance, updatedAt, createdAt, name, status, variants);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ABTest {\n");
    sb.append("    abTestID: ").append(toIndentedString(abTestID)).append("\n");
    sb.append("    clickSignificance: ").append(toIndentedString(clickSignificance)).append("\n");
    sb.append("    conversionSignificance: ").append(toIndentedString(conversionSignificance)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    variants: ").append(toIndentedString(variants)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
