// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.querysuggestions;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Set the language for deduplicating singular and plural suggestions. If specified, only the more
 * popular form is included.
 */
@JsonDeserialize(using = Languages.LanguagesDeserializer.class)
@JsonSerialize(using = Languages.LanguagesSerializer.class)
public abstract class Languages implements CompoundType {

  private static final Logger LOGGER = Logger.getLogger(Languages.class.getName());

  public static Languages of(Boolean inside) {
    return new LanguagesBoolean(inside);
  }

  public static Languages of(List<String> inside) {
    return new LanguagesListOfString(inside);
  }

  public static class LanguagesSerializer extends StdSerializer<Languages> {

    public LanguagesSerializer(Class<Languages> t) {
      super(t);
    }

    public LanguagesSerializer() {
      this(null);
    }

    @Override
    public void serialize(Languages value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
      jgen.writeObject(value.getInsideValue());
    }
  }

  public static class LanguagesDeserializer extends StdDeserializer<Languages> {

    public LanguagesDeserializer() {
      this(Languages.class);
    }

    public LanguagesDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public Languages deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return Languages.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize List<String>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<String> value = parser.readValueAs(new TypeReference<List<String>>() {});
          return Languages.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public Languages getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "Languages cannot be null");
    }
  }
}

class LanguagesBoolean extends Languages {

  private final Boolean insideValue;

  LanguagesBoolean(Boolean insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Boolean getInsideValue() {
    return insideValue;
  }
}

class LanguagesListOfString extends Languages {

  private final List<String> insideValue;

  LanguagesListOfString(List<String> insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public List<String> getInsideValue() {
    return insideValue;
  }
}
