// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.querysuggestions;

import com.fasterxml.jackson.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** QuerySuggestionsConfigurationResponse */
public class QuerySuggestionsConfigurationResponse {

  @JsonProperty("appId")
  private String appId;

  @JsonProperty("sourceIndicesAPIKey")
  private String sourceIndicesAPIKey;

  @JsonProperty("suggestionsIndicesAPIKey")
  private String suggestionsIndicesAPIKey;

  @JsonProperty("externalIndicesAPIKey")
  private String externalIndicesAPIKey;

  @JsonProperty("indexName")
  private String indexName;

  @JsonProperty("sourceIndices")
  private List<SourceIndex> sourceIndices = new ArrayList<>();

  @JsonProperty("languages")
  private Languages languages;

  @JsonProperty("exclude")
  private List<String> exclude;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("allowSpecialCharacters")
  private Boolean allowSpecialCharacters;

  public QuerySuggestionsConfigurationResponse setAppId(String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * Your Algolia application ID.
   *
   * @return appId
   */
  @javax.annotation.Nullable
  public String getAppId() {
    return appId;
  }

  public QuerySuggestionsConfigurationResponse setSourceIndicesAPIKey(String sourceIndicesAPIKey) {
    this.sourceIndicesAPIKey = sourceIndicesAPIKey;
    return this;
  }

  /**
   * API key used to read from your source index.
   *
   * @return sourceIndicesAPIKey
   */
  @javax.annotation.Nullable
  public String getSourceIndicesAPIKey() {
    return sourceIndicesAPIKey;
  }

  public QuerySuggestionsConfigurationResponse setSuggestionsIndicesAPIKey(String suggestionsIndicesAPIKey) {
    this.suggestionsIndicesAPIKey = suggestionsIndicesAPIKey;
    return this;
  }

  /**
   * API key used to write and configure your Query Suggestions index.
   *
   * @return suggestionsIndicesAPIKey
   */
  @javax.annotation.Nullable
  public String getSuggestionsIndicesAPIKey() {
    return suggestionsIndicesAPIKey;
  }

  public QuerySuggestionsConfigurationResponse setExternalIndicesAPIKey(String externalIndicesAPIKey) {
    this.externalIndicesAPIKey = externalIndicesAPIKey;
    return this;
  }

  /**
   * API key used to read from external Algolia indices.
   *
   * @return externalIndicesAPIKey
   */
  @javax.annotation.Nullable
  public String getExternalIndicesAPIKey() {
    return externalIndicesAPIKey;
  }

  public QuerySuggestionsConfigurationResponse setIndexName(String indexName) {
    this.indexName = indexName;
    return this;
  }

  /**
   * Query Suggestions index name.
   *
   * @return indexName
   */
  @javax.annotation.Nonnull
  public String getIndexName() {
    return indexName;
  }

  public QuerySuggestionsConfigurationResponse setSourceIndices(List<SourceIndex> sourceIndices) {
    this.sourceIndices = sourceIndices;
    return this;
  }

  public QuerySuggestionsConfigurationResponse addSourceIndices(SourceIndex sourceIndicesItem) {
    this.sourceIndices.add(sourceIndicesItem);
    return this;
  }

  /**
   * Algolia indices from which to get the popular searches for query suggestions.
   *
   * @return sourceIndices
   */
  @javax.annotation.Nonnull
  public List<SourceIndex> getSourceIndices() {
    return sourceIndices;
  }

  public QuerySuggestionsConfigurationResponse setLanguages(Languages languages) {
    this.languages = languages;
    return this;
  }

  /**
   * Get languages
   *
   * @return languages
   */
  @javax.annotation.Nullable
  public Languages getLanguages() {
    return languages;
  }

  public QuerySuggestionsConfigurationResponse setExclude(List<String> exclude) {
    this.exclude = exclude;
    return this;
  }

  public QuerySuggestionsConfigurationResponse addExclude(String excludeItem) {
    if (this.exclude == null) {
      this.exclude = new ArrayList<>();
    }
    this.exclude.add(excludeItem);
    return this;
  }

  /**
   * Patterns to exclude from query suggestions.
   *
   * @return exclude
   */
  @javax.annotation.Nullable
  public List<String> getExclude() {
    return exclude;
  }

  public QuerySuggestionsConfigurationResponse setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /**
   * Turn on personalized query suggestions.
   *
   * @return enablePersonalization
   */
  @javax.annotation.Nullable
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public QuerySuggestionsConfigurationResponse setAllowSpecialCharacters(Boolean allowSpecialCharacters) {
    this.allowSpecialCharacters = allowSpecialCharacters;
    return this;
  }

  /**
   * Allow suggestions with special characters.
   *
   * @return allowSpecialCharacters
   */
  @javax.annotation.Nullable
  public Boolean getAllowSpecialCharacters() {
    return allowSpecialCharacters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuerySuggestionsConfigurationResponse querySuggestionsConfigurationResponse = (QuerySuggestionsConfigurationResponse) o;
    return (
      Objects.equals(this.appId, querySuggestionsConfigurationResponse.appId) &&
      Objects.equals(this.sourceIndicesAPIKey, querySuggestionsConfigurationResponse.sourceIndicesAPIKey) &&
      Objects.equals(this.suggestionsIndicesAPIKey, querySuggestionsConfigurationResponse.suggestionsIndicesAPIKey) &&
      Objects.equals(this.externalIndicesAPIKey, querySuggestionsConfigurationResponse.externalIndicesAPIKey) &&
      Objects.equals(this.indexName, querySuggestionsConfigurationResponse.indexName) &&
      Objects.equals(this.sourceIndices, querySuggestionsConfigurationResponse.sourceIndices) &&
      Objects.equals(this.languages, querySuggestionsConfigurationResponse.languages) &&
      Objects.equals(this.exclude, querySuggestionsConfigurationResponse.exclude) &&
      Objects.equals(this.enablePersonalization, querySuggestionsConfigurationResponse.enablePersonalization) &&
      Objects.equals(this.allowSpecialCharacters, querySuggestionsConfigurationResponse.allowSpecialCharacters)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      appId,
      sourceIndicesAPIKey,
      suggestionsIndicesAPIKey,
      externalIndicesAPIKey,
      indexName,
      sourceIndices,
      languages,
      exclude,
      enablePersonalization,
      allowSpecialCharacters
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuerySuggestionsConfigurationResponse {\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    sourceIndicesAPIKey: ").append(toIndentedString(sourceIndicesAPIKey)).append("\n");
    sb.append("    suggestionsIndicesAPIKey: ").append(toIndentedString(suggestionsIndicesAPIKey)).append("\n");
    sb.append("    externalIndicesAPIKey: ").append(toIndentedString(externalIndicesAPIKey)).append("\n");
    sb.append("    indexName: ").append(toIndentedString(indexName)).append("\n");
    sb.append("    sourceIndices: ").append(toIndentedString(sourceIndices)).append("\n");
    sb.append("    languages: ").append(toIndentedString(languages)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    allowSpecialCharacters: ").append(toIndentedString(allowSpecialCharacters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
