// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * Enables [deduplication or grouping of results (Algolia's _distinct_
 * feature](https://www.algolia.com/doc/guides/managing-results/refine-results/grouping/#introducing-algolias-distinct-feature)).
 */
@JsonDeserialize(using = Distinct.DistinctDeserializer.class)
@JsonSerialize(using = Distinct.DistinctSerializer.class)
public abstract class Distinct implements CompoundType {

  private static final Logger LOGGER = Logger.getLogger(Distinct.class.getName());

  public static Distinct of(Boolean inside) {
    return new DistinctBoolean(inside);
  }

  public static Distinct of(Integer inside) {
    return new DistinctInteger(inside);
  }

  public static class DistinctSerializer extends StdSerializer<Distinct> {

    public DistinctSerializer(Class<Distinct> t) {
      super(t);
    }

    public DistinctSerializer() {
      this(null);
    }

    @Override
    public void serialize(Distinct value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
      jgen.writeObject(value.getInsideValue());
    }
  }

  public static class DistinctDeserializer extends StdDeserializer<Distinct> {

    public DistinctDeserializer() {
      this(Distinct.class);
    }

    public DistinctDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public Distinct deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return Distinct.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize Integer
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Integer value = parser.readValueAs(new TypeReference<Integer>() {});
          return Distinct.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public Distinct getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "Distinct cannot be null");
    }
  }
}

class DistinctBoolean extends Distinct {

  private final Boolean insideValue;

  DistinctBoolean(Boolean insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Boolean getInsideValue() {
    return insideValue;
  }
}

class DistinctInteger extends Distinct {

  private final Integer insideValue;

  DistinctInteger(Integer insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Integer getInsideValue() {
    return insideValue;
  }
}
