// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Removes stop (common) words from the query before executing it. `removeStopWords` is used in
 * conjunction with the `queryLanguages` setting. _list_: language ISO codes for which stop words
 * should be enabled. This list will override any values that you may have set in `queryLanguages`.
 * _true_: enables the stop words feature, ensuring that stop words are removed from consideration
 * in a search. The languages supported here are either [every
 * language](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/)
 * (this is the default) or those set by `queryLanguages`. _false_: turns off the stop words
 * feature, allowing stop words to be taken into account in a search.
 */
@JsonDeserialize(using = RemoveStopWords.RemoveStopWordsDeserializer.class)
@JsonSerialize(using = RemoveStopWords.RemoveStopWordsSerializer.class)
public abstract class RemoveStopWords implements CompoundType {

  private static final Logger LOGGER = Logger.getLogger(RemoveStopWords.class.getName());

  public static RemoveStopWords of(Boolean inside) {
    return new RemoveStopWordsBoolean(inside);
  }

  public static RemoveStopWords of(List<String> inside) {
    return new RemoveStopWordsListOfString(inside);
  }

  public static class RemoveStopWordsSerializer extends StdSerializer<RemoveStopWords> {

    public RemoveStopWordsSerializer(Class<RemoveStopWords> t) {
      super(t);
    }

    public RemoveStopWordsSerializer() {
      this(null);
    }

    @Override
    public void serialize(RemoveStopWords value, JsonGenerator jgen, SerializerProvider provider)
      throws IOException, JsonProcessingException {
      jgen.writeObject(value.getInsideValue());
    }
  }

  public static class RemoveStopWordsDeserializer extends StdDeserializer<RemoveStopWords> {

    public RemoveStopWordsDeserializer() {
      this(RemoveStopWords.class);
    }

    public RemoveStopWordsDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public RemoveStopWords deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return RemoveStopWords.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize List<String>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<String> value = parser.readValueAs(new TypeReference<List<String>>() {});
          return RemoveStopWords.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public RemoveStopWords getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "RemoveStopWords cannot be null");
    }
  }
}

class RemoveStopWordsBoolean extends RemoveStopWords {

  private final Boolean insideValue;

  RemoveStopWordsBoolean(Boolean insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Boolean getInsideValue() {
    return insideValue;
  }
}

class RemoveStopWordsListOfString extends RemoveStopWords {

  private final List<String> insideValue;

  RemoveStopWordsListOfString(List<String> insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public List<String> getInsideValue() {
    return insideValue;
  }
}
