// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.fasterxml.jackson.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Rule object. */
public class RuleResponse {

  @JsonProperty("_metadata")
  private RuleResponseMetadata metadata;

  @JsonProperty("objectID")
  private String objectID;

  @JsonProperty("conditions")
  private List<Condition> conditions;

  @JsonProperty("consequence")
  private Consequence consequence;

  @JsonProperty("description")
  private String description;

  @JsonProperty("enabled")
  private Boolean enabled;

  public RuleResponse setMetadata(RuleResponseMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   *
   * @return metadata
   */
  @javax.annotation.Nullable
  public RuleResponseMetadata getMetadata() {
    return metadata;
  }

  public RuleResponse setObjectID(String objectID) {
    this.objectID = objectID;
    return this;
  }

  /**
   * Unique identifier for a rule object.
   *
   * @return objectID
   */
  @javax.annotation.Nonnull
  public String getObjectID() {
    return objectID;
  }

  public RuleResponse setConditions(List<Condition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public RuleResponse addConditions(Condition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

  /**
   * [Conditions](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/#conditions)
   * required to activate a rule. You can use up to 25 conditions per rule.
   *
   * @return conditions
   */
  @javax.annotation.Nullable
  public List<Condition> getConditions() {
    return conditions;
  }

  public RuleResponse setConsequence(Consequence consequence) {
    this.consequence = consequence;
    return this;
  }

  /**
   * Get consequence
   *
   * @return consequence
   */
  @javax.annotation.Nullable
  public Consequence getConsequence() {
    return consequence;
  }

  public RuleResponse setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the rule's purpose. This can be helpful for display in the Algolia dashboard.
   *
   * @return description
   */
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public RuleResponse setEnabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Indicates whether to enable the rule. If it isn't enabled, it isn't applied at query time.
   *
   * @return enabled
   */
  @javax.annotation.Nullable
  public Boolean getEnabled() {
    return enabled;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RuleResponse ruleResponse = (RuleResponse) o;
    return (
      Objects.equals(this.metadata, ruleResponse.metadata) &&
      Objects.equals(this.objectID, ruleResponse.objectID) &&
      Objects.equals(this.conditions, ruleResponse.conditions) &&
      Objects.equals(this.consequence, ruleResponse.consequence) &&
      Objects.equals(this.description, ruleResponse.description) &&
      Objects.equals(this.enabled, ruleResponse.enabled)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, objectID, conditions, consequence, description, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RuleResponse {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    objectID: ").append(toIndentedString(objectID)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    consequence: ").append(toIndentedString(consequence)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
