// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.fasterxml.jackson.annotation.*;
import java.util.Objects;

/** TrendingItemsQuery */
public class TrendingItemsQuery {

  @JsonProperty("facetName")
  private String facetName;

  @JsonProperty("facetValue")
  private String facetValue;

  @JsonProperty("model")
  private TrendingItemsModel model;

  @JsonProperty("queryParameters")
  private SearchParamsObject queryParameters;

  @JsonProperty("fallbackParameters")
  private SearchParamsObject fallbackParameters;

  @JsonProperty("indexName")
  private String indexName;

  @JsonProperty("threshold")
  private Integer threshold;

  @JsonProperty("maxRecommendations")
  private Integer maxRecommendations;

  public TrendingItemsQuery setFacetName(String facetName) {
    this.facetName = facetName;
    return this;
  }

  /**
   * Facet name for trending models.
   *
   * @return facetName
   */
  @javax.annotation.Nullable
  public String getFacetName() {
    return facetName;
  }

  public TrendingItemsQuery setFacetValue(String facetValue) {
    this.facetValue = facetValue;
    return this;
  }

  /**
   * Facet value for trending models.
   *
   * @return facetValue
   */
  @javax.annotation.Nullable
  public String getFacetValue() {
    return facetValue;
  }

  public TrendingItemsQuery setModel(TrendingItemsModel model) {
    this.model = model;
    return this;
  }

  /**
   * Get model
   *
   * @return model
   */
  @javax.annotation.Nullable
  public TrendingItemsModel getModel() {
    return model;
  }

  public TrendingItemsQuery setQueryParameters(SearchParamsObject queryParameters) {
    this.queryParameters = queryParameters;
    return this;
  }

  /**
   * Get queryParameters
   *
   * @return queryParameters
   */
  @javax.annotation.Nullable
  public SearchParamsObject getQueryParameters() {
    return queryParameters;
  }

  public TrendingItemsQuery setFallbackParameters(SearchParamsObject fallbackParameters) {
    this.fallbackParameters = fallbackParameters;
    return this;
  }

  /**
   * Get fallbackParameters
   *
   * @return fallbackParameters
   */
  @javax.annotation.Nullable
  public SearchParamsObject getFallbackParameters() {
    return fallbackParameters;
  }

  public TrendingItemsQuery setIndexName(String indexName) {
    this.indexName = indexName;
    return this;
  }

  /**
   * Algolia index name.
   *
   * @return indexName
   */
  @javax.annotation.Nonnull
  public String getIndexName() {
    return indexName;
  }

  public TrendingItemsQuery setThreshold(Integer threshold) {
    this.threshold = threshold;
    return this;
  }

  /**
   * Recommendations with a confidence score lower than `threshold` won't appear in results. >
   * **Note**: Each recommendation has a confidence score of 0 to 100. The closer the score is to
   * 100, the more relevant the recommendations are. minimum: 0 maximum: 100
   *
   * @return threshold
   */
  @javax.annotation.Nullable
  public Integer getThreshold() {
    return threshold;
  }

  public TrendingItemsQuery setMaxRecommendations(Integer maxRecommendations) {
    this.maxRecommendations = maxRecommendations;
    return this;
  }

  /**
   * Maximum number of recommendations to retrieve. If 0, all recommendations will be returned.
   *
   * @return maxRecommendations
   */
  @javax.annotation.Nullable
  public Integer getMaxRecommendations() {
    return maxRecommendations;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrendingItemsQuery trendingItemsQuery = (TrendingItemsQuery) o;
    return (
      Objects.equals(this.facetName, trendingItemsQuery.facetName) &&
      Objects.equals(this.facetValue, trendingItemsQuery.facetValue) &&
      Objects.equals(this.model, trendingItemsQuery.model) &&
      Objects.equals(this.queryParameters, trendingItemsQuery.queryParameters) &&
      Objects.equals(this.fallbackParameters, trendingItemsQuery.fallbackParameters) &&
      Objects.equals(this.indexName, trendingItemsQuery.indexName) &&
      Objects.equals(this.threshold, trendingItemsQuery.threshold) &&
      Objects.equals(this.maxRecommendations, trendingItemsQuery.maxRecommendations)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(facetName, facetValue, model, queryParameters, fallbackParameters, indexName, threshold, maxRecommendations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrendingItemsQuery {\n");
    sb.append("    facetName: ").append(toIndentedString(facetName)).append("\n");
    sb.append("    facetValue: ").append(toIndentedString(facetValue)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    queryParameters: ").append(toIndentedString(queryParameters)).append("\n");
    sb.append("    fallbackParameters: ").append(toIndentedString(fallbackParameters)).append("\n");
    sb.append("    indexName: ").append(toIndentedString(indexName)).append("\n");
    sb.append("    threshold: ").append(toIndentedString(threshold)).append("\n");
    sb.append("    maxRecommendations: ").append(toIndentedString(maxRecommendations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
