// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Precision of a geographical search (in meters), to [group results that are more or less the same
 * distance from a central
 * point](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/in-depth/geo-ranking-precision/).
 */
@JsonDeserialize(using = AroundPrecision.AroundPrecisionDeserializer.class)
@JsonSerialize(using = AroundPrecision.AroundPrecisionSerializer.class)
public abstract class AroundPrecision implements CompoundType {

  private static final Logger LOGGER = Logger.getLogger(AroundPrecision.class.getName());

  public static AroundPrecision of(Integer inside) {
    return new AroundPrecisionInteger(inside);
  }

  public static AroundPrecision of(List<AroundPrecisionFromValueInner> inside) {
    return new AroundPrecisionListOfAroundPrecisionFromValueInner(inside);
  }

  public static class AroundPrecisionSerializer extends StdSerializer<AroundPrecision> {

    public AroundPrecisionSerializer(Class<AroundPrecision> t) {
      super(t);
    }

    public AroundPrecisionSerializer() {
      this(null);
    }

    @Override
    public void serialize(AroundPrecision value, JsonGenerator jgen, SerializerProvider provider)
      throws IOException, JsonProcessingException {
      jgen.writeObject(value.getInsideValue());
    }
  }

  public static class AroundPrecisionDeserializer extends StdDeserializer<AroundPrecision> {

    public AroundPrecisionDeserializer() {
      this(AroundPrecision.class);
    }

    public AroundPrecisionDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public AroundPrecision deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Integer
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Integer value = parser.readValueAs(new TypeReference<Integer>() {});
          return AroundPrecision.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
        }
      }

      // deserialize List<AroundPrecisionFromValueInner>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<AroundPrecisionFromValueInner> value = parser.readValueAs(new TypeReference<List<AroundPrecisionFromValueInner>>() {});
          return AroundPrecision.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest(
            "Failed to deserialize oneOf List<AroundPrecisionFromValueInner> (error: " +
            e.getMessage() +
            ") (type: List<AroundPrecisionFromValueInner>)"
          );
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public AroundPrecision getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "AroundPrecision cannot be null");
    }
  }
}

class AroundPrecisionInteger extends AroundPrecision {

  private final Integer insideValue;

  AroundPrecisionInteger(Integer insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Integer getInsideValue() {
    return insideValue;
  }
}

class AroundPrecisionListOfAroundPrecisionFromValueInner extends AroundPrecision {

  private final List<AroundPrecisionFromValueInner> insideValue;

  AroundPrecisionListOfAroundPrecisionFromValueInner(List<AroundPrecisionFromValueInner> insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public List<AroundPrecisionFromValueInner> getInsideValue() {
    return insideValue;
  }
}
