// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * Controls whether [typo
 * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/)
 * is enabled and how it is applied.
 */
@JsonDeserialize(using = TypoTolerance.TypoToleranceDeserializer.class)
@JsonSerialize(using = TypoTolerance.TypoToleranceSerializer.class)
public abstract class TypoTolerance implements CompoundType {

  private static final Logger LOGGER = Logger.getLogger(TypoTolerance.class.getName());

  public static TypoTolerance of(Boolean inside) {
    return new TypoToleranceBoolean(inside);
  }

  public static TypoTolerance of(TypoToleranceEnum inside) {
    return new TypoToleranceTypoToleranceEnum(inside);
  }

  public static class TypoToleranceSerializer extends StdSerializer<TypoTolerance> {

    public TypoToleranceSerializer(Class<TypoTolerance> t) {
      super(t);
    }

    public TypoToleranceSerializer() {
      this(null);
    }

    @Override
    public void serialize(TypoTolerance value, JsonGenerator jgen, SerializerProvider provider)
      throws IOException, JsonProcessingException {
      jgen.writeObject(value.getInsideValue());
    }
  }

  public static class TypoToleranceDeserializer extends StdDeserializer<TypoTolerance> {

    public TypoToleranceDeserializer() {
      this(TypoTolerance.class);
    }

    public TypoToleranceDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public TypoTolerance deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return TypoTolerance.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize TypoToleranceEnum
      if (tree.isObject()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          TypoToleranceEnum value = parser.readValueAs(new TypeReference<TypoToleranceEnum>() {});
          return TypoTolerance.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf TypoToleranceEnum (error: " + e.getMessage() + ") (type: TypoToleranceEnum)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public TypoTolerance getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "TypoTolerance cannot be null");
    }
  }
}

class TypoToleranceBoolean extends TypoTolerance {

  private final Boolean insideValue;

  TypoToleranceBoolean(Boolean insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public Boolean getInsideValue() {
    return insideValue;
  }
}

class TypoToleranceTypoToleranceEnum extends TypoTolerance {

  private final TypoToleranceEnum insideValue;

  TypoToleranceTypoToleranceEnum(TypoToleranceEnum insideValue) {
    this.insideValue = insideValue;
  }

  @Override
  public TypoToleranceEnum getInsideValue() {
    return insideValue;
  }
}
