/*
 * Decompiled with CFR 0.152.
 */
package com.algolia;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.AlgoliaAgent;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.HttpRequester;
import com.algolia.utils.JSONBuilder;
import com.algolia.utils.LogLevel;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.Requester;
import com.algolia.utils.UseReadTransporter;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;

public abstract class ApiClient {
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private AlgoliaAgent algoliaAgent;
    private String contentType;
    private Requester requester;
    protected ObjectMapper json;

    public ApiClient(String appId, String apiKey, String clientName, String version, ClientOptions options) {
        if (appId == null || appId.length() == 0) {
            throw new AlgoliaRuntimeException("`appId` is missing.");
        }
        if (apiKey == null || apiKey.length() == 0) {
            throw new AlgoliaRuntimeException("`apiKey` is missing.");
        }
        this.contentType = "application/json";
        this.algoliaAgent = new AlgoliaAgent(version);
        this.algoliaAgent.addSegment(new AlgoliaAgent.Segment(clientName, version));
        if (options != null && options.getAlgoliaAgentSegments() != null) {
            for (AlgoliaAgent.Segment segment : options.getAlgoliaAgentSegments()) {
                this.algoliaAgent.addSegment(segment);
            }
        }
        this.refreshUserAgent();
        this.addDefaultHeader("X-Algolia-Application-Id", appId);
        this.addDefaultHeader("X-Algolia-API-Key", apiKey);
        this.addDefaultHeader("Accept", this.contentType);
        this.addDefaultHeader("Content-Type", this.contentType);
        this.requester = options != null && options.getRequester() != null ? options.getRequester() : new HttpRequester();
        this.json = new JSONBuilder().build();
    }

    private void refreshUserAgent() {
        this.addDefaultHeader("User-Agent", this.algoliaAgent.toString());
    }

    public ApiClient addAlgoliaAgent(AlgoliaAgent.Segment segment) {
        this.algoliaAgent.addSegment(segment);
        this.refreshUserAgent();
        return this;
    }

    public ApiClient removeAlgoliaAgent(AlgoliaAgent.Segment segment) {
        this.algoliaAgent.removeSegment(segment);
        this.refreshUserAgent();
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setLogLevel(LogLevel level) {
        this.requester.setLogLevel(level);
        return this;
    }

    public int getConnectTimeout() {
        return this.requester.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.requester.setConnectTimeout(connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.requester.getReadTimeout();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.requester.setReadTimeout(readTimeout);
        return this;
    }

    public int getWriteTimeout() {
        return this.requester.getWriteTimeout();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.requester.setWriteTimeout(writeTimeout);
        return this;
    }

    public ApiClient setHosts(List<StatefulHost> hosts) {
        this.requester.setHosts(hosts);
        return this;
    }

    public String parameterToString(Object param) throws UnsupportedOperationException {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            throw new UnsupportedOperationException("Date must come as string (already serialized)");
        }
        if (param instanceof Collection) {
            StringJoiner b = new StringJoiner(",");
            for (Object o : (Collection)param) {
                b.add(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public RequestBody serialize(Object obj) throws AlgoliaRuntimeException {
        String content;
        if (obj != null) {
            try {
                if (obj.getClass().getName().equals("java.lang.Object")) {
                    content = "{}";
                }
                content = this.json.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new AlgoliaRuntimeException(e);
            }
        } else {
            content = "";
        }
        return RequestBody.create((String)content, (MediaType)MediaType.parse((String)this.contentType));
    }

    public <T> CompletableFuture<T> executeAsync(Call call, final JavaType returnType) {
        final CompletableFuture future = new CompletableFuture();
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e.getCause());
            }

            public void onResponse(Call call, Response response) throws IOException {
                try {
                    Object result = ApiClient.this.requester.handleResponse(response, returnType);
                    future.complete(result);
                }
                catch (AlgoliaRuntimeException e) {
                    future.completeExceptionally(e);
                }
                catch (Exception e) {
                    future.completeExceptionally(new AlgoliaRuntimeException(e));
                }
            }
        });
        return future;
    }

    public <T> CompletableFuture<T> executeAsync(Call call, Class<?> returnType, Class<?> innerType) {
        return this.executeAsync(call, this.json.getTypeFactory().constructParametricType(returnType, new Class[]{innerType}));
    }

    public <T> CompletableFuture<T> executeAsync(Call call, TypeReference returnType) {
        return this.executeAsync(call, this.json.getTypeFactory().constructType(returnType));
    }

    public Call buildCall(String path, String method, Map<String, Object> queryParameters, Object body, Map<String, String> headerParams, RequestOptions requestOptions, Boolean useReadTransporter) throws AlgoliaRuntimeException {
        Request request = this.buildRequest(path, method, queryParameters, body, headerParams, requestOptions, useReadTransporter);
        return this.requester.newCall(request);
    }

    public Request buildRequest(String path, String method, Map<String, Object> queryParameters, Object body, Map<String, String> headerParams, RequestOptions requestOptions, Boolean useReadTransporter) throws AlgoliaRuntimeException {
        boolean hasRequestOptions = requestOptions != null;
        String url = this.buildUrl(path, queryParameters, hasRequestOptions ? requestOptions.getExtraQueryParameters() : null);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, hasRequestOptions ? requestOptions.getExtraHeaders() : null, reqBuilder);
        RequestBody reqBody = !HttpMethod.permitsRequestBody((String)method) || method.equals("DELETE") && body == null ? null : this.serialize(body);
        if (useReadTransporter.booleanValue()) {
            reqBuilder.tag((Object)new UseReadTransporter());
        }
        return reqBuilder.method(method, reqBody).build();
    }

    public String buildUrl(String path, Map<String, Object> queryParameters, Map<String, Object> extraQueryParameters) {
        if (extraQueryParameters != null) {
            for (Map.Entry<String, Object> param : extraQueryParameters.entrySet()) {
                queryParameters.put(param.getKey(), param.getValue());
            }
        }
        StringBuilder url = new StringBuilder();
        url.append("http://temp.path").append(path);
        if (queryParameters != null && !queryParameters.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Map.Entry<String, Object> param : queryParameters.entrySet()) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getKey())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Map<String, String> extraHeaderParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey().toLowerCase(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey().toLowerCase(), this.parameterToString(header.getValue()));
        }
        if (extraHeaderParams != null) {
            for (Map.Entry<String, String> header : extraHeaderParams.entrySet()) {
                reqBuilder.header(header.getKey().toLowerCase(), this.parameterToString(header.getValue()));
            }
        }
    }
}

