/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.abtesting.ABTest;
import com.algolia.model.abtesting.ABTestResponse;
import com.algolia.model.abtesting.AddABTestsRequest;
import com.algolia.model.abtesting.ListABTestsResponse;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;

public class AbtestingClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"de", "us"};

    public AbtestingClient(String appId, String apiKey) {
        this(appId, apiKey, null, null);
    }

    public AbtestingClient(String appId, String apiKey, ClientOptions options) {
        this(appId, apiKey, null, options);
    }

    public AbtestingClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public AbtestingClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Abtesting", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(AbtestingClient.getDefaultHosts(region));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        boolean found;
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        boolean bl = found = region == null;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
        }
        String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);
        hosts.add(new StatefulHost(url, "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public ABTestResponse addABTests(AddABTestsRequest addABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addABTestsAsync(addABTestsRequest, requestOptions));
    }

    public ABTestResponse addABTests(AddABTestsRequest addABTestsRequest) throws AlgoliaRuntimeException {
        return this.addABTests(addABTestsRequest, null);
    }

    public CompletableFuture<ABTestResponse> addABTestsAsync(AddABTestsRequest addABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (addABTestsRequest == null) {
            throw new AlgoliaRuntimeException("Parameter `addABTestsRequest` is required when calling `addABTests`.");
        }
        AddABTestsRequest bodyObj = addABTestsRequest;
        String requestPath = "/2/abtests";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> addABTestsAsync(AddABTestsRequest addABTestsRequest) throws AlgoliaRuntimeException {
        return this.addABTestsAsync(addABTestsRequest, null);
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public ABTestResponse deleteABTest(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteABTestAsync(id, requestOptions));
    }

    public ABTestResponse deleteABTest(Integer id) throws AlgoliaRuntimeException {
        return this.deleteABTest(id, null);
    }

    public CompletableFuture<ABTestResponse> deleteABTestAsync(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (id == null) {
            throw new AlgoliaRuntimeException("Parameter `id` is required when calling `deleteABTest`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/abtests/{id}".replaceAll("\\{id\\}", this.escapeString(id.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> deleteABTestAsync(Integer id) throws AlgoliaRuntimeException {
        return this.deleteABTestAsync(id, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public ABTest getABTest(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getABTestAsync(id, requestOptions));
    }

    public ABTest getABTest(Integer id) throws AlgoliaRuntimeException {
        return this.getABTest(id, null);
    }

    public CompletableFuture<ABTest> getABTestAsync(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (id == null) {
            throw new AlgoliaRuntimeException("Parameter `id` is required when calling `getABTest`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/abtests/{id}".replaceAll("\\{id\\}", this.escapeString(id.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ABTest>(){});
    }

    public CompletableFuture<ABTest> getABTestAsync(Integer id) throws AlgoliaRuntimeException {
        return this.getABTestAsync(id, null);
    }

    public ListABTestsResponse listABTests(Integer offset, Integer limit, String indexPrefix, String indexSuffix, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listABTestsAsync(offset, limit, indexPrefix, indexSuffix, requestOptions));
    }

    public ListABTestsResponse listABTests(Integer offset, Integer limit, String indexPrefix, String indexSuffix) throws AlgoliaRuntimeException {
        return this.listABTests(offset, limit, indexPrefix, indexSuffix, null);
    }

    public ListABTestsResponse listABTests(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listABTests(null, null, null, null, requestOptions);
    }

    public ListABTestsResponse listABTests() throws AlgoliaRuntimeException {
        return this.listABTests(null, null, null, null, null);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(Integer offset, Integer limit, String indexPrefix, String indexSuffix, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/2/abtests";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (indexPrefix != null) {
            queryParameters.put("indexPrefix", this.parameterToString(indexPrefix));
        }
        if (indexSuffix != null) {
            queryParameters.put("indexSuffix", this.parameterToString(indexSuffix));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ListABTestsResponse>(){});
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(Integer offset, Integer limit, String indexPrefix, String indexSuffix) throws AlgoliaRuntimeException {
        return this.listABTestsAsync(offset, limit, indexPrefix, indexSuffix, null);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listABTestsAsync(null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync() throws AlgoliaRuntimeException {
        return this.listABTestsAsync(null, null, null, null, null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public ABTestResponse stopABTest(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.stopABTestAsync(id, requestOptions));
    }

    public ABTestResponse stopABTest(Integer id) throws AlgoliaRuntimeException {
        return this.stopABTest(id, null);
    }

    public CompletableFuture<ABTestResponse> stopABTestAsync(Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (id == null) {
            throw new AlgoliaRuntimeException("Parameter `id` is required when calling `stopABTest`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/abtests/{id}/stop".replaceAll("\\{id\\}", this.escapeString(id.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> stopABTestAsync(Integer id) throws AlgoliaRuntimeException {
        return this.stopABTestAsync(id, null);
    }
}

