/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.analytics.Direction;
import com.algolia.model.analytics.GetAverageClickPositionResponse;
import com.algolia.model.analytics.GetClickPositionsResponse;
import com.algolia.model.analytics.GetClickThroughRateResponse;
import com.algolia.model.analytics.GetConversationRateResponse;
import com.algolia.model.analytics.GetNoClickRateResponse;
import com.algolia.model.analytics.GetNoResultsRateResponse;
import com.algolia.model.analytics.GetSearchesCountResponse;
import com.algolia.model.analytics.GetSearchesNoClicksResponse;
import com.algolia.model.analytics.GetSearchesNoResultsResponse;
import com.algolia.model.analytics.GetStatusResponse;
import com.algolia.model.analytics.GetTopCountriesResponse;
import com.algolia.model.analytics.GetTopFilterAttributesResponse;
import com.algolia.model.analytics.GetTopFilterForAttributeResponse;
import com.algolia.model.analytics.GetTopFiltersNoResultsResponse;
import com.algolia.model.analytics.GetTopHitsResponse;
import com.algolia.model.analytics.GetTopSearchesResponse;
import com.algolia.model.analytics.GetUsersCountResponse;
import com.algolia.model.analytics.OrderBy;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;

public class AnalyticsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"de", "us"};

    public AnalyticsClient(String appId, String apiKey) {
        this(appId, apiKey, null, null);
    }

    public AnalyticsClient(String appId, String apiKey, ClientOptions options) {
        this(appId, apiKey, null, options);
    }

    public AnalyticsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public AnalyticsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Analytics", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(AnalyticsClient.getDefaultHosts(region));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        boolean found;
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        boolean bl = found = region == null;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
        }
        String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);
        hosts.add(new StatefulHost(url, "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAverageClickPositionAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetAverageClickPositionResponse getAverageClickPosition(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, startDate, endDate, tags, null);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, null, null, null, requestOptions);
    }

    public GetAverageClickPositionResponse getAverageClickPosition(String index) throws AlgoliaRuntimeException {
        return this.getAverageClickPosition(index, null, null, null, null);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getAverageClickPosition`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/clicks/averageClickPosition";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetAverageClickPositionResponse>(){});
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(String index) throws AlgoliaRuntimeException {
        return this.getAverageClickPositionAsync(index, null, null, null, null);
    }

    public GetClickPositionsResponse getClickPositions(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClickPositionsAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetClickPositionsResponse getClickPositions(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, startDate, endDate, tags, null);
    }

    public GetClickPositionsResponse getClickPositions(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, null, null, null, requestOptions);
    }

    public GetClickPositionsResponse getClickPositions(String index) throws AlgoliaRuntimeException {
        return this.getClickPositions(index, null, null, null, null);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getClickPositions`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/clicks/positions";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetClickPositionsResponse>(){});
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(String index) throws AlgoliaRuntimeException {
        return this.getClickPositionsAsync(index, null, null, null, null);
    }

    public GetClickThroughRateResponse getClickThroughRate(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClickThroughRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetClickThroughRateResponse getClickThroughRate(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, startDate, endDate, tags, null);
    }

    public GetClickThroughRateResponse getClickThroughRate(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, null, null, null, requestOptions);
    }

    public GetClickThroughRateResponse getClickThroughRate(String index) throws AlgoliaRuntimeException {
        return this.getClickThroughRate(index, null, null, null, null);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getClickThroughRate`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/clicks/clickThroughRate";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetClickThroughRateResponse>(){});
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(String index) throws AlgoliaRuntimeException {
        return this.getClickThroughRateAsync(index, null, null, null, null);
    }

    public GetConversationRateResponse getConversationRate(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConversationRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetConversationRateResponse getConversationRate(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getConversationRate(index, startDate, endDate, tags, null);
    }

    public GetConversationRateResponse getConversationRate(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getConversationRate(index, null, null, null, requestOptions);
    }

    public GetConversationRateResponse getConversationRate(String index) throws AlgoliaRuntimeException {
        return this.getConversationRate(index, null, null, null, null);
    }

    public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getConversationRate`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/conversions/conversionRate";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetConversationRateResponse>(){});
    }

    public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getConversationRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getConversationRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(String index) throws AlgoliaRuntimeException {
        return this.getConversationRateAsync(index, null, null, null, null);
    }

    public GetNoClickRateResponse getNoClickRate(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getNoClickRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetNoClickRateResponse getNoClickRate(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, startDate, endDate, tags, null);
    }

    public GetNoClickRateResponse getNoClickRate(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, null, null, null, requestOptions);
    }

    public GetNoClickRateResponse getNoClickRate(String index) throws AlgoliaRuntimeException {
        return this.getNoClickRate(index, null, null, null, null);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getNoClickRate`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches/noClickRate";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetNoClickRateResponse>(){});
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(String index) throws AlgoliaRuntimeException {
        return this.getNoClickRateAsync(index, null, null, null, null);
    }

    public GetNoResultsRateResponse getNoResultsRate(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getNoResultsRateAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetNoResultsRateResponse getNoResultsRate(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, startDate, endDate, tags, null);
    }

    public GetNoResultsRateResponse getNoResultsRate(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, null, null, null, requestOptions);
    }

    public GetNoResultsRateResponse getNoResultsRate(String index) throws AlgoliaRuntimeException {
        return this.getNoResultsRate(index, null, null, null, null);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getNoResultsRate`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches/noResultRate";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetNoResultsRateResponse>(){});
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(String index) throws AlgoliaRuntimeException {
        return this.getNoResultsRateAsync(index, null, null, null, null);
    }

    public GetSearchesCountResponse getSearchesCount(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesCountAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetSearchesCountResponse getSearchesCount(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, startDate, endDate, tags, null);
    }

    public GetSearchesCountResponse getSearchesCount(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, null, null, null, requestOptions);
    }

    public GetSearchesCountResponse getSearchesCount(String index) throws AlgoliaRuntimeException {
        return this.getSearchesCount(index, null, null, null, null);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getSearchesCount`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches/count";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetSearchesCountResponse>(){});
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(String index) throws AlgoliaRuntimeException {
        return this.getSearchesCountAsync(index, null, null, null, null);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, null, null, null, null, null, requestOptions);
    }

    public GetSearchesNoClicksResponse getSearchesNoClicks(String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicks(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getSearchesNoClicks`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches/noClicks";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetSearchesNoClicksResponse>(){});
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoClicksAsync(index, null, null, null, null, null, null);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, null, null, null, null, null, requestOptions);
    }

    public GetSearchesNoResultsResponse getSearchesNoResults(String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoResults(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getSearchesNoResults`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches/noResults";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetSearchesNoResultsResponse>(){});
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(String index) throws AlgoliaRuntimeException {
        return this.getSearchesNoResultsAsync(index, null, null, null, null, null, null);
    }

    public GetStatusResponse getStatus(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getStatusAsync(index, requestOptions));
    }

    public GetStatusResponse getStatus(String index) throws AlgoliaRuntimeException {
        return this.getStatus(index, null);
    }

    public CompletableFuture<GetStatusResponse> getStatusAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getStatus`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/status";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetStatusResponse>(){});
    }

    public CompletableFuture<GetStatusResponse> getStatusAsync(String index) throws AlgoliaRuntimeException {
        return this.getStatusAsync(index, null);
    }

    public GetTopCountriesResponse getTopCountries(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopCountriesResponse getTopCountries(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopCountriesResponse getTopCountries(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, null, null, null, null, null, requestOptions);
    }

    public GetTopCountriesResponse getTopCountries(String index) throws AlgoliaRuntimeException {
        return this.getTopCountries(index, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopCountries`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/countries";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopCountriesResponse>(){});
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(String index, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(String index) throws AlgoliaRuntimeException {
        return this.getTopCountriesAsync(index, null, null, null, null, null, null);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFilterAttributesResponse getTopFilterAttributes(String index) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributes(index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopFilterAttributes`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/filters";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (search != null) {
            queryParameters.put("search", this.parameterToString(search));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopFilterAttributesResponse>(){});
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(String index) throws AlgoliaRuntimeException {
        return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, null);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(String attribute, String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(String attribute, String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(String attribute, String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFilterForAttributeResponse getTopFilterForAttribute(String attribute, String index) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(String attribute, String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (attribute == null) {
            throw new AlgoliaRuntimeException("Parameter `attribute` is required when calling `getTopFilterForAttribute`.");
        }
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopFilterForAttribute`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/filters/{attribute}".replaceAll("\\{attribute\\}", this.escapeString(attribute.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (search != null) {
            queryParameters.put("search", this.parameterToString(search));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopFilterForAttributeResponse>(){});
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(String attribute, String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(String attribute, String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(String attribute, String index) throws AlgoliaRuntimeException {
        return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, null);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, null, null, null, null, null, null, requestOptions);
    }

    public GetTopFiltersNoResultsResponse getTopFiltersNoResults(String index) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResults(index, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopFiltersNoResults`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/filters/noResults";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (search != null) {
            queryParameters.put("search", this.parameterToString(search));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopFiltersNoResultsResponse>(){});
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(String index, String search, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(String index) throws AlgoliaRuntimeException {
        return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, null);
    }

    public GetTopHitsResponse getTopHits(String index, String search, Boolean clickAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopHitsAsync(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, requestOptions));
    }

    public GetTopHitsResponse getTopHits(String index, String search, Boolean clickAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopHits(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, null);
    }

    public GetTopHitsResponse getTopHits(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopHits(index, null, null, null, null, null, null, null, requestOptions);
    }

    public GetTopHitsResponse getTopHits(String index) throws AlgoliaRuntimeException {
        return this.getTopHits(index, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(String index, String search, Boolean clickAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopHits`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/hits";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (search != null) {
            queryParameters.put("search", this.parameterToString(search));
        }
        if (clickAnalytics != null) {
            queryParameters.put("clickAnalytics", this.parameterToString(clickAnalytics));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopHitsResponse>(){});
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(String index, String search, Boolean clickAnalytics, String startDate, String endDate, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(String index) throws AlgoliaRuntimeException {
        return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null);
    }

    public GetTopSearchesResponse getTopSearches(String index, Boolean clickAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopSearchesAsync(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, requestOptions));
    }

    public GetTopSearchesResponse getTopSearches(String index, Boolean clickAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
    }

    public GetTopSearchesResponse getTopSearches(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, null, null, null, null, null, null, null, null, requestOptions);
    }

    public GetTopSearchesResponse getTopSearches(String index) throws AlgoliaRuntimeException {
        return this.getTopSearches(index, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(String index, Boolean clickAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getTopSearches`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/searches";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (clickAnalytics != null) {
            queryParameters.put("clickAnalytics", this.parameterToString(clickAnalytics));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (orderBy != null) {
            queryParameters.put("orderBy", this.parameterToString((Object)orderBy));
        }
        if (direction != null) {
            queryParameters.put("direction", this.parameterToString((Object)direction));
        }
        if (limit != null) {
            queryParameters.put("limit", this.parameterToString(limit));
        }
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopSearchesResponse>(){});
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(String index, Boolean clickAnalytics, String startDate, String endDate, OrderBy orderBy, Direction direction, Integer limit, Integer offset, String tags) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(String index) throws AlgoliaRuntimeException {
        return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null);
    }

    public GetUsersCountResponse getUsersCount(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUsersCountAsync(index, startDate, endDate, tags, requestOptions));
    }

    public GetUsersCountResponse getUsersCount(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, startDate, endDate, tags, null);
    }

    public GetUsersCountResponse getUsersCount(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, null, null, null, requestOptions);
    }

    public GetUsersCountResponse getUsersCount(String index) throws AlgoliaRuntimeException {
        return this.getUsersCount(index, null, null, null, null);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(String index, String startDate, String endDate, String tags, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (index == null) {
            throw new AlgoliaRuntimeException("Parameter `index` is required when calling `getUsersCount`.");
        }
        Object bodyObj = null;
        String requestPath = "/2/users/count";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (index != null) {
            queryParameters.put("index", this.parameterToString(index));
        }
        if (startDate != null) {
            queryParameters.put("startDate", this.parameterToString(startDate));
        }
        if (endDate != null) {
            queryParameters.put("endDate", this.parameterToString(endDate));
        }
        if (tags != null) {
            queryParameters.put("tags", this.parameterToString(tags));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetUsersCountResponse>(){});
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(String index, String startDate, String endDate, String tags) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, startDate, endDate, tags, null);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, null, null, null, requestOptions);
    }

    public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(String index) throws AlgoliaRuntimeException {
        return this.getUsersCountAsync(index, null, null, null, null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }
}

