/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.monitoring.IncidentsResponse;
import com.algolia.model.monitoring.IndexingTimeResponse;
import com.algolia.model.monitoring.InfrastructureResponse;
import com.algolia.model.monitoring.InventoryResponse;
import com.algolia.model.monitoring.LatencyResponse;
import com.algolia.model.monitoring.Metric;
import com.algolia.model.monitoring.Period;
import com.algolia.model.monitoring.StatusResponse;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;

public class MonitoringClient
extends ApiClient {
    public MonitoringClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public MonitoringClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Monitoring", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(MonitoringClient.getDefaultHosts(appId));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String appId) {
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        hosts.add(new StatefulHost(appId + "-dsn.algolia.net", "https", EnumSet.of(CallType.READ)));
        hosts.add(new StatefulHost(appId + ".algolia.net", "https", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new StatefulHost(appId + "-1.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-2.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-3.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public IncidentsResponse getClusterIncidents(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterIncidentsAsync(clusters, requestOptions));
    }

    public IncidentsResponse getClusterIncidents(String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidents(clusters, null);
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (clusters == null) {
            throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getClusterIncidents`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/incidents/{clusters}".replaceAll("\\{clusters\\}", this.escapeString(clusters.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidentsAsync(clusters, null);
    }

    public StatusResponse getClusterStatus(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterStatusAsync(clusters, requestOptions));
    }

    public StatusResponse getClusterStatus(String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatus(clusters, null);
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (clusters == null) {
            throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getClusterStatus`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/status/{clusters}".replaceAll("\\{clusters\\}", this.escapeString(clusters.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatusAsync(clusters, null);
    }

    public IncidentsResponse getIncidents(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIncidentsAsync(requestOptions));
    }

    public IncidentsResponse getIncidents() throws AlgoliaRuntimeException {
        return this.getIncidents(null);
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/incidents";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync() throws AlgoliaRuntimeException {
        return this.getIncidentsAsync(null);
    }

    public IndexingTimeResponse getIndexingTime(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIndexingTimeAsync(clusters, requestOptions));
    }

    public IndexingTimeResponse getIndexingTime(String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTime(clusters, null);
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (clusters == null) {
            throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getIndexingTime`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexing/{clusters}".replaceAll("\\{clusters\\}", this.escapeString(clusters.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<IndexingTimeResponse>(){});
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTimeAsync(clusters, null);
    }

    public InventoryResponse getInventory(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getInventoryAsync(requestOptions));
    }

    public InventoryResponse getInventory() throws AlgoliaRuntimeException {
        return this.getInventory(null);
    }

    public CompletableFuture<InventoryResponse> getInventoryAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/inventory/servers";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<InventoryResponse>(){});
    }

    public CompletableFuture<InventoryResponse> getInventoryAsync() throws AlgoliaRuntimeException {
        return this.getInventoryAsync(null);
    }

    public LatencyResponse getLatency(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLatencyAsync(clusters, requestOptions));
    }

    public LatencyResponse getLatency(String clusters) throws AlgoliaRuntimeException {
        return this.getLatency(clusters, null);
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (clusters == null) {
            throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getLatency`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/latency/{clusters}".replaceAll("\\{clusters\\}", this.escapeString(clusters.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<LatencyResponse>(){});
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(String clusters) throws AlgoliaRuntimeException {
        return this.getLatencyAsync(clusters, null);
    }

    public InfrastructureResponse getMetrics(Metric metric, Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getMetricsAsync(metric, period, requestOptions));
    }

    public InfrastructureResponse getMetrics(Metric metric, Period period) throws AlgoliaRuntimeException {
        return this.getMetrics(metric, period, null);
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(Metric metric, Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (metric == null) {
            throw new AlgoliaRuntimeException("Parameter `metric` is required when calling `getMetrics`.");
        }
        if (period == null) {
            throw new AlgoliaRuntimeException("Parameter `period` is required when calling `getMetrics`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/infrastructure/{metric}/period/{period}".replaceAll("\\{metric\\}", this.escapeString(metric.toString())).replaceAll("\\{period\\}", this.escapeString(period.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<InfrastructureResponse>(){});
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(Metric metric, Period period) throws AlgoliaRuntimeException {
        return this.getMetricsAsync(metric, period, null);
    }

    public Map<String, Map<String, Boolean>> getReachability(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getReachabilityAsync(clusters, requestOptions));
    }

    public Map<String, Map<String, Boolean>> getReachability(String clusters) throws AlgoliaRuntimeException {
        return this.getReachability(clusters, null);
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (clusters == null) {
            throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getReachability`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/reachability/{clusters}/probes".replaceAll("\\{clusters\\}", this.escapeString(clusters.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Map<String, Map<String, Boolean>>>(){});
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(String clusters) throws AlgoliaRuntimeException {
        return this.getReachabilityAsync(clusters, null);
    }

    public StatusResponse getStatus(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getStatusAsync(requestOptions));
    }

    public StatusResponse getStatus() throws AlgoliaRuntimeException {
        return this.getStatus(null);
    }

    public CompletableFuture<StatusResponse> getStatusAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/status";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getStatusAsync() throws AlgoliaRuntimeException {
        return this.getStatusAsync(null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }
}

