/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.querysuggestions.BaseResponse;
import com.algolia.model.querysuggestions.GetConfigStatus200Response;
import com.algolia.model.querysuggestions.GetLogFile200Response;
import com.algolia.model.querysuggestions.QuerySuggestionsConfiguration;
import com.algolia.model.querysuggestions.QuerySuggestionsConfigurationResponse;
import com.algolia.model.querysuggestions.QuerySuggestionsConfigurationWithIndex;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;

public class QuerySuggestionsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public QuerySuggestionsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public QuerySuggestionsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "QuerySuggestions", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(QuerySuggestionsClient.getDefaultHosts(region));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "query-suggestions.{region}.algolia.com".replace("{region}", region);
        hosts.add(new StatefulHost(url, "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public BaseResponse createConfig(QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createConfigAsync(querySuggestionsConfigurationWithIndex, requestOptions));
    }

    public BaseResponse createConfig(QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfig(querySuggestionsConfigurationWithIndex, null);
    }

    public CompletableFuture<BaseResponse> createConfigAsync(QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (querySuggestionsConfigurationWithIndex == null) {
            throw new AlgoliaRuntimeException("Parameter `querySuggestionsConfigurationWithIndex` is required when calling `createConfig`.");
        }
        QuerySuggestionsConfigurationWithIndex bodyObj = querySuggestionsConfigurationWithIndex;
        String requestPath = "/1/configs";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> createConfigAsync(QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfigAsync(querySuggestionsConfigurationWithIndex, null);
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public BaseResponse deleteConfig(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteConfigAsync(indexName, requestOptions));
    }

    public BaseResponse deleteConfig(String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfig(indexName, null);
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteConfig`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/configs/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfigAsync(indexName, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public List<QuerySuggestionsConfigurationResponse> getAllConfigs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAllConfigsAsync(requestOptions));
    }

    public List<QuerySuggestionsConfigurationResponse> getAllConfigs() throws AlgoliaRuntimeException {
        return this.getAllConfigs(null);
    }

    public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/configs";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<List<QuerySuggestionsConfigurationResponse>>(){});
    }

    public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync() throws AlgoliaRuntimeException {
        return this.getAllConfigsAsync(null);
    }

    public QuerySuggestionsConfigurationResponse getConfig(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigAsync(indexName, requestOptions));
    }

    public QuerySuggestionsConfigurationResponse getConfig(String indexName) throws AlgoliaRuntimeException {
        return this.getConfig(indexName, null);
    }

    public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getConfig`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/configs/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<QuerySuggestionsConfigurationResponse>(){});
    }

    public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(String indexName) throws AlgoliaRuntimeException {
        return this.getConfigAsync(indexName, null);
    }

    public GetConfigStatus200Response getConfigStatus(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigStatusAsync(indexName, requestOptions));
    }

    public GetConfigStatus200Response getConfigStatus(String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatus(indexName, null);
    }

    public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getConfigStatus`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/configs/{indexName}/status".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetConfigStatus200Response>(){});
    }

    public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatusAsync(indexName, null);
    }

    public GetLogFile200Response getLogFile(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLogFileAsync(indexName, requestOptions));
    }

    public GetLogFile200Response getLogFile(String indexName) throws AlgoliaRuntimeException {
        return this.getLogFile(indexName, null);
    }

    public CompletableFuture<GetLogFile200Response> getLogFileAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getLogFile`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/logs/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetLogFile200Response>(){});
    }

    public CompletableFuture<GetLogFile200Response> getLogFileAsync(String indexName) throws AlgoliaRuntimeException {
        return this.getLogFileAsync(indexName, null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public BaseResponse updateConfig(String indexName, QuerySuggestionsConfiguration querySuggestionsConfiguration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateConfigAsync(indexName, querySuggestionsConfiguration, requestOptions));
    }

    public BaseResponse updateConfig(String indexName, QuerySuggestionsConfiguration querySuggestionsConfiguration) throws AlgoliaRuntimeException {
        return this.updateConfig(indexName, querySuggestionsConfiguration, null);
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(String indexName, QuerySuggestionsConfiguration querySuggestionsConfiguration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `updateConfig`.");
        }
        if (querySuggestionsConfiguration == null) {
            throw new AlgoliaRuntimeException("Parameter `querySuggestionsConfiguration` is required when calling `updateConfig`.");
        }
        QuerySuggestionsConfiguration bodyObj = querySuggestionsConfiguration;
        String requestPath = "/1/configs/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(String indexName, QuerySuggestionsConfiguration querySuggestionsConfiguration) throws AlgoliaRuntimeException {
        return this.updateConfigAsync(indexName, querySuggestionsConfiguration, null);
    }
}

