/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.recommend.DeletedAtResponse;
import com.algolia.model.recommend.GetRecommendTaskResponse;
import com.algolia.model.recommend.GetRecommendationsParams;
import com.algolia.model.recommend.GetRecommendationsResponse;
import com.algolia.model.recommend.RecommendModels;
import com.algolia.model.recommend.RuleResponse;
import com.algolia.model.recommend.SearchRecommendRulesParams;
import com.algolia.model.recommend.SearchRecommendRulesResponse;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;

public class RecommendClient
extends ApiClient {
    public RecommendClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public RecommendClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Recommend", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(RecommendClient.getDefaultHosts(appId));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String appId) {
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        hosts.add(new StatefulHost(appId + "-dsn.algolia.net", "https", EnumSet.of(CallType.READ)));
        hosts.add(new StatefulHost(appId + ".algolia.net", "https", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new StatefulHost(appId + "-1.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-2.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-3.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public DeletedAtResponse deleteRecommendRule(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public DeletedAtResponse deleteRecommendRule(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteRecommendRule`.");
        }
        if (model == null) {
            throw new AlgoliaRuntimeException("Parameter `model` is required when calling `deleteRecommendRule`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `deleteRecommendRule`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{model\\}", this.escapeString(model.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public RuleResponse getRecommendRule(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public RuleResponse getRecommendRule(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<RuleResponse> getRecommendRuleAsync(String indexName, RecommendModels model, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getRecommendRule`.");
        }
        if (model == null) {
            throw new AlgoliaRuntimeException("Parameter `model` is required when calling `getRecommendRule`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `getRecommendRule`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{model\\}", this.escapeString(model.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<RuleResponse>(){});
    }

    public CompletableFuture<RuleResponse> getRecommendRuleAsync(String indexName, RecommendModels model, String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRuleAsync(indexName, model, objectID, null);
    }

    public GetRecommendTaskResponse getRecommendStatus(String indexName, RecommendModels model, Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendStatusAsync(indexName, model, taskID, requestOptions));
    }

    public GetRecommendTaskResponse getRecommendStatus(String indexName, RecommendModels model, Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatus(indexName, model, taskID, null);
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(String indexName, RecommendModels model, Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getRecommendStatus`.");
        }
        if (model == null) {
            throw new AlgoliaRuntimeException("Parameter `model` is required when calling `getRecommendStatus`.");
        }
        if (taskID == null) {
            throw new AlgoliaRuntimeException("Parameter `taskID` is required when calling `getRecommendStatus`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/{model}/task/{taskID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{model\\}", this.escapeString(model.toString())).replaceAll("\\{taskID\\}", this.escapeString(taskID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetRecommendTaskResponse>(){});
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(String indexName, RecommendModels model, Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatusAsync(indexName, model, taskID, null);
    }

    public GetRecommendationsResponse getRecommendations(GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendationsAsync(getRecommendationsParams, requestOptions));
    }

    public GetRecommendationsResponse getRecommendations(GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendations(getRecommendationsParams, null);
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (getRecommendationsParams == null) {
            throw new AlgoliaRuntimeException("Parameter `getRecommendationsParams` is required when calling `getRecommendations`.");
        }
        GetRecommendationsParams bodyObj = getRecommendationsParams;
        String requestPath = "/1/indexes/*/recommendations";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetRecommendationsResponse>(){});
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendationsAsync(getRecommendationsParams, null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
    }

    public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, requestOptions);
    }

    public SearchRecommendRulesResponse searchRecommendRules(String indexName, RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(String indexName, RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchRecommendRules`.");
        }
        if (model == null) {
            throw new AlgoliaRuntimeException("Parameter `model` is required when calling `searchRecommendRules`.");
        }
        Object bodyObj = searchRecommendRulesParams != null ? searchRecommendRulesParams : new Object();
        String requestPath = "/1/indexes/{indexName}/{model}/recommend/rules/search".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{model\\}", this.escapeString(model.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<SearchRecommendRulesResponse>(){});
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(String indexName, RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(String indexName, RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(String indexName, RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, null);
    }
}

