/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaRetryException;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.search.AddApiKeyResponse;
import com.algolia.model.search.ApiKey;
import com.algolia.model.search.AssignUserIdParams;
import com.algolia.model.search.AttributeToUpdate;
import com.algolia.model.search.BatchAssignUserIdsParams;
import com.algolia.model.search.BatchDictionaryEntriesParams;
import com.algolia.model.search.BatchParams;
import com.algolia.model.search.BatchResponse;
import com.algolia.model.search.BatchWriteParams;
import com.algolia.model.search.BrowseParams;
import com.algolia.model.search.BrowseParamsObject;
import com.algolia.model.search.BrowseResponse;
import com.algolia.model.search.CreatedAtResponse;
import com.algolia.model.search.DeleteApiKeyResponse;
import com.algolia.model.search.DeleteByParams;
import com.algolia.model.search.DeleteSourceResponse;
import com.algolia.model.search.DeletedAtResponse;
import com.algolia.model.search.DictionarySettingsParams;
import com.algolia.model.search.DictionaryType;
import com.algolia.model.search.GetApiKeyResponse;
import com.algolia.model.search.GetDictionarySettingsResponse;
import com.algolia.model.search.GetLogsResponse;
import com.algolia.model.search.GetObjectsParams;
import com.algolia.model.search.GetObjectsResponse;
import com.algolia.model.search.GetTaskResponse;
import com.algolia.model.search.GetTopUserIdsResponse;
import com.algolia.model.search.HasPendingMappingsResponse;
import com.algolia.model.search.IndexSettings;
import com.algolia.model.search.Languages;
import com.algolia.model.search.ListApiKeysResponse;
import com.algolia.model.search.ListClustersResponse;
import com.algolia.model.search.ListIndicesResponse;
import com.algolia.model.search.ListUserIdsResponse;
import com.algolia.model.search.LogType;
import com.algolia.model.search.MultipleBatchResponse;
import com.algolia.model.search.OperationIndexParams;
import com.algolia.model.search.RemoveUserIdResponse;
import com.algolia.model.search.ReplaceSourceResponse;
import com.algolia.model.search.Rule;
import com.algolia.model.search.SaveObjectResponse;
import com.algolia.model.search.SaveSynonymResponse;
import com.algolia.model.search.SearchDictionaryEntriesParams;
import com.algolia.model.search.SearchForFacetValuesRequest;
import com.algolia.model.search.SearchForFacetValuesResponse;
import com.algolia.model.search.SearchMethodParams;
import com.algolia.model.search.SearchParams;
import com.algolia.model.search.SearchResponse;
import com.algolia.model.search.SearchResponses;
import com.algolia.model.search.SearchRulesParams;
import com.algolia.model.search.SearchRulesResponse;
import com.algolia.model.search.SearchSynonymsParams;
import com.algolia.model.search.SearchSynonymsResponse;
import com.algolia.model.search.SearchUserIdsParams;
import com.algolia.model.search.SearchUserIdsResponse;
import com.algolia.model.search.Source;
import com.algolia.model.search.SynonymHit;
import com.algolia.model.search.SynonymType;
import com.algolia.model.search.TaskStatus;
import com.algolia.model.search.UpdateApiKeyResponse;
import com.algolia.model.search.UpdatedAtResponse;
import com.algolia.model.search.UpdatedAtWithObjectIdResponse;
import com.algolia.model.search.UpdatedRuleResponse;
import com.algolia.model.search.UserId;
import com.algolia.utils.AlgoliaIterableHelper;
import com.algolia.utils.ApiKeyOperation;
import com.algolia.utils.ClientOptions;
import com.algolia.utils.Holder;
import com.algolia.utils.RequestOptions;
import com.algolia.utils.TaskUtils;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;

public class SearchClient
extends ApiClient {
    public SearchClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public SearchClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Search", "4.0.0-beta.3", options);
        if (options != null && options.getHosts() != null) {
            this.setHosts(options.getHosts());
        } else {
            this.setHosts(SearchClient.getDefaultHosts(appId));
        }
        this.setConnectTimeout(2000);
        this.setReadTimeout(5000);
        this.setWriteTimeout(30000);
    }

    private static List<StatefulHost> getDefaultHosts(String appId) {
        ArrayList<StatefulHost> hosts = new ArrayList<StatefulHost>();
        hosts.add(new StatefulHost(appId + "-dsn.algolia.net", "https", EnumSet.of(CallType.READ)));
        hosts.add(new StatefulHost(appId + ".algolia.net", "https", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new StatefulHost(appId + "-1.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-2.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new StatefulHost(appId + "-3.algolianet.net", "https", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public AddApiKeyResponse addApiKey(ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addApiKeyAsync(apiKey, requestOptions));
    }

    public AddApiKeyResponse addApiKey(ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.addApiKey(apiKey, null);
    }

    public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (apiKey == null) {
            throw new AlgoliaRuntimeException("Parameter `apiKey` is required when calling `addApiKey`.");
        }
        ApiKey bodyObj = apiKey;
        String requestPath = "/1/keys";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<AddApiKeyResponse>(){});
    }

    public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.addApiKeyAsync(apiKey, null);
    }

    public UpdatedAtWithObjectIdResponse addOrUpdateObject(String indexName, String objectID, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addOrUpdateObjectAsync(indexName, objectID, body, requestOptions));
    }

    public UpdatedAtWithObjectIdResponse addOrUpdateObject(String indexName, String objectID, Object body) throws AlgoliaRuntimeException {
        return this.addOrUpdateObject(indexName, objectID, body, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(String indexName, String objectID, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `addOrUpdateObject`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `addOrUpdateObject`.");
        }
        if (body == null) {
            throw new AlgoliaRuntimeException("Parameter `body` is required when calling `addOrUpdateObject`.");
        }
        Object bodyObj = body;
        String requestPath = "/1/indexes/{indexName}/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtWithObjectIdResponse>(){});
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(String indexName, String objectID, Object body) throws AlgoliaRuntimeException {
        return this.addOrUpdateObjectAsync(indexName, objectID, body, null);
    }

    public CreatedAtResponse appendSource(Source source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.appendSourceAsync(source, requestOptions));
    }

    public CreatedAtResponse appendSource(Source source) throws AlgoliaRuntimeException {
        return this.appendSource(source, null);
    }

    public CompletableFuture<CreatedAtResponse> appendSourceAsync(Source source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (source == null) {
            throw new AlgoliaRuntimeException("Parameter `source` is required when calling `appendSource`.");
        }
        Source bodyObj = source;
        String requestPath = "/1/security/sources/append";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> appendSourceAsync(Source source) throws AlgoliaRuntimeException {
        return this.appendSourceAsync(source, null);
    }

    public CreatedAtResponse assignUserId(String xAlgoliaUserID, AssignUserIdParams assignUserIdParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, requestOptions));
    }

    public CreatedAtResponse assignUserId(String xAlgoliaUserID, AssignUserIdParams assignUserIdParams) throws AlgoliaRuntimeException {
        return this.assignUserId(xAlgoliaUserID, assignUserIdParams, null);
    }

    public CompletableFuture<CreatedAtResponse> assignUserIdAsync(String xAlgoliaUserID, AssignUserIdParams assignUserIdParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (xAlgoliaUserID == null) {
            throw new AlgoliaRuntimeException("Parameter `xAlgoliaUserID` is required when calling `assignUserId`.");
        }
        if (assignUserIdParams == null) {
            throw new AlgoliaRuntimeException("Parameter `assignUserIdParams` is required when calling `assignUserId`.");
        }
        AssignUserIdParams bodyObj = assignUserIdParams;
        String requestPath = "/1/clusters/mapping";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (xAlgoliaUserID != null) {
            headers.put("X-Algolia-User-ID", this.parameterToString(xAlgoliaUserID));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> assignUserIdAsync(String xAlgoliaUserID, AssignUserIdParams assignUserIdParams) throws AlgoliaRuntimeException {
        return this.assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, null);
    }

    public BatchResponse batch(String indexName, BatchWriteParams batchWriteParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchAsync(indexName, batchWriteParams, requestOptions));
    }

    public BatchResponse batch(String indexName, BatchWriteParams batchWriteParams) throws AlgoliaRuntimeException {
        return this.batch(indexName, batchWriteParams, null);
    }

    public CompletableFuture<BatchResponse> batchAsync(String indexName, BatchWriteParams batchWriteParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `batch`.");
        }
        if (batchWriteParams == null) {
            throw new AlgoliaRuntimeException("Parameter `batchWriteParams` is required when calling `batch`.");
        }
        BatchWriteParams bodyObj = batchWriteParams;
        String requestPath = "/1/indexes/{indexName}/batch".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<BatchResponse>(){});
    }

    public CompletableFuture<BatchResponse> batchAsync(String indexName, BatchWriteParams batchWriteParams) throws AlgoliaRuntimeException {
        return this.batchAsync(indexName, batchWriteParams, null);
    }

    public CreatedAtResponse batchAssignUserIds(String xAlgoliaUserID, BatchAssignUserIdsParams batchAssignUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, requestOptions));
    }

    public CreatedAtResponse batchAssignUserIds(String xAlgoliaUserID, BatchAssignUserIdsParams batchAssignUserIdsParams) throws AlgoliaRuntimeException {
        return this.batchAssignUserIds(xAlgoliaUserID, batchAssignUserIdsParams, null);
    }

    public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(String xAlgoliaUserID, BatchAssignUserIdsParams batchAssignUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (xAlgoliaUserID == null) {
            throw new AlgoliaRuntimeException("Parameter `xAlgoliaUserID` is required when calling `batchAssignUserIds`.");
        }
        if (batchAssignUserIdsParams == null) {
            throw new AlgoliaRuntimeException("Parameter `batchAssignUserIdsParams` is required when calling `batchAssignUserIds`.");
        }
        BatchAssignUserIdsParams bodyObj = batchAssignUserIdsParams;
        String requestPath = "/1/clusters/mapping/batch";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (xAlgoliaUserID != null) {
            headers.put("X-Algolia-User-ID", this.parameterToString(xAlgoliaUserID));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(String xAlgoliaUserID, BatchAssignUserIdsParams batchAssignUserIdsParams) throws AlgoliaRuntimeException {
        return this.batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, null);
    }

    public UpdatedAtResponse batchDictionaryEntries(DictionaryType dictionaryName, BatchDictionaryEntriesParams batchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, requestOptions));
    }

    public UpdatedAtResponse batchDictionaryEntries(DictionaryType dictionaryName, BatchDictionaryEntriesParams batchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.batchDictionaryEntries(dictionaryName, batchDictionaryEntriesParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(DictionaryType dictionaryName, BatchDictionaryEntriesParams batchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (dictionaryName == null) {
            throw new AlgoliaRuntimeException("Parameter `dictionaryName` is required when calling `batchDictionaryEntries`.");
        }
        if (batchDictionaryEntriesParams == null) {
            throw new AlgoliaRuntimeException("Parameter `batchDictionaryEntriesParams` is required when calling `batchDictionaryEntries`.");
        }
        BatchDictionaryEntriesParams bodyObj = batchDictionaryEntriesParams;
        String requestPath = "/1/dictionaries/{dictionaryName}/batch".replaceAll("\\{dictionaryName\\}", this.escapeString(dictionaryName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(DictionaryType dictionaryName, BatchDictionaryEntriesParams batchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, null);
    }

    public <T> BrowseResponse<T> browse(String indexName, BrowseParams browseParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.browseAsync(indexName, browseParams, innerType, requestOptions));
    }

    public <T> BrowseResponse<T> browse(String indexName, BrowseParams browseParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browse(indexName, browseParams, innerType, null);
    }

    public <T> BrowseResponse<T> browse(String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.browse(indexName, null, innerType, requestOptions);
    }

    public <T> BrowseResponse<T> browse(String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browse(indexName, null, innerType, null);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(String indexName, BrowseParams browseParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `browse`.");
        }
        Object bodyObj = browseParams != null ? browseParams : new Object();
        String requestPath = "/1/indexes/{indexName}/browse".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, BrowseResponse.class, innerType);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(String indexName, BrowseParams browseParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, browseParams, innerType, null);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, null, innerType, requestOptions);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, null, innerType, null);
    }

    public UpdatedAtResponse clearAllSynonyms(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearAllSynonymsAsync(indexName, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse clearAllSynonyms(String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearAllSynonyms(indexName, forwardToReplicas, null);
    }

    public UpdatedAtResponse clearAllSynonyms(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearAllSynonyms(indexName, null, requestOptions);
    }

    public UpdatedAtResponse clearAllSynonyms(String indexName) throws AlgoliaRuntimeException {
        return this.clearAllSynonyms(indexName, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `clearAllSynonyms`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/synonyms/clear".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearAllSynonymsAsync(indexName, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearAllSynonymsAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(String indexName) throws AlgoliaRuntimeException {
        return this.clearAllSynonymsAsync(indexName, null, null);
    }

    public UpdatedAtResponse clearObjects(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearObjectsAsync(indexName, requestOptions));
    }

    public UpdatedAtResponse clearObjects(String indexName) throws AlgoliaRuntimeException {
        return this.clearObjects(indexName, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `clearObjects`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/clear".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(String indexName) throws AlgoliaRuntimeException {
        return this.clearObjectsAsync(indexName, null);
    }

    public UpdatedAtResponse clearRules(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearRulesAsync(indexName, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse clearRules(String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, forwardToReplicas, null);
    }

    public UpdatedAtResponse clearRules(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, null, requestOptions);
    }

    public UpdatedAtResponse clearRules(String indexName) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `clearRules`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/rules/clear".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(String indexName) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, null, null);
    }

    public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public DeleteApiKeyResponse deleteApiKey(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteApiKeyAsync(key, requestOptions));
    }

    public DeleteApiKeyResponse deleteApiKey(String key) throws AlgoliaRuntimeException {
        return this.deleteApiKey(key, null);
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (key == null) {
            throw new AlgoliaRuntimeException("Parameter `key` is required when calling `deleteApiKey`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/keys/{key}".replaceAll("\\{key\\}", this.escapeString(key.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeleteApiKeyResponse>(){});
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(String key) throws AlgoliaRuntimeException {
        return this.deleteApiKeyAsync(key, null);
    }

    public DeletedAtResponse deleteBy(String indexName, DeleteByParams deleteByParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteByAsync(indexName, deleteByParams, requestOptions));
    }

    public DeletedAtResponse deleteBy(String indexName, DeleteByParams deleteByParams) throws AlgoliaRuntimeException {
        return this.deleteBy(indexName, deleteByParams, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteByAsync(String indexName, DeleteByParams deleteByParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteBy`.");
        }
        if (deleteByParams == null) {
            throw new AlgoliaRuntimeException("Parameter `deleteByParams` is required when calling `deleteBy`.");
        }
        DeleteByParams bodyObj = deleteByParams;
        String requestPath = "/1/indexes/{indexName}/deleteByQuery".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteByAsync(String indexName, DeleteByParams deleteByParams) throws AlgoliaRuntimeException {
        return this.deleteByAsync(indexName, deleteByParams, null);
    }

    public DeletedAtResponse deleteIndex(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteIndexAsync(indexName, requestOptions));
    }

    public DeletedAtResponse deleteIndex(String indexName) throws AlgoliaRuntimeException {
        return this.deleteIndex(indexName, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteIndexAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteIndex`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteIndexAsync(String indexName) throws AlgoliaRuntimeException {
        return this.deleteIndexAsync(indexName, null);
    }

    public DeletedAtResponse deleteObject(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteObjectAsync(indexName, objectID, requestOptions));
    }

    public DeletedAtResponse deleteObject(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteObject(indexName, objectID, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteObjectAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteObject`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `deleteObject`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteObjectAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteObjectAsync(indexName, objectID, null);
    }

    public UpdatedAtResponse deleteRule(String indexName, String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteRuleAsync(indexName, objectID, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse deleteRule(String indexName, String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, forwardToReplicas, null);
    }

    public UpdatedAtResponse deleteRule(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, null, requestOptions);
    }

    public UpdatedAtResponse deleteRule(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(String indexName, String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteRule`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `deleteRule`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(String indexName, String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, null, null);
    }

    public DeleteSourceResponse deleteSource(String source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteSourceAsync(source, requestOptions));
    }

    public DeleteSourceResponse deleteSource(String source) throws AlgoliaRuntimeException {
        return this.deleteSource(source, null);
    }

    public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(String source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (source == null) {
            throw new AlgoliaRuntimeException("Parameter `source` is required when calling `deleteSource`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/security/sources/{source}".replaceAll("\\{source\\}", this.escapeString(source.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeleteSourceResponse>(){});
    }

    public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(String source) throws AlgoliaRuntimeException {
        return this.deleteSourceAsync(source, null);
    }

    public DeletedAtResponse deleteSynonym(String indexName, String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteSynonymAsync(indexName, objectID, forwardToReplicas, requestOptions));
    }

    public DeletedAtResponse deleteSynonym(String indexName, String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, forwardToReplicas, null);
    }

    public DeletedAtResponse deleteSynonym(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, null, requestOptions);
    }

    public DeletedAtResponse deleteSynonym(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, null, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(String indexName, String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `deleteSynonym`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `deleteSynonym`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/synonyms/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(String indexName, String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, forwardToReplicas, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, null, null);
    }

    public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
        }
        Object bodyObj = null;
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public GetApiKeyResponse getApiKey(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getApiKeyAsync(key, requestOptions));
    }

    public GetApiKeyResponse getApiKey(String key) throws AlgoliaRuntimeException {
        return this.getApiKey(key, null);
    }

    public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (key == null) {
            throw new AlgoliaRuntimeException("Parameter `key` is required when calling `getApiKey`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/keys/{key}".replaceAll("\\{key\\}", this.escapeString(key.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetApiKeyResponse>(){});
    }

    public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(String key) throws AlgoliaRuntimeException {
        return this.getApiKeyAsync(key, null);
    }

    public Map<String, Languages> getDictionaryLanguages(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getDictionaryLanguagesAsync(requestOptions));
    }

    public Map<String, Languages> getDictionaryLanguages() throws AlgoliaRuntimeException {
        return this.getDictionaryLanguages(null);
    }

    public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/dictionaries/*/languages";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Map<String, Languages>>(){});
    }

    public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync() throws AlgoliaRuntimeException {
        return this.getDictionaryLanguagesAsync(null);
    }

    public GetDictionarySettingsResponse getDictionarySettings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getDictionarySettingsAsync(requestOptions));
    }

    public GetDictionarySettingsResponse getDictionarySettings() throws AlgoliaRuntimeException {
        return this.getDictionarySettings(null);
    }

    public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/dictionaries/*/settings";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetDictionarySettingsResponse>(){});
    }

    public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync() throws AlgoliaRuntimeException {
        return this.getDictionarySettingsAsync(null);
    }

    public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLogsAsync(offset, length, indexName, type, requestOptions));
    }

    public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type) throws AlgoliaRuntimeException {
        return this.getLogs(offset, length, indexName, type, null);
    }

    public GetLogsResponse getLogs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getLogs(null, null, null, null, requestOptions);
    }

    public GetLogsResponse getLogs() throws AlgoliaRuntimeException {
        return this.getLogs(null, null, null, null, null);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(Integer offset, Integer length, String indexName, LogType type, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/logs";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (offset != null) {
            queryParameters.put("offset", this.parameterToString(offset));
        }
        if (length != null) {
            queryParameters.put("length", this.parameterToString(length));
        }
        if (indexName != null) {
            queryParameters.put("indexName", this.parameterToString(indexName));
        }
        if (type != null) {
            queryParameters.put("type", this.parameterToString((Object)type));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetLogsResponse>(){});
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(Integer offset, Integer length, String indexName, LogType type) throws AlgoliaRuntimeException {
        return this.getLogsAsync(offset, length, indexName, type, null);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getLogsAsync(null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync() throws AlgoliaRuntimeException {
        return this.getLogsAsync(null, null, null, null, null);
    }

    public Map<String, String> getObject(String indexName, String objectID, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getObjectAsync(indexName, objectID, attributesToRetrieve, requestOptions));
    }

    public Map<String, String> getObject(String indexName, String objectID, List<String> attributesToRetrieve) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, attributesToRetrieve, null);
    }

    public Map<String, String> getObject(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, null, requestOptions);
    }

    public Map<String, String> getObject(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, null, null);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(String indexName, String objectID, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getObject`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `getObject`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (attributesToRetrieve != null) {
            queryParameters.put("attributesToRetrieve", this.parameterToString(attributesToRetrieve));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(String indexName, String objectID, List<String> attributesToRetrieve) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, attributesToRetrieve, null);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, null, null);
    }

    public <T> GetObjectsResponse<T> getObjects(GetObjectsParams getObjectsParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getObjectsAsync(getObjectsParams, innerType, requestOptions));
    }

    public <T> GetObjectsResponse<T> getObjects(GetObjectsParams getObjectsParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.getObjects(getObjectsParams, innerType, null);
    }

    public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(GetObjectsParams getObjectsParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (getObjectsParams == null) {
            throw new AlgoliaRuntimeException("Parameter `getObjectsParams` is required when calling `getObjects`.");
        }
        GetObjectsParams bodyObj = getObjectsParams;
        String requestPath = "/1/indexes/*/objects";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, GetObjectsResponse.class, innerType);
    }

    public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(GetObjectsParams getObjectsParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.getObjectsAsync(getObjectsParams, innerType, null);
    }

    public Rule getRule(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRuleAsync(indexName, objectID, requestOptions));
    }

    public Rule getRule(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getRule(indexName, objectID, null);
    }

    public CompletableFuture<Rule> getRuleAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getRule`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `getRule`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Rule>(){});
    }

    public CompletableFuture<Rule> getRuleAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getRuleAsync(indexName, objectID, null);
    }

    public IndexSettings getSettings(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSettingsAsync(indexName, requestOptions));
    }

    public IndexSettings getSettings(String indexName) throws AlgoliaRuntimeException {
        return this.getSettings(indexName, null);
    }

    public CompletableFuture<IndexSettings> getSettingsAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getSettings`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/settings".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<IndexSettings>(){});
    }

    public CompletableFuture<IndexSettings> getSettingsAsync(String indexName) throws AlgoliaRuntimeException {
        return this.getSettingsAsync(indexName, null);
    }

    public List<Source> getSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSourcesAsync(requestOptions));
    }

    public List<Source> getSources() throws AlgoliaRuntimeException {
        return this.getSources(null);
    }

    public CompletableFuture<List<Source>> getSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/security/sources";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<List<Source>>(){});
    }

    public CompletableFuture<List<Source>> getSourcesAsync() throws AlgoliaRuntimeException {
        return this.getSourcesAsync(null);
    }

    public SynonymHit getSynonym(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSynonymAsync(indexName, objectID, requestOptions));
    }

    public SynonymHit getSynonym(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getSynonym(indexName, objectID, null);
    }

    public CompletableFuture<SynonymHit> getSynonymAsync(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getSynonym`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `getSynonym`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/synonyms/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<SynonymHit>(){});
    }

    public CompletableFuture<SynonymHit> getSynonymAsync(String indexName, String objectID) throws AlgoliaRuntimeException {
        return this.getSynonymAsync(indexName, objectID, null);
    }

    public GetTaskResponse getTask(String indexName, Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTaskAsync(indexName, taskID, requestOptions));
    }

    public GetTaskResponse getTask(String indexName, Long taskID) throws AlgoliaRuntimeException {
        return this.getTask(indexName, taskID, null);
    }

    public CompletableFuture<GetTaskResponse> getTaskAsync(String indexName, Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `getTask`.");
        }
        if (taskID == null) {
            throw new AlgoliaRuntimeException("Parameter `taskID` is required when calling `getTask`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/indexes/{indexName}/task/{taskID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{taskID\\}", this.escapeString(taskID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTaskResponse>(){});
    }

    public CompletableFuture<GetTaskResponse> getTaskAsync(String indexName, Long taskID) throws AlgoliaRuntimeException {
        return this.getTaskAsync(indexName, taskID, null);
    }

    public GetTopUserIdsResponse getTopUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopUserIdsAsync(requestOptions));
    }

    public GetTopUserIdsResponse getTopUserIds() throws AlgoliaRuntimeException {
        return this.getTopUserIds(null);
    }

    public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/clusters/mapping/top";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<GetTopUserIdsResponse>(){});
    }

    public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync() throws AlgoliaRuntimeException {
        return this.getTopUserIdsAsync(null);
    }

    public UserId getUserId(String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUserIdAsync(userID, requestOptions));
    }

    public UserId getUserId(String userID) throws AlgoliaRuntimeException {
        return this.getUserId(userID, null);
    }

    public CompletableFuture<UserId> getUserIdAsync(String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (userID == null) {
            throw new AlgoliaRuntimeException("Parameter `userID` is required when calling `getUserId`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/clusters/mapping/{userID}".replaceAll("\\{userID\\}", this.escapeString(userID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UserId>(){});
    }

    public CompletableFuture<UserId> getUserIdAsync(String userID) throws AlgoliaRuntimeException {
        return this.getUserIdAsync(userID, null);
    }

    public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.hasPendingMappingsAsync(getClusters, requestOptions));
    }

    public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters) throws AlgoliaRuntimeException {
        return this.hasPendingMappings(getClusters, null);
    }

    public HasPendingMappingsResponse hasPendingMappings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.hasPendingMappings(null, requestOptions);
    }

    public HasPendingMappingsResponse hasPendingMappings() throws AlgoliaRuntimeException {
        return this.hasPendingMappings(null, null);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/clusters/mapping/pending";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (getClusters != null) {
            queryParameters.put("getClusters", this.parameterToString(getClusters));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<HasPendingMappingsResponse>(){});
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters) throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(getClusters, null);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(null, requestOptions);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync() throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(null, null);
    }

    public ListApiKeysResponse listApiKeys(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listApiKeysAsync(requestOptions));
    }

    public ListApiKeysResponse listApiKeys() throws AlgoliaRuntimeException {
        return this.listApiKeys(null);
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeysAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/keys";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ListApiKeysResponse>(){});
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeysAsync() throws AlgoliaRuntimeException {
        return this.listApiKeysAsync(null);
    }

    public ListClustersResponse listClusters(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listClustersAsync(requestOptions));
    }

    public ListClustersResponse listClusters() throws AlgoliaRuntimeException {
        return this.listClusters(null);
    }

    public CompletableFuture<ListClustersResponse> listClustersAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/clusters";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ListClustersResponse>(){});
    }

    public CompletableFuture<ListClustersResponse> listClustersAsync() throws AlgoliaRuntimeException {
        return this.listClustersAsync(null);
    }

    public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listIndicesAsync(page, hitsPerPage, requestOptions));
    }

    public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listIndices(page, hitsPerPage, null);
    }

    public ListIndicesResponse listIndices(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listIndices(null, null, requestOptions);
    }

    public ListIndicesResponse listIndices() throws AlgoliaRuntimeException {
        return this.listIndices(null, null, null);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/indexes";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (page != null) {
            queryParameters.put("page", this.parameterToString(page));
        }
        if (hitsPerPage != null) {
            queryParameters.put("hitsPerPage", this.parameterToString(hitsPerPage));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ListIndicesResponse>(){});
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listIndicesAsync(page, hitsPerPage, null);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listIndicesAsync(null, null, requestOptions);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync() throws AlgoliaRuntimeException {
        return this.listIndicesAsync(null, null, null);
    }

    public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listUserIdsAsync(page, hitsPerPage, requestOptions));
    }

    public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listUserIds(page, hitsPerPage, null);
    }

    public ListUserIdsResponse listUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listUserIds(null, null, requestOptions);
    }

    public ListUserIdsResponse listUserIds() throws AlgoliaRuntimeException {
        return this.listUserIds(null, null, null);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Object bodyObj = null;
        String requestPath = "/1/clusters/mapping";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (page != null) {
            queryParameters.put("page", this.parameterToString(page));
        }
        if (hitsPerPage != null) {
            queryParameters.put("hitsPerPage", this.parameterToString(hitsPerPage));
        }
        Call call = this.buildCall(requestPath, "GET", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ListUserIdsResponse>(){});
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(page, hitsPerPage, null);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(null, null, requestOptions);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync() throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(null, null, null);
    }

    public MultipleBatchResponse multipleBatch(BatchParams batchParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.multipleBatchAsync(batchParams, requestOptions));
    }

    public MultipleBatchResponse multipleBatch(BatchParams batchParams) throws AlgoliaRuntimeException {
        return this.multipleBatch(batchParams, null);
    }

    public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(BatchParams batchParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (batchParams == null) {
            throw new AlgoliaRuntimeException("Parameter `batchParams` is required when calling `multipleBatch`.");
        }
        BatchParams bodyObj = batchParams;
        String requestPath = "/1/indexes/*/batch";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<MultipleBatchResponse>(){});
    }

    public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(BatchParams batchParams) throws AlgoliaRuntimeException {
        return this.multipleBatchAsync(batchParams, null);
    }

    public UpdatedAtResponse operationIndex(String indexName, OperationIndexParams operationIndexParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.operationIndexAsync(indexName, operationIndexParams, requestOptions));
    }

    public UpdatedAtResponse operationIndex(String indexName, OperationIndexParams operationIndexParams) throws AlgoliaRuntimeException {
        return this.operationIndex(indexName, operationIndexParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> operationIndexAsync(String indexName, OperationIndexParams operationIndexParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `operationIndex`.");
        }
        if (operationIndexParams == null) {
            throw new AlgoliaRuntimeException("Parameter `operationIndexParams` is required when calling `operationIndex`.");
        }
        OperationIndexParams bodyObj = operationIndexParams;
        String requestPath = "/1/indexes/{indexName}/operation".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> operationIndexAsync(String indexName, OperationIndexParams operationIndexParams) throws AlgoliaRuntimeException {
        return this.operationIndexAsync(indexName, operationIndexParams, null);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, requestOptions));
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, createIfNotExists, null);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, requestOptions);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `partialUpdateObject`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `partialUpdateObject`.");
        }
        if (attributesToUpdate == null) {
            throw new AlgoliaRuntimeException("Parameter `attributesToUpdate` is required when calling `partialUpdateObject`.");
        }
        Map<String, AttributeToUpdate> bodyObj = attributesToUpdate;
        String requestPath = "/1/indexes/{indexName}/{objectID}/partial".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (createIfNotExists != null) {
            queryParameters.put("createIfNotExists", this.parameterToString(createIfNotExists));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtWithObjectIdResponse>(){});
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(String indexName, String objectID, Map<String, AttributeToUpdate> attributesToUpdate) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, null);
    }

    public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (path == null) {
            throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
        }
        Object bodyObj = body != null ? body : new Object();
        String requestPath = "/1{path}".replaceAll("\\{path\\}", path.toString());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryParameters.put(parameter.getKey().toString(), this.parameterToString(parameter.getValue()));
            }
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public RemoveUserIdResponse removeUserId(String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.removeUserIdAsync(userID, requestOptions));
    }

    public RemoveUserIdResponse removeUserId(String userID) throws AlgoliaRuntimeException {
        return this.removeUserId(userID, null);
    }

    public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (userID == null) {
            throw new AlgoliaRuntimeException("Parameter `userID` is required when calling `removeUserId`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/clusters/mapping/{userID}".replaceAll("\\{userID\\}", this.escapeString(userID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "DELETE", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<RemoveUserIdResponse>(){});
    }

    public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(String userID) throws AlgoliaRuntimeException {
        return this.removeUserIdAsync(userID, null);
    }

    public ReplaceSourceResponse replaceSources(List<Source> source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.replaceSourcesAsync(source, requestOptions));
    }

    public ReplaceSourceResponse replaceSources(List<Source> source) throws AlgoliaRuntimeException {
        return this.replaceSources(source, null);
    }

    public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(List<Source> source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (source == null) {
            throw new AlgoliaRuntimeException("Parameter `source` is required when calling `replaceSources`.");
        }
        List<Source> bodyObj = source;
        String requestPath = "/1/security/sources";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<ReplaceSourceResponse>(){});
    }

    public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(List<Source> source) throws AlgoliaRuntimeException {
        return this.replaceSourcesAsync(source, null);
    }

    public AddApiKeyResponse restoreApiKey(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.restoreApiKeyAsync(key, requestOptions));
    }

    public AddApiKeyResponse restoreApiKey(String key) throws AlgoliaRuntimeException {
        return this.restoreApiKey(key, null);
    }

    public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (key == null) {
            throw new AlgoliaRuntimeException("Parameter `key` is required when calling `restoreApiKey`.");
        }
        Object bodyObj = null;
        String requestPath = "/1/keys/{key}/restore".replaceAll("\\{key\\}", this.escapeString(key.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<AddApiKeyResponse>(){});
    }

    public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(String key) throws AlgoliaRuntimeException {
        return this.restoreApiKeyAsync(key, null);
    }

    public SaveObjectResponse saveObject(String indexName, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveObjectAsync(indexName, body, requestOptions));
    }

    public SaveObjectResponse saveObject(String indexName, Object body) throws AlgoliaRuntimeException {
        return this.saveObject(indexName, body, null);
    }

    public CompletableFuture<SaveObjectResponse> saveObjectAsync(String indexName, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `saveObject`.");
        }
        if (body == null) {
            throw new AlgoliaRuntimeException("Parameter `body` is required when calling `saveObject`.");
        }
        Object bodyObj = body;
        String requestPath = "/1/indexes/{indexName}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<SaveObjectResponse>(){});
    }

    public CompletableFuture<SaveObjectResponse> saveObjectAsync(String indexName, Object body) throws AlgoliaRuntimeException {
        return this.saveObjectAsync(indexName, body, null);
    }

    public UpdatedRuleResponse saveRule(String indexName, String objectID, Rule rule, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveRuleAsync(indexName, objectID, rule, forwardToReplicas, requestOptions));
    }

    public UpdatedRuleResponse saveRule(String indexName, String objectID, Rule rule, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, forwardToReplicas, null);
    }

    public UpdatedRuleResponse saveRule(String indexName, String objectID, Rule rule, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, null, requestOptions);
    }

    public UpdatedRuleResponse saveRule(String indexName, String objectID, Rule rule) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, null, null);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(String indexName, String objectID, Rule rule, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `saveRule`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `saveRule`.");
        }
        if (rule == null) {
            throw new AlgoliaRuntimeException("Parameter `rule` is required when calling `saveRule`.");
        }
        Rule bodyObj = rule;
        String requestPath = "/1/indexes/{indexName}/rules/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedRuleResponse>(){});
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(String indexName, String objectID, Rule rule, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(String indexName, String objectID, Rule rule, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, null, requestOptions);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(String indexName, String objectID, Rule rule) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, null, null);
    }

    public UpdatedAtResponse saveRules(String indexName, List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, requestOptions));
    }

    public UpdatedAtResponse saveRules(String indexName, List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, forwardToReplicas, clearExistingRules, null);
    }

    public UpdatedAtResponse saveRules(String indexName, List<Rule> rules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, null, null, requestOptions);
    }

    public UpdatedAtResponse saveRules(String indexName, List<Rule> rules) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, null, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(String indexName, List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `saveRules`.");
        }
        if (rules == null) {
            throw new AlgoliaRuntimeException("Parameter `rules` is required when calling `saveRules`.");
        }
        List<Rule> bodyObj = rules;
        String requestPath = "/1/indexes/{indexName}/rules/batch".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        if (clearExistingRules != null) {
            queryParameters.put("clearExistingRules", this.parameterToString(clearExistingRules));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(String indexName, List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(String indexName, List<Rule> rules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, null, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(String indexName, List<Rule> rules) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, null, null, null);
    }

    public SaveSynonymResponse saveSynonym(String indexName, String objectID, SynonymHit synonymHit, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, requestOptions));
    }

    public SaveSynonymResponse saveSynonym(String indexName, String objectID, SynonymHit synonymHit, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, forwardToReplicas, null);
    }

    public SaveSynonymResponse saveSynonym(String indexName, String objectID, SynonymHit synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, null, requestOptions);
    }

    public SaveSynonymResponse saveSynonym(String indexName, String objectID, SynonymHit synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, null, null);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(String indexName, String objectID, SynonymHit synonymHit, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `saveSynonym`.");
        }
        if (objectID == null) {
            throw new AlgoliaRuntimeException("Parameter `objectID` is required when calling `saveSynonym`.");
        }
        if (synonymHit == null) {
            throw new AlgoliaRuntimeException("Parameter `synonymHit` is required when calling `saveSynonym`.");
        }
        SynonymHit bodyObj = synonymHit;
        String requestPath = "/1/indexes/{indexName}/synonyms/{objectID}".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{objectID\\}", this.escapeString(objectID.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<SaveSynonymResponse>(){});
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(String indexName, String objectID, SynonymHit synonymHit, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, null);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(String indexName, String objectID, SynonymHit synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, null, requestOptions);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(String indexName, String objectID, SynonymHit synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, null, null);
    }

    public UpdatedAtResponse saveSynonyms(String indexName, List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, requestOptions));
    }

    public UpdatedAtResponse saveSynonyms(String indexName, List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
    }

    public UpdatedAtResponse saveSynonyms(String indexName, List<SynonymHit> synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, null, null, requestOptions);
    }

    public UpdatedAtResponse saveSynonyms(String indexName, List<SynonymHit> synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, null, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(String indexName, List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `saveSynonyms`.");
        }
        if (synonymHit == null) {
            throw new AlgoliaRuntimeException("Parameter `synonymHit` is required when calling `saveSynonyms`.");
        }
        List<SynonymHit> bodyObj = synonymHit;
        String requestPath = "/1/indexes/{indexName}/synonyms/batch".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        if (replaceExistingSynonyms != null) {
            queryParameters.put("replaceExistingSynonyms", this.parameterToString(replaceExistingSynonyms));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(String indexName, List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(String indexName, List<SynonymHit> synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, null, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(String indexName, List<SynonymHit> synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, null, null, null);
    }

    public <T> SearchResponses<T> search(SearchMethodParams searchMethodParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchAsync(searchMethodParams, innerType, requestOptions));
    }

    public <T> SearchResponses<T> search(SearchMethodParams searchMethodParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.search(searchMethodParams, innerType, null);
    }

    public <T> CompletableFuture<SearchResponses<T>> searchAsync(SearchMethodParams searchMethodParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (searchMethodParams == null) {
            throw new AlgoliaRuntimeException("Parameter `searchMethodParams` is required when calling `search`.");
        }
        SearchMethodParams bodyObj = searchMethodParams;
        String requestPath = "/1/indexes/*/queries";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, SearchResponses.class, innerType);
    }

    public <T> CompletableFuture<SearchResponses<T>> searchAsync(SearchMethodParams searchMethodParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchAsync(searchMethodParams, innerType, null);
    }

    public UpdatedAtResponse searchDictionaryEntries(DictionaryType dictionaryName, SearchDictionaryEntriesParams searchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, requestOptions));
    }

    public UpdatedAtResponse searchDictionaryEntries(DictionaryType dictionaryName, SearchDictionaryEntriesParams searchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.searchDictionaryEntries(dictionaryName, searchDictionaryEntriesParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> searchDictionaryEntriesAsync(DictionaryType dictionaryName, SearchDictionaryEntriesParams searchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (dictionaryName == null) {
            throw new AlgoliaRuntimeException("Parameter `dictionaryName` is required when calling `searchDictionaryEntries`.");
        }
        if (searchDictionaryEntriesParams == null) {
            throw new AlgoliaRuntimeException("Parameter `searchDictionaryEntriesParams` is required when calling `searchDictionaryEntries`.");
        }
        SearchDictionaryEntriesParams bodyObj = searchDictionaryEntriesParams;
        String requestPath = "/1/dictionaries/{dictionaryName}/search".replaceAll("\\{dictionaryName\\}", this.escapeString(dictionaryName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> searchDictionaryEntriesAsync(DictionaryType dictionaryName, SearchDictionaryEntriesParams searchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(String indexName, String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, requestOptions));
    }

    public SearchForFacetValuesResponse searchForFacetValues(String indexName, String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, searchForFacetValuesRequest, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(String indexName, String facetName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, null, requestOptions);
    }

    public SearchForFacetValuesResponse searchForFacetValues(String indexName, String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, null, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(String indexName, String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchForFacetValues`.");
        }
        if (facetName == null) {
            throw new AlgoliaRuntimeException("Parameter `facetName` is required when calling `searchForFacetValues`.");
        }
        Object bodyObj = searchForFacetValuesRequest != null ? searchForFacetValuesRequest : new Object();
        String requestPath = "/1/indexes/{indexName}/facets/{facetName}/query".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString())).replaceAll("\\{facetName\\}", this.escapeString(facetName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<SearchForFacetValuesResponse>(){});
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(String indexName, String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(String indexName, String facetName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, null, requestOptions);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(String indexName, String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, null, null);
    }

    public SearchRulesResponse searchRules(String indexName, SearchRulesParams searchRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchRulesAsync(indexName, searchRulesParams, requestOptions));
    }

    public SearchRulesResponse searchRules(String indexName, SearchRulesParams searchRulesParams) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, searchRulesParams, null);
    }

    public SearchRulesResponse searchRules(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, null, requestOptions);
    }

    public SearchRulesResponse searchRules(String indexName) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, null, null);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(String indexName, SearchRulesParams searchRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchRules`.");
        }
        Object bodyObj = searchRulesParams != null ? searchRulesParams : new Object();
        String requestPath = "/1/indexes/{indexName}/rules/search".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<SearchRulesResponse>(){});
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(String indexName, SearchRulesParams searchRulesParams) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, searchRulesParams, null);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(String indexName) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, null, null);
    }

    public <T> SearchResponse<T> searchSingleIndex(String indexName, SearchParams searchParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchSingleIndexAsync(indexName, searchParams, innerType, requestOptions));
    }

    public <T> SearchResponse<T> searchSingleIndex(String indexName, SearchParams searchParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, searchParams, innerType, null);
    }

    public <T> SearchResponse<T> searchSingleIndex(String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, null, innerType, requestOptions);
    }

    public <T> SearchResponse<T> searchSingleIndex(String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, null, innerType, null);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(String indexName, SearchParams searchParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchSingleIndex`.");
        }
        Object bodyObj = searchParams != null ? searchParams : new Object();
        String requestPath = "/1/indexes/{indexName}/query".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, SearchResponse.class, innerType);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(String indexName, SearchParams searchParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, searchParams, innerType, null);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, null, innerType, requestOptions);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, null, innerType, null);
    }

    public SearchSynonymsResponse searchSynonyms(String indexName, SynonymType type, Integer page, Integer hitsPerPage, SearchSynonymsParams searchSynonymsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchSynonymsAsync(indexName, type, page, hitsPerPage, searchSynonymsParams, requestOptions));
    }

    public SearchSynonymsResponse searchSynonyms(String indexName, SynonymType type, Integer page, Integer hitsPerPage, SearchSynonymsParams searchSynonymsParams) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, type, page, hitsPerPage, searchSynonymsParams, null);
    }

    public SearchSynonymsResponse searchSynonyms(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, null, null, null, null, requestOptions);
    }

    public SearchSynonymsResponse searchSynonyms(String indexName) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, null, null, null, null, null);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(String indexName, SynonymType type, Integer page, Integer hitsPerPage, SearchSynonymsParams searchSynonymsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `searchSynonyms`.");
        }
        Object bodyObj = searchSynonymsParams != null ? searchSynonymsParams : new Object();
        String requestPath = "/1/indexes/{indexName}/synonyms/search".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (type != null) {
            queryParameters.put("type", this.parameterToString((Object)type));
        }
        if (page != null) {
            queryParameters.put("page", this.parameterToString(page));
        }
        if (hitsPerPage != null) {
            queryParameters.put("hitsPerPage", this.parameterToString(hitsPerPage));
        }
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<SearchSynonymsResponse>(){});
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(String indexName, SynonymType type, Integer page, Integer hitsPerPage, SearchSynonymsParams searchSynonymsParams) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, type, page, hitsPerPage, searchSynonymsParams, null);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, null, null, null, null, requestOptions);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(String indexName) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, null, null, null, null, null);
    }

    public SearchUserIdsResponse searchUserIds(SearchUserIdsParams searchUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchUserIdsAsync(searchUserIdsParams, requestOptions));
    }

    public SearchUserIdsResponse searchUserIds(SearchUserIdsParams searchUserIdsParams) throws AlgoliaRuntimeException {
        return this.searchUserIds(searchUserIdsParams, null);
    }

    public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(SearchUserIdsParams searchUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (searchUserIdsParams == null) {
            throw new AlgoliaRuntimeException("Parameter `searchUserIdsParams` is required when calling `searchUserIds`.");
        }
        SearchUserIdsParams bodyObj = searchUserIdsParams;
        String requestPath = "/1/clusters/mapping/search";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "POST", queryParameters, bodyObj, headers, requestOptions, true);
        return this.executeAsync(call, (TypeReference)new TypeReference<SearchUserIdsResponse>(){});
    }

    public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(SearchUserIdsParams searchUserIdsParams) throws AlgoliaRuntimeException {
        return this.searchUserIdsAsync(searchUserIdsParams, null);
    }

    public UpdatedAtResponse setDictionarySettings(DictionarySettingsParams dictionarySettingsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setDictionarySettingsAsync(dictionarySettingsParams, requestOptions));
    }

    public UpdatedAtResponse setDictionarySettings(DictionarySettingsParams dictionarySettingsParams) throws AlgoliaRuntimeException {
        return this.setDictionarySettings(dictionarySettingsParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(DictionarySettingsParams dictionarySettingsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (dictionarySettingsParams == null) {
            throw new AlgoliaRuntimeException("Parameter `dictionarySettingsParams` is required when calling `setDictionarySettings`.");
        }
        DictionarySettingsParams bodyObj = dictionarySettingsParams;
        String requestPath = "/1/dictionaries/*/settings";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(DictionarySettingsParams dictionarySettingsParams) throws AlgoliaRuntimeException {
        return this.setDictionarySettingsAsync(dictionarySettingsParams, null);
    }

    public UpdatedAtResponse setSettings(String indexName, IndexSettings indexSettings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setSettingsAsync(indexName, indexSettings, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse setSettings(String indexName, IndexSettings indexSettings, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, forwardToReplicas, null);
    }

    public UpdatedAtResponse setSettings(String indexName, IndexSettings indexSettings, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, null, requestOptions);
    }

    public UpdatedAtResponse setSettings(String indexName, IndexSettings indexSettings) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(String indexName, IndexSettings indexSettings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (indexName == null) {
            throw new AlgoliaRuntimeException("Parameter `indexName` is required when calling `setSettings`.");
        }
        if (indexSettings == null) {
            throw new AlgoliaRuntimeException("Parameter `indexSettings` is required when calling `setSettings`.");
        }
        IndexSettings bodyObj = indexSettings;
        String requestPath = "/1/indexes/{indexName}/settings".replaceAll("\\{indexName\\}", this.escapeString(indexName.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (forwardToReplicas != null) {
            queryParameters.put("forwardToReplicas", this.parameterToString(forwardToReplicas));
        }
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(String indexName, IndexSettings indexSettings, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(String indexName, IndexSettings indexSettings, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(String indexName, IndexSettings indexSettings) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, null, null);
    }

    public UpdateApiKeyResponse updateApiKey(String key, ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateApiKeyAsync(key, apiKey, requestOptions));
    }

    public UpdateApiKeyResponse updateApiKey(String key, ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.updateApiKey(key, apiKey, null);
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(String key, ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        if (key == null) {
            throw new AlgoliaRuntimeException("Parameter `key` is required when calling `updateApiKey`.");
        }
        if (apiKey == null) {
            throw new AlgoliaRuntimeException("Parameter `apiKey` is required when calling `updateApiKey`.");
        }
        ApiKey bodyObj = apiKey;
        String requestPath = "/1/keys/{key}".replaceAll("\\{key\\}", this.escapeString(key.toString()));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        Call call = this.buildCall(requestPath, "PUT", queryParameters, bodyObj, headers, requestOptions, false);
        return this.executeAsync(call, (TypeReference)new TypeReference<UpdateApiKeyResponse>(){});
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(String key, ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.updateApiKeyAsync(key, apiKey, null);
    }

    public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        TaskUtils.retryUntil(() -> this.getTask(indexName, taskID, requestOptions), task -> task.getStatus() == TaskStatus.PUBLISHED, maxRetries, timeout);
    }

    public void waitForTask(String indexName, Long taskID, RequestOptions requestOptions) {
        this.waitForTask(indexName, taskID, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout) {
        this.waitForTask(indexName, taskID, maxRetries, timeout, null);
    }

    public void waitForTask(String indexName, Long taskID) {
        this.waitForTask(indexName, taskID, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        if (operation == ApiKeyOperation.UPDATE) {
            if (apiKey == null) {
                throw new AlgoliaRetryException("`apiKey` is required when waiting for an `update` operation.");
            }
            return TaskUtils.retryUntil(() -> this.getApiKey(key, requestOptions), respKey -> {
                ApiKey sameType = new ApiKey().setAcl(respKey.getAcl()).setDescription(respKey.getDescription()).setIndexes(respKey.getIndexes()).setMaxHitsPerQuery(respKey.getMaxHitsPerQuery()).setMaxQueriesPerIPPerHour(respKey.getMaxQueriesPerIPPerHour()).setQueryParameters(respKey.getQueryParameters()).setReferers(respKey.getReferers()).setValidity(respKey.getValidity());
                return apiKey.equals(sameType);
            }, maxRetries, timeout);
        }
        GetApiKeyResponse[] addedKey = new GetApiKeyResponse[]{null};
        TaskUtils.retryUntil(() -> {
            try {
                addedKey[0] = this.getApiKey(key, requestOptions);
                return -2;
            }
            catch (AlgoliaApiException e) {
                return e.getHttpErrorCode();
            }
        }, status -> {
            switch (operation) {
                case ADD: {
                    return status == -2 || status != 404;
                }
                case DELETE: {
                    return status == 404;
                }
            }
            return false;
        }, maxRetries, timeout);
        return addedKey[0];
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, null, maxRetries, timeout, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, apiKey, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, null, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, int maxRetries, IntUnaryOperator timeout) {
        return this.waitForApiKey(operation, key, apiKey, maxRetries, timeout, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, int maxRetries, IntUnaryOperator timeout) {
        return this.waitForApiKey(operation, key, null, maxRetries, timeout, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey) {
        return this.waitForApiKey(operation, key, apiKey, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key) {
        return this.waitForApiKey(operation, key, null, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType, RequestOptions requestOptions) {
        Holder currentCursor = new Holder();
        return AlgoliaIterableHelper.createIterable(() -> {
            BrowseResponse response = this.browse(indexName, BrowseParams.of(params), innerType, requestOptions);
            params.setCursor(response.getCursor());
            currentCursor.value = response.getCursor();
            return response.getHits().iterator();
        }, () -> currentCursor.value != null);
    }

    public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType) {
        return this.browseObjects(indexName, params, innerType, null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName, SynonymType type, SearchSynonymsParams params, RequestOptions requestOptions) {
        Holder<Integer> currentPage = new Holder<Integer>(0);
        int hitsPerPage = 1000;
        return AlgoliaIterableHelper.createIterable(() -> {
            SearchSynonymsResponse response = this.searchSynonyms(indexName, type, (Integer)currentPage.value, 1000, params, requestOptions);
            currentPage.value = response.getNbHits() < 1000 ? null : Integer.valueOf((Integer)currentPage.value + 1);
            return response.getHits().iterator();
        }, () -> currentPage.value != null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName, SynonymType type, SearchSynonymsParams params) {
        return this.browseSynonyms(indexName, type, params, null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName) {
        return this.browseSynonyms(indexName, null, null, null);
    }

    public Iterable<Rule> browseRules(String indexName, SearchRulesParams params, RequestOptions requestOptions) {
        Holder<Integer> currentPage = new Holder<Integer>(0);
        int hitsPerPage = 1000;
        params.setHitsPerPage(1000);
        return AlgoliaIterableHelper.createIterable(() -> {
            SearchRulesResponse response = this.searchRules(indexName, params.setPage((Integer)currentPage.value), requestOptions);
            currentPage.value = response.getNbHits() < 1000 ? null : Integer.valueOf((Integer)currentPage.value + 1);
            return response.getHits().iterator();
        }, () -> currentPage.value != null);
    }

    public Iterable<Rule> browseRules(String indexName, SearchRulesParams params) {
        return this.browseRules(indexName, params, null);
    }

    public Iterable<Rule> browseRules(String indexName) {
        return this.browseRules(indexName, null, null);
    }

    public CompletableFuture<SearchResponses<Object>> searchAsync(SearchMethodParams searchMethodParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchAsync(searchMethodParams, Object.class, requestOptions);
    }

    public CompletableFuture<SearchResponses<Object>> searchAsync(SearchMethodParams searchMethodParams) throws AlgoliaRuntimeException {
        return this.searchAsync(searchMethodParams, Object.class, null);
    }

    public SearchResponses<Object> search(SearchMethodParams searchMethodParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.search(searchMethodParams, Object.class, requestOptions);
    }

    public SearchResponses<Object> search(SearchMethodParams searchMethodParams) throws AlgoliaRuntimeException {
        return this.search(searchMethodParams, Object.class, null);
    }
}

