/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.exceptions;

import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaRetryException;
import com.algolia.exceptions.AlgoliaRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class LaunderThrowable {
    public static <T> T await(CompletableFuture<T> f) {
        try {
            return f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw LaunderThrowable.launder(e);
        }
    }

    public static RuntimeException launder(Throwable t) {
        if (t.getCause() instanceof AlgoliaApiException) {
            throw (AlgoliaApiException)t.getCause();
        }
        if (t.getCause() instanceof AlgoliaRetryException) {
            throw (AlgoliaRetryException)t.getCause();
        }
        if (t.getCause() instanceof AlgoliaRuntimeException) {
            throw (AlgoliaRuntimeException)t.getCause();
        }
        throw new AlgoliaRuntimeException(t);
    }
}

