/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.querysuggestions;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.querysuggestions.LanguagesBoolean;
import com.algolia.model.querysuggestions.LanguagesListOfString;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=LanguagesDeserializer.class)
@JsonSerialize(using=LanguagesSerializer.class)
public abstract class Languages
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(Languages.class.getName());

    public static Languages of(Boolean inside) {
        return new LanguagesBoolean(inside);
    }

    public static Languages of(List<String> inside) {
        return new LanguagesListOfString(inside);
    }

    public static class LanguagesDeserializer
    extends StdDeserializer<Languages> {
        public LanguagesDeserializer() {
            this(Languages.class);
        }

        public LanguagesDeserializer(Class<?> vc) {
            super(vc);
        }

        public Languages deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isValueNode()) {
                Languages languages;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Boolean value = (Boolean)parser.readValueAs((TypeReference)new TypeReference<Boolean>(){});
                        languages = Languages.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
                        }
                    }
                    parser.close();
                }
                return languages;
            }
            if (tree.isArray()) {
                Languages languages;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<String>>(){});
                        languages = Languages.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
                        }
                    }
                    parser.close();
                }
                return languages;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public Languages getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "Languages cannot be null");
        }
    }

    public static class LanguagesSerializer
    extends StdSerializer<Languages> {
        public LanguagesSerializer(Class<Languages> t) {
            super(t);
        }

        public LanguagesSerializer() {
            this(null);
        }

        public void serialize(Languages value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

