/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.DistinctBoolean;
import com.algolia.model.recommend.DistinctInteger;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=DistinctDeserializer.class)
@JsonSerialize(using=DistinctSerializer.class)
public abstract class Distinct
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(Distinct.class.getName());

    public static Distinct of(Boolean inside) {
        return new DistinctBoolean(inside);
    }

    public static Distinct of(Integer inside) {
        return new DistinctInteger(inside);
    }

    public static class DistinctDeserializer
    extends StdDeserializer<Distinct> {
        public DistinctDeserializer() {
            this(Distinct.class);
        }

        public DistinctDeserializer(Class<?> vc) {
            super(vc);
        }

        public Distinct deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isValueNode()) {
                Distinct distinct;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Boolean value = (Boolean)parser.readValueAs((TypeReference)new TypeReference<Boolean>(){});
                        distinct = Distinct.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
                        }
                    }
                    parser.close();
                }
                return distinct;
            }
            if (tree.isValueNode()) {
                Distinct distinct;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Integer value = (Integer)parser.readValueAs((TypeReference)new TypeReference<Integer>(){});
                        distinct = Distinct.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
                        }
                    }
                    parser.close();
                }
                return distinct;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public Distinct getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "Distinct cannot be null");
        }
    }

    public static class DistinctSerializer
    extends StdSerializer<Distinct> {
        public DistinctSerializer(Class<Distinct> t) {
            super(t);
        }

        public DistinctSerializer() {
            this(null);
        }

        public void serialize(Distinct value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

