/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.MixedSearchFilters;
import com.algolia.model.recommend.OptionalFiltersListOfMixedSearchFilters;
import com.algolia.model.recommend.OptionalFiltersString;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=OptionalFiltersDeserializer.class)
@JsonSerialize(using=OptionalFiltersSerializer.class)
public abstract class OptionalFilters
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(OptionalFilters.class.getName());

    public static OptionalFilters of(List<MixedSearchFilters> inside) {
        return new OptionalFiltersListOfMixedSearchFilters(inside);
    }

    public static OptionalFilters of(String inside) {
        return new OptionalFiltersString(inside);
    }

    public static class OptionalFiltersDeserializer
    extends StdDeserializer<OptionalFilters> {
        public OptionalFiltersDeserializer() {
            this(OptionalFilters.class);
        }

        public OptionalFiltersDeserializer(Class<?> vc) {
            super(vc);
        }

        public OptionalFilters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isArray()) {
                OptionalFilters optionalFilters;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<MixedSearchFilters>>(){});
                        optionalFilters = OptionalFilters.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<MixedSearchFilters> (error: " + e.getMessage() + ") (type: List<MixedSearchFilters>)");
                        }
                    }
                    parser.close();
                }
                return optionalFilters;
            }
            if (tree.isValueNode()) {
                OptionalFilters optionalFilters;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs((TypeReference)new TypeReference<String>(){});
                        optionalFilters = OptionalFilters.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return optionalFilters;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public OptionalFilters getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "OptionalFilters cannot be null");
        }
    }

    public static class OptionalFiltersSerializer
    extends StdSerializer<OptionalFilters> {
        public OptionalFiltersSerializer(Class<OptionalFilters> t) {
            super(t);
        }

        public OptionalFiltersSerializer() {
            this(null);
        }

        public void serialize(OptionalFilters value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

