/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.RecommendationsQuery;
import com.algolia.model.recommend.RecommendationsRequestRecommendationsQuery;
import com.algolia.model.recommend.RecommendationsRequestTrendingFacetsQuery;
import com.algolia.model.recommend.RecommendationsRequestTrendingItemsQuery;
import com.algolia.model.recommend.TrendingFacetsQuery;
import com.algolia.model.recommend.TrendingItemsQuery;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=RecommendationsRequestDeserializer.class)
@JsonSerialize(using=RecommendationsRequestSerializer.class)
public abstract class RecommendationsRequest
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(RecommendationsRequest.class.getName());

    public static RecommendationsRequest of(RecommendationsQuery inside) {
        return new RecommendationsRequestRecommendationsQuery(inside);
    }

    public static RecommendationsRequest of(TrendingFacetsQuery inside) {
        return new RecommendationsRequestTrendingFacetsQuery(inside);
    }

    public static RecommendationsRequest of(TrendingItemsQuery inside) {
        return new RecommendationsRequestTrendingItemsQuery(inside);
    }

    public static class RecommendationsRequestDeserializer
    extends StdDeserializer<RecommendationsRequest> {
        public RecommendationsRequestDeserializer() {
            this(RecommendationsRequest.class);
        }

        public RecommendationsRequestDeserializer(Class<?> vc) {
            super(vc);
        }

        public RecommendationsRequest deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject()) {
                RecommendationsRequest recommendationsRequest;
                block27: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        RecommendationsQuery value = (RecommendationsQuery)parser.readValueAs((TypeReference)new TypeReference<RecommendationsQuery>(){});
                        recommendationsRequest = RecommendationsRequest.of(value);
                        if (parser == null) break block27;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf RecommendationsQuery (error: " + e.getMessage() + ") (type: RecommendationsQuery)");
                        }
                    }
                    parser.close();
                }
                return recommendationsRequest;
            }
            if (tree.isObject()) {
                RecommendationsRequest recommendationsRequest;
                block28: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        TrendingFacetsQuery value = (TrendingFacetsQuery)parser.readValueAs((TypeReference)new TypeReference<TrendingFacetsQuery>(){});
                        recommendationsRequest = RecommendationsRequest.of(value);
                        if (parser == null) break block28;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf TrendingFacetsQuery (error: " + e.getMessage() + ") (type: TrendingFacetsQuery)");
                        }
                    }
                    parser.close();
                }
                return recommendationsRequest;
            }
            if (tree.isObject()) {
                RecommendationsRequest recommendationsRequest;
                block29: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        TrendingItemsQuery value = (TrendingItemsQuery)parser.readValueAs((TypeReference)new TypeReference<TrendingItemsQuery>(){});
                        recommendationsRequest = RecommendationsRequest.of(value);
                        if (parser == null) break block29;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf TrendingItemsQuery (error: " + e.getMessage() + ") (type: TrendingItemsQuery)");
                        }
                    }
                    parser.close();
                }
                return recommendationsRequest;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public RecommendationsRequest getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "RecommendationsRequest cannot be null");
        }
    }

    public static class RecommendationsRequestSerializer
    extends StdSerializer<RecommendationsRequest> {
        public RecommendationsRequestSerializer(Class<RecommendationsRequest> t) {
            super(t);
        }

        public RecommendationsRequestSerializer() {
            this(null);
        }

        public void serialize(RecommendationsRequest value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

