/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.IgnorePluralsBoolean;
import com.algolia.model.search.IgnorePluralsListOfString;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=IgnorePluralsDeserializer.class)
@JsonSerialize(using=IgnorePluralsSerializer.class)
public abstract class IgnorePlurals
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(IgnorePlurals.class.getName());

    public static IgnorePlurals of(Boolean inside) {
        return new IgnorePluralsBoolean(inside);
    }

    public static IgnorePlurals of(List<String> inside) {
        return new IgnorePluralsListOfString(inside);
    }

    public static class IgnorePluralsDeserializer
    extends StdDeserializer<IgnorePlurals> {
        public IgnorePluralsDeserializer() {
            this(IgnorePlurals.class);
        }

        public IgnorePluralsDeserializer(Class<?> vc) {
            super(vc);
        }

        public IgnorePlurals deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isValueNode()) {
                IgnorePlurals ignorePlurals;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Boolean value = (Boolean)parser.readValueAs((TypeReference)new TypeReference<Boolean>(){});
                        ignorePlurals = IgnorePlurals.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
                        }
                    }
                    parser.close();
                }
                return ignorePlurals;
            }
            if (tree.isArray()) {
                IgnorePlurals ignorePlurals;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<String>>(){});
                        ignorePlurals = IgnorePlurals.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
                        }
                    }
                    parser.close();
                }
                return ignorePlurals;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public IgnorePlurals getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "IgnorePlurals cannot be null");
        }
    }

    public static class IgnorePluralsSerializer
    extends StdSerializer<IgnorePlurals> {
        public IgnorePluralsSerializer(Class<IgnorePlurals> t) {
            super(t);
        }

        public IgnorePluralsSerializer() {
            this(null);
        }

        public void serialize(IgnorePlurals value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

