/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.RemoveStopWordsBoolean;
import com.algolia.model.search.RemoveStopWordsListOfString;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=RemoveStopWordsDeserializer.class)
@JsonSerialize(using=RemoveStopWordsSerializer.class)
public abstract class RemoveStopWords
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(RemoveStopWords.class.getName());

    public static RemoveStopWords of(Boolean inside) {
        return new RemoveStopWordsBoolean(inside);
    }

    public static RemoveStopWords of(List<String> inside) {
        return new RemoveStopWordsListOfString(inside);
    }

    public static class RemoveStopWordsDeserializer
    extends StdDeserializer<RemoveStopWords> {
        public RemoveStopWordsDeserializer() {
            this(RemoveStopWords.class);
        }

        public RemoveStopWordsDeserializer(Class<?> vc) {
            super(vc);
        }

        public RemoveStopWords deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isValueNode()) {
                RemoveStopWords removeStopWords;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Boolean value = (Boolean)parser.readValueAs((TypeReference)new TypeReference<Boolean>(){});
                        removeStopWords = RemoveStopWords.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
                        }
                    }
                    parser.close();
                }
                return removeStopWords;
            }
            if (tree.isArray()) {
                RemoveStopWords removeStopWords;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<String>>(){});
                        removeStopWords = RemoveStopWords.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
                        }
                    }
                    parser.close();
                }
                return removeStopWords;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public RemoveStopWords getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "RemoveStopWords cannot be null");
        }
    }

    public static class RemoveStopWordsSerializer
    extends StdSerializer<RemoveStopWords> {
        public RemoveStopWordsSerializer(Class<RemoveStopWords> t) {
            super(t);
        }

        public RemoveStopWordsSerializer() {
            this(null);
        }

        public void serialize(RemoveStopWords value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

