/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.SearchForFacets;
import com.algolia.model.search.SearchForHits;
import com.algolia.model.search.SearchQuerySearchForFacets;
import com.algolia.model.search.SearchQuerySearchForHits;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=SearchQueryDeserializer.class)
@JsonSerialize(using=SearchQuerySerializer.class)
public abstract class SearchQuery
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(SearchQuery.class.getName());

    public static SearchQuery of(SearchForFacets inside) {
        return new SearchQuerySearchForFacets(inside);
    }

    public static SearchQuery of(SearchForHits inside) {
        return new SearchQuerySearchForHits(inside);
    }

    public static class SearchQueryDeserializer
    extends StdDeserializer<SearchQuery> {
        public SearchQueryDeserializer() {
            this(SearchQuery.class);
        }

        public SearchQueryDeserializer(Class<?> vc) {
            super(vc);
        }

        public SearchQuery deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject()) {
                SearchQuery searchQuery;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        SearchForFacets value = (SearchForFacets)parser.readValueAs((TypeReference)new TypeReference<SearchForFacets>(){});
                        searchQuery = SearchQuery.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchForFacets (error: " + e.getMessage() + ") (type: SearchForFacets)");
                        }
                    }
                    parser.close();
                }
                return searchQuery;
            }
            if (tree.isObject()) {
                SearchQuery searchQuery;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        SearchForHits value = (SearchForHits)parser.readValueAs((TypeReference)new TypeReference<SearchForHits>(){});
                        searchQuery = SearchQuery.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchForHits (error: " + e.getMessage() + ") (type: SearchForHits)");
                        }
                    }
                    parser.close();
                }
                return searchQuery;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public SearchQuery getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "SearchQuery cannot be null");
        }
    }

    public static class SearchQuerySerializer
    extends StdSerializer<SearchQuery> {
        public SearchQuerySerializer(Class<SearchQuery> t) {
            super(t);
        }

        public SearchQuerySerializer() {
            this(null);
        }

        public void serialize(SearchQuery value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

