/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.SearchForFacetValuesResponse;
import com.algolia.model.search.SearchResponse;
import com.algolia.model.search.SearchResultSearchForFacetValuesResponse;
import com.algolia.model.search.SearchResultSearchResponse;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=SearchResultDeserializer.class)
@JsonSerialize(using=SearchResultSerializer.class)
public abstract class SearchResult<T>
implements CompoundType {
    private static final Logger LOGGER = Logger.getLogger(SearchResult.class.getName());

    public static SearchResult of(SearchForFacetValuesResponse inside) {
        return new SearchResultSearchForFacetValuesResponse(inside);
    }

    public static SearchResult of(SearchResponse inside) {
        return new SearchResultSearchResponse(inside);
    }

    public static class SearchResultDeserializer
    extends StdDeserializer<SearchResult> {
        public SearchResultDeserializer() {
            this(SearchResult.class);
        }

        public SearchResultDeserializer(Class<?> vc) {
            super(vc);
        }

        public SearchResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("facetHits")) {
                SearchResult searchResult;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        SearchForFacetValuesResponse value = (SearchForFacetValuesResponse)parser.readValueAs((TypeReference)new TypeReference<SearchForFacetValuesResponse>(){});
                        searchResult = SearchResult.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchForFacetValuesResponse (error: " + e.getMessage() + ") (type: SearchForFacetValuesResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            if (tree.isObject()) {
                SearchResult searchResult;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        SearchResponse value = (SearchResponse)parser.readValueAs((TypeReference)new TypeReference<SearchResponse>(){});
                        searchResult = SearchResult.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchResponse (error: " + e.getMessage() + ") (type: SearchResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public SearchResult getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "SearchResult cannot be null");
        }
    }

    public static class SearchResultSerializer
    extends StdSerializer<SearchResult> {
        public SearchResultSerializer(Class<SearchResult> t) {
            super(t);
        }

        public SearchResultSerializer() {
            this(null);
        }

        public void serialize(SearchResult value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getInsideValue());
        }
    }
}

