/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils;

import java.util.LinkedHashSet;
import java.util.Set;

public class AlgoliaAgent {
    private final Set<String> segments;
    private String finalValue;

    public AlgoliaAgent(String clientVersion) {
        this.finalValue = String.format("Algolia for Java (%s)", clientVersion);
        this.segments = new LinkedHashSet<String>();
        this.addSegment(new Segment("JVM", System.getProperty("java.version")));
    }

    public String addSegment(Segment seg) {
        String segment = seg.toString();
        if (this.segments.contains(segment)) {
            return this.finalValue;
        }
        this.segments.add(segment);
        this.finalValue = this.finalValue + segment;
        return this.finalValue;
    }

    public boolean removeSegment(Segment seg) {
        return this.segments.remove(seg.toString());
    }

    public String toString() {
        return this.finalValue;
    }

    public static class Segment {
        private final String value;
        private final String version;

        public Segment(String value) {
            this(value, null);
        }

        public Segment(String value, String version) {
            this.value = value;
            this.version = version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("; ").append(this.value);
            if (this.version != null) {
                sb.append(" (").append(this.version).append(")");
            }
            return sb.toString();
        }
    }
}

