/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils;

import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.JSONBuilder;
import com.algolia.utils.LogLevel;
import com.algolia.utils.Requester;
import com.algolia.utils.retry.RetryStrategy;
import com.algolia.utils.retry.StatefulHost;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpRequester
implements Requester {
    private RetryStrategy retryStrategy = new RetryStrategy();
    private OkHttpClient httpClient;
    private HttpLoggingInterceptor loggingInterceptor;
    private LogLevel level;
    private ObjectMapper json;

    public HttpRequester() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor(this.retryStrategy.getRetryInterceptor());
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.loggingInterceptor.setLevel(LogLevel.NONE.value());
        builder.addInterceptor((Interceptor)this.loggingInterceptor);
        builder.retryOnConnectionFailure(false);
        this.httpClient = builder.build();
        this.json = new JSONBuilder().build();
    }

    @Override
    public Call newCall(Request request) {
        return this.httpClient.newCall(request);
    }

    @Override
    public <T> T handleResponse(Response response, JavaType returnType) throws AlgoliaRuntimeException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (Exception e) {
                        throw new AlgoliaApiException(response.message(), e, response.code());
                    }
                }
                return null;
            }
            return this.deserialize(response, returnType);
        }
        if (response.body() != null) {
            try {
                response.body().string();
            }
            catch (IOException e) {
                throw new AlgoliaApiException(response.message(), e, response.code());
            }
        }
        throw new AlgoliaApiException(response.message(), response.code());
    }

    private <T> T deserialize(Response response, JavaType returnType) throws AlgoliaRuntimeException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("[byte".equals(returnType.getRawClass().getName())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new AlgoliaRuntimeException(e);
            }
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        try {
            return (T)this.json.readValue(respBody, returnType);
        }
        catch (JsonProcessingException e) {
            throw new AlgoliaRuntimeException(e);
        }
    }

    @Override
    public void setLogLevel(LogLevel level) {
        if (level != this.level) {
            this.loggingInterceptor.setLevel(level.value());
        }
        this.level = level;
    }

    @Override
    public int getConnectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    @Override
    public void setConnectTimeout(int connectionTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getReadTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.httpClient = this.httpClient.newBuilder().readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getWriteTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
        this.httpClient = this.httpClient.newBuilder().writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setHosts(List<StatefulHost> hosts) {
        this.retryStrategy.setHosts(hosts);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.httpClient = this.httpClient.newBuilder().addInterceptor(interceptor).build();
    }
}

