/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;

public class JSONBuilder {
    private boolean failOnUnknown = false;

    public JSONBuilder failOnUnknown(boolean failOnUnknown) {
        this.failOnUnknown = failOnUnknown;
        return this;
    }

    public ObjectMapper build() {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS})).build();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failOnUnknown);
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT});
        mapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        mapper.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        return mapper;
    }
}

