/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils.retry;

import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaRetryException;
import com.algolia.utils.UseReadTransporter;
import com.algolia.utils.Utils;
import com.algolia.utils.retry.CallType;
import com.algolia.utils.retry.StatefulHost;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryStrategy {
    private List<StatefulHost> hosts = new ArrayList<StatefulHost>();

    public Interceptor getRetryInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                UseReadTransporter useReadTransporter = (UseReadTransporter)request.tag();
                Iterator<StatefulHost> hostsIter = RetryStrategy.this.getTryableHosts(useReadTransporter != null || request.method().equals("GET") ? CallType.READ : CallType.WRITE).iterator();
                try {
                    while (hostsIter.hasNext()) {
                        StatefulHost currentHost = hostsIter.next();
                        HttpUrl newUrl = request.url().newBuilder().scheme(currentHost.getScheme()).host(currentHost.getHost()).build();
                        request = request.newBuilder().url(newUrl).build();
                        chain.withConnectTimeout(chain.connectTimeoutMillis() + currentHost.getRetryCount() * 1000, TimeUnit.MILLISECONDS);
                        try {
                            Response response = chain.proceed(request);
                            currentHost.setLastUse(Utils.nowUTC());
                            if (response.isSuccessful()) {
                                currentHost.setUp(true);
                                return response;
                            }
                            if (RetryStrategy.this.isRetryable(response)) {
                                currentHost.setUp(false);
                                response.close();
                                continue;
                            }
                            String message = response.message();
                            if (response.body() != null) {
                                message = response.body().string();
                            }
                            throw new AlgoliaApiException(message, response.code());
                        }
                        catch (AlgoliaApiException e) {
                            throw e;
                        }
                        catch (SocketTimeoutException e) {
                            currentHost.setUp(true);
                            currentHost.setLastUse(Utils.nowUTC());
                            currentHost.incrementRetryCount();
                        }
                        catch (UnknownHostException e) {
                            throw new AlgoliaApiException(e.getMessage(), 404);
                        }
                        catch (Exception e) {
                            throw new AlgoliaApiException(e.getMessage(), 400);
                        }
                    }
                    throw new AlgoliaRetryException("All hosts are unreachable");
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private boolean isRetryable(Response response) {
        return response.code() / 100 != 2 && response.code() / 100 != 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StatefulHost> getTryableHosts(CallType callType) {
        RetryStrategy retryStrategy = this;
        synchronized (retryStrategy) {
            this.resetExpiredHosts();
            if (this.hosts.stream().anyMatch(h -> h.isUp() && h.getAccept().contains((Object)callType))) {
                return this.hosts.stream().filter(h -> h.isUp() && h.getAccept().contains((Object)callType)).collect(Collectors.toList());
            }
            for (StatefulHost host : this.hosts.stream().filter(h -> h.getAccept().contains((Object)callType)).collect(Collectors.toList())) {
                this.reset(host);
            }
            return this.hosts;
        }
    }

    private void reset(StatefulHost host) {
        host.setUp(true).setRetryCount(0).setLastUse(Utils.nowUTC());
    }

    private void resetExpiredHosts() {
        for (StatefulHost host : this.hosts) {
            long lastUse = Duration.between(Utils.nowUTC(), host.getLastUse()).getSeconds();
            if (host.isUp() || Math.abs(lastUse) <= 300L) continue;
            this.reset(host);
        }
    }

    public void setHosts(List<StatefulHost> hosts) {
        this.hosts = hosts;
    }
}

