// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** API key object. */
public class ApiKey {

  @JsonProperty("acl")
  private List<Acl> acl = new ArrayList<>();

  @JsonProperty("description")
  private String description;

  @JsonProperty("indexes")
  private List<String> indexes;

  @JsonProperty("maxHitsPerQuery")
  private Integer maxHitsPerQuery;

  @JsonProperty("maxQueriesPerIPPerHour")
  private Integer maxQueriesPerIPPerHour;

  @JsonProperty("queryParameters")
  private String queryParameters;

  @JsonProperty("referers")
  private List<String> referers;

  @JsonProperty("validity")
  private Integer validity;

  public ApiKey setAcl(List<Acl> acl) {
    this.acl = acl;
    return this;
  }

  public ApiKey addAcl(Acl aclItem) {
    this.acl.add(aclItem);
    return this;
  }

  /**
   * Permissions that determine the type of API requests this key can make. The required ACL is
   * listed in each endpoint's reference. For more information, see [access control
   * list](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl).
   */
  @javax.annotation.Nonnull
  public List<Acl> getAcl() {
    return acl;
  }

  public ApiKey setDescription(String description) {
    this.description = description;
    return this;
  }

  /** Description of an API key to help you identify this API key. */
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public ApiKey setIndexes(List<String> indexes) {
    this.indexes = indexes;
    return this;
  }

  public ApiKey addIndexes(String indexesItem) {
    if (this.indexes == null) {
      this.indexes = new ArrayList<>();
    }
    this.indexes.add(indexesItem);
    return this;
  }

  /**
   * Index names or patterns that this API key can access. By default, an API key can access all
   * indices in the same application. You can use leading and trailing wildcard characters (`*`): -
   * `dev_*` matches all indices starting with \"dev_\". - `*_dev` matches all indices ending with
   * \"_dev\". - `*_products_*` matches all indices containing \"_products_\".
   */
  @javax.annotation.Nullable
  public List<String> getIndexes() {
    return indexes;
  }

  public ApiKey setMaxHitsPerQuery(Integer maxHitsPerQuery) {
    this.maxHitsPerQuery = maxHitsPerQuery;
    return this;
  }

  /**
   * Maximum number of results this API key can retrieve in one query. By default, there's no limit.
   */
  @javax.annotation.Nullable
  public Integer getMaxHitsPerQuery() {
    return maxHitsPerQuery;
  }

  public ApiKey setMaxQueriesPerIPPerHour(Integer maxQueriesPerIPPerHour) {
    this.maxQueriesPerIPPerHour = maxQueriesPerIPPerHour;
    return this;
  }

  /**
   * Maximum number of API requests allowed per IP address or [user
   * token](https://www.algolia.com/doc/guides/sending-events/concepts/usertoken/) per hour. If this
   * limit is reached, the API returns an error with status code `429`. By default, there's no
   * limit.
   */
  @javax.annotation.Nullable
  public Integer getMaxQueriesPerIPPerHour() {
    return maxQueriesPerIPPerHour;
  }

  public ApiKey setQueryParameters(String queryParameters) {
    this.queryParameters = queryParameters;
    return this;
  }

  /**
   * Query parameters to add when making API requests with this API key. To restrict this API key to
   * specific IP addresses, add the `restrictSources` parameter. You can only add a single source,
   * but you can provide a range of IP addresses. Creating an API key fails if the request is made
   * from an IP address that's outside the restricted range.
   */
  @javax.annotation.Nullable
  public String getQueryParameters() {
    return queryParameters;
  }

  public ApiKey setReferers(List<String> referers) {
    this.referers = referers;
    return this;
  }

  public ApiKey addReferers(String referersItem) {
    if (this.referers == null) {
      this.referers = new ArrayList<>();
    }
    this.referers.add(referersItem);
    return this;
  }

  /**
   * Allowed HTTP referrers for this API key. By default, all referrers are allowed. You can use
   * leading and trailing wildcard characters (`*`): - `https://algolia.com/_*` allows all referrers
   * starting with \"https://algolia.com/\" - `*.algolia.com` allows all referrers ending with
   * \".algolia.com\" - `*algolia.com*` allows all referrers in the domain \"algolia.com\". Like all
   * HTTP headers, referrers can be spoofed. Don't rely on them to secure your data. For more
   * information, see [HTTP referrer
   * restrictions](https://www.algolia.com/doc/guides/security/security-best-practices/#http-referrers-restrictions).
   */
  @javax.annotation.Nullable
  public List<String> getReferers() {
    return referers;
  }

  public ApiKey setValidity(Integer validity) {
    this.validity = validity;
    return this;
  }

  /** Duration (in seconds) after which the API key expires. By default, API keys don't expire. */
  @javax.annotation.Nullable
  public Integer getValidity() {
    return validity;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiKey apiKey = (ApiKey) o;
    return (
      Objects.equals(this.acl, apiKey.acl) &&
      Objects.equals(this.description, apiKey.description) &&
      Objects.equals(this.indexes, apiKey.indexes) &&
      Objects.equals(this.maxHitsPerQuery, apiKey.maxHitsPerQuery) &&
      Objects.equals(this.maxQueriesPerIPPerHour, apiKey.maxQueriesPerIPPerHour) &&
      Objects.equals(this.queryParameters, apiKey.queryParameters) &&
      Objects.equals(this.referers, apiKey.referers) &&
      Objects.equals(this.validity, apiKey.validity)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(acl, description, indexes, maxHitsPerQuery, maxQueriesPerIPPerHour, queryParameters, referers, validity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiKey {\n");
    sb.append("    acl: ").append(toIndentedString(acl)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    indexes: ").append(toIndentedString(indexes)).append("\n");
    sb.append("    maxHitsPerQuery: ").append(toIndentedString(maxHitsPerQuery)).append("\n");
    sb.append("    maxQueriesPerIPPerHour: ").append(toIndentedString(maxQueriesPerIPPerHour)).append("\n");
    sb.append("    queryParameters: ").append(toIndentedString(queryParameters)).append("\n");
    sb.append("    referers: ").append(toIndentedString(referers)).append("\n");
    sb.append("    validity: ").append(toIndentedString(validity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
