/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public final class AlgoliaAgent {
    private final Set<String> segments;
    private String finalValue;

    public AlgoliaAgent(String clientVersion) {
        this.finalValue = String.format("Algolia for Java (%s)", clientVersion);
        this.segments = new LinkedHashSet<String>();
        this.addSegment(new Segment("JVM", System.getProperty("java.version")));
    }

    public AlgoliaAgent addSegment(@Nonnull Segment seg) {
        String segment = seg.toString();
        if (!this.segments.contains(segment)) {
            this.segments.add(segment);
            this.finalValue = this.finalValue + segment;
        }
        return this;
    }

    public AlgoliaAgent addSegments(@Nonnull List<Segment> segments) {
        for (Segment segment : segments) {
            this.addSegment(segment);
        }
        return this;
    }

    public AlgoliaAgent removeSegment(@Nonnull Segment seg) {
        this.segments.remove(seg.toString());
        return this;
    }

    public String toString() {
        return this.finalValue;
    }

    public static class Segment {
        private final String value;
        private final String version;

        public Segment(String value) {
            this(value, null);
        }

        public Segment(String value, String version) {
            this.value = value;
            this.version = version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("; ").append(this.value);
            if (this.version != null) {
                sb.append(" (").append(this.version).append(")");
            }
            return sb.toString();
        }
    }
}

